/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.client;

import com.mumfrey.liteloader.LiteMod;
import com.mumfrey.liteloader.api.ModLoadObserver;
import com.mumfrey.liteloader.common.Resources;
import com.mumfrey.liteloader.core.LiteLoader;
import com.mumfrey.liteloader.core.ModInfo;
import com.mumfrey.liteloader.interfaces.LoadableMod;
import com.mumfrey.liteloader.resources.ModResourcePack;
import com.mumfrey.liteloader.resources.ModResourcePackDir;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class ResourceObserver
implements ModLoadObserver {
    private final Map<String, bnk> resourcePacks = new HashMap<String, bnk>();

    @Override
    public void onModLoaded(LiteMod mod) {
    }

    @Override
    public void onPostModLoaded(ModInfo<LoadableMod<?>> handle) {
        if (!handle.hasContainer()) {
            return;
        }
        LoadableMod<?> container = handle.getContainer();
        String modName = handle.getMod().getName();
        if (modName == null) {
            return;
        }
        if (container.hasResources()) {
            LiteLoaderLogger.info("Adding \"%s\" to active resource pack set", container.getLocation());
            bnk resourcePack = this.initResourcePack(container, modName);
            Resources<?, ?> resources = LiteLoader.getGameEngine().getResources();
            if (resources.registerResourcePack(resourcePack)) {
                LiteLoaderLogger.info("Successfully added \"%s\" to active resource pack set", container.getLocation());
            }
        }
    }

    public bnk initResourcePack(LoadableMod<?> container, String name) {
        Object resourcePack = this.getResourcePack(container);
        if (resourcePack == null) {
            if (container.isDirectory()) {
                LiteLoaderLogger.info("Setting up \"%s/%s\" as mod resource pack with identifier \"%s\"", container.toFile().getParentFile().getName(), container.getName(), name);
                resourcePack = new ModResourcePackDir(name, container.toFile());
            } else {
                LiteLoaderLogger.info("Setting up \"%s\" as mod resource pack with identifier \"%s\"", container.getName(), name);
                resourcePack = new ModResourcePack(name, container.toFile());
            }
            this.setResourcePack(container, (bnk)resourcePack);
        }
        return resourcePack;
    }

    private bnk getResourcePack(LoadableMod<?> container) {
        String path = container.getLocation();
        return this.resourcePacks.get(path);
    }

    private void setResourcePack(LoadableMod<?> container, bnk resourcePack) {
        String path = container.getLocation();
        this.resourcePacks.put(path, resourcePack);
    }

    @Override
    public void onModLoadFailed(LoadableMod<?> container, String identifier, String reason, Throwable th) {
    }

    @Override
    public void onPreInitMod(LiteMod mod) {
    }

    @Override
    public void onPostInitMod(LiteMod mod) {
    }

    @Override
    public void onMigrateModConfig(LiteMod mod, File newConfigPath, File oldConfigPath) {
    }
}

