/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.asm.transformers;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModAPIManager;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.relauncher.FMLRelaunchLog;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class ModAPITransformer
implements IClassTransformer {
    private static final boolean logDebugInfo = Boolean.valueOf(System.getProperty("fml.debugAPITransformer", "false"));
    private ListMultimap<String, ASMDataTable.ASMData> optionals;

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        String lookupName = name;
        if (name.endsWith("$class")) {
            lookupName = name.substring(0, name.length() - 6);
        }
        if (this.optionals == null || !this.optionals.containsKey((Object)lookupName)) {
            return basicClass;
        }
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        if (logDebugInfo) {
            FMLRelaunchLog.finer("Optional removal - found optionals for class %s - processing", name);
        }
        for (ASMDataTable.ASMData optional : this.optionals.get((Object)lookupName)) {
            String modId = (String)optional.getAnnotationInfo().get("modid");
            if (Loader.isModLoaded(modId) || ModAPIManager.INSTANCE.hasAPI(modId)) {
                if (!logDebugInfo) continue;
                FMLRelaunchLog.finer("Optional removal skipped - mod present %s", modId);
                continue;
            }
            if (logDebugInfo) {
                FMLRelaunchLog.finer("Optional on %s triggered - mod missing %s", name, modId);
            }
            if (optional.getAnnotationInfo().containsKey("iface")) {
                Boolean stripRefs = (Boolean)optional.getAnnotationInfo().get("striprefs");
                if (stripRefs == null) {
                    stripRefs = Boolean.FALSE;
                }
                this.stripInterface(classNode, (String)optional.getAnnotationInfo().get("iface"), stripRefs);
                continue;
            }
            this.stripMethod(classNode, optional.getObjectName());
        }
        if (logDebugInfo) {
            FMLRelaunchLog.finer("Optional removal - class %s processed", name);
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private void stripMethod(ClassNode classNode, String methodDescriptor) {
        if (classNode.name.endsWith("$class")) {
            String subName = classNode.name.substring(0, classNode.name.length() - 6);
            int pos = methodDescriptor.indexOf(40) + 1;
            methodDescriptor = methodDescriptor.substring(0, pos) + 'L' + subName + ';' + methodDescriptor.substring(pos);
        }
        ListIterator iterator = classNode.methods.listIterator();
        while (iterator.hasNext()) {
            MethodNode method = (MethodNode)iterator.next();
            if (!methodDescriptor.equals(method.name + method.desc)) continue;
            iterator.remove();
            if (logDebugInfo) {
                FMLRelaunchLog.finer("Optional removal - method %s removed", methodDescriptor);
            }
            return;
        }
        if (logDebugInfo) {
            FMLRelaunchLog.finer("Optional removal - method %s NOT removed - not found", methodDescriptor);
        }
    }

    private void stripInterface(ClassNode classNode, String interfaceName, boolean stripRefs) {
        String ifaceName = interfaceName.replace('.', '/');
        boolean found = classNode.interfaces.remove(ifaceName);
        if (found && logDebugInfo) {
            FMLRelaunchLog.finer("Optional removal - interface %s removed", interfaceName);
        }
        if (!found && logDebugInfo) {
            FMLRelaunchLog.finer("Optional removal - interface %s NOT removed - not found", interfaceName);
        }
        if (found && stripRefs) {
            if (logDebugInfo) {
                FMLRelaunchLog.finer("Optional removal - interface %s - stripping method signature references", interfaceName);
            }
            Iterator iterator = classNode.methods.iterator();
            while (iterator.hasNext()) {
                MethodNode node = (MethodNode)iterator.next();
                if (!node.desc.contains(ifaceName)) continue;
                if (logDebugInfo) {
                    FMLRelaunchLog.finer("Optional removal - interface %s - stripping method containing reference %s", interfaceName, node.name);
                }
                iterator.remove();
            }
            if (logDebugInfo) {
                FMLRelaunchLog.finer("Optional removal - interface %s - all method signature references stripped", interfaceName);
            }
        } else if (found && logDebugInfo) {
            FMLRelaunchLog.finer("Optional removal - interface %s - NOT stripping method signature references", interfaceName);
        }
    }

    public void initTable(ASMDataTable dataTable) {
        this.optionals = ArrayListMultimap.create();
        Set<ASMDataTable.ASMData> interfaceLists = dataTable.getAll("net.minecraftforge.fml.common.Optional$InterfaceList");
        this.addData(this.unpackInterfaces(interfaceLists));
        Set<ASMDataTable.ASMData> interfaces = dataTable.getAll("net.minecraftforge.fml.common.Optional$Interface");
        this.addData(interfaces);
        Set<ASMDataTable.ASMData> methods = dataTable.getAll("net.minecraftforge.fml.common.Optional$Method");
        this.addData(methods);
    }

    private Set<ASMDataTable.ASMData> unpackInterfaces(Set<ASMDataTable.ASMData> packedInterfaces) {
        HashSet result = Sets.newHashSet();
        for (ASMDataTable.ASMData data : packedInterfaces) {
            List packedList = (List)data.getAnnotationInfo().get("value");
            for (Map packed : packedList) {
                ASMDataTable.ASMData newData = data.copy(packed);
                result.add(newData);
            }
        }
        return result;
    }

    private void addData(Set<ASMDataTable.ASMData> interfaces) {
        for (ASMDataTable.ASMData data : interfaces) {
            this.optionals.put((Object)data.getClassName(), (Object)data);
        }
    }
}

