/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event;

import java.io.File;
import java.util.EnumSet;
import java.util.List;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.CapabilityDispatcher;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.brewing.PotionBrewEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingPackSizeEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.living.ZombieEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerFlyableFallEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSetSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.entity.player.PlayerUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.entity.player.SleepingLocationCheckEvent;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ForgeEventFactory {
    public static BlockEvent.MultiPlaceEvent onPlayerMultiBlockPlace(wn player, List<BlockSnapshot> blockSnapshots, cq direction) {
        BlockSnapshot snap = blockSnapshots.get(0);
        alz placedAgainst = snap.world.p(snap.pos.a(direction.d()));
        BlockEvent.MultiPlaceEvent event = new BlockEvent.MultiPlaceEvent(blockSnapshots, placedAgainst, player);
        MinecraftForge.EVENT_BUS.post(event);
        return event;
    }

    public static BlockEvent.PlaceEvent onPlayerBlockPlace(wn player, BlockSnapshot blockSnapshot, cq direction) {
        alz placedAgainst = blockSnapshot.world.p(blockSnapshot.pos.a(direction.d()));
        BlockEvent.PlaceEvent event = new BlockEvent.PlaceEvent(blockSnapshot, placedAgainst, player);
        MinecraftForge.EVENT_BUS.post(event);
        return event;
    }

    public static BlockEvent.NeighborNotifyEvent onNeighborNotify(adm world, cj pos, alz state, EnumSet<cq> notifiedSides) {
        BlockEvent.NeighborNotifyEvent event = new BlockEvent.NeighborNotifyEvent(world, pos, state, notifiedSides);
        MinecraftForge.EVENT_BUS.post(event);
        return event;
    }

    public static boolean doPlayerHarvestCheck(wn player, afh block, boolean success) {
        PlayerEvent.HarvestCheck event = new PlayerEvent.HarvestCheck(player, block, success);
        MinecraftForge.EVENT_BUS.post(event);
        return event.success;
    }

    public static float getBreakSpeed(wn player, alz state, float original, cj pos) {
        PlayerEvent.BreakSpeed event = new PlayerEvent.BreakSpeed(player, state, original, pos);
        return MinecraftForge.EVENT_BUS.post(event) ? -1.0f : event.newSpeed;
    }

    @Deprecated
    public static PlayerInteractEvent onPlayerInteract(wn player, PlayerInteractEvent.Action action, adm world, cj pos, cq face) {
        return ForgeEventFactory.onPlayerInteract(player, action, world, pos, face, null);
    }

    public static PlayerInteractEvent onPlayerInteract(wn player, PlayerInteractEvent.Action action, adm world, cj pos, cq face, aui localPos) {
        PlayerInteractEvent event = new PlayerInteractEvent(player, action, pos, face, world, localPos);
        MinecraftForge.EVENT_BUS.post(event);
        return event;
    }

    public static void onPlayerDestroyItem(wn player, zx stack) {
        MinecraftForge.EVENT_BUS.post(new PlayerDestroyItemEvent(player, stack));
    }

    public static Event.Result canEntitySpawn(ps entity, adm world, float x, float y, float z) {
        LivingSpawnEvent.CheckSpawn event = new LivingSpawnEvent.CheckSpawn(entity, world, x, y, z);
        MinecraftForge.EVENT_BUS.post(event);
        return event.getResult();
    }

    public static boolean doSpecialSpawn(ps entity, adm world, float x, float y, float z) {
        return MinecraftForge.EVENT_BUS.post(new LivingSpawnEvent.SpecialSpawn(entity, world, x, y, z));
    }

    public static Event.Result canEntityDespawn(ps entity) {
        LivingSpawnEvent.AllowDespawn event = new LivingSpawnEvent.AllowDespawn(entity);
        MinecraftForge.EVENT_BUS.post(event);
        return event.getResult();
    }

    public static int getExperienceDrop(pr entity, wn attackingPlayer, int originalExperience) {
        LivingExperienceDropEvent event = new LivingExperienceDropEvent(entity, attackingPlayer, originalExperience);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return 0;
        }
        return event.getDroppedExperience();
    }

    public static List<ady.c> getPotentialSpawns(le world, pt type, cj pos, List<ady.c> oldList) {
        WorldEvent.PotentialSpawns event = new WorldEvent.PotentialSpawns((adm)world, type, pos, oldList);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return null;
        }
        return event.list;
    }

    public static int getMaxSpawnPackSize(ps entity) {
        LivingPackSizeEvent maxCanSpawnEvent = new LivingPackSizeEvent(entity);
        MinecraftForge.EVENT_BUS.post(maxCanSpawnEvent);
        return maxCanSpawnEvent.getResult() == Event.Result.ALLOW ? maxCanSpawnEvent.maxPackSize : entity.bV();
    }

    public static String getPlayerDisplayName(wn player, String username) {
        PlayerEvent.NameFormat event = new PlayerEvent.NameFormat(player, username);
        MinecraftForge.EVENT_BUS.post(event);
        return event.displayname;
    }

    public static float fireBlockHarvesting(List<zx> drops, adm world, cj pos, alz state, int fortune, float dropChance, boolean silkTouch, wn player) {
        BlockEvent.HarvestDropsEvent event = new BlockEvent.HarvestDropsEvent(world, pos, state, fortune, dropChance, drops, player, silkTouch);
        MinecraftForge.EVENT_BUS.post(event);
        return event.dropChance;
    }

    public static ItemTooltipEvent onItemTooltip(zx itemStack, wn entityPlayer, List<String> toolTip, boolean showAdvancedItemTooltips) {
        ItemTooltipEvent event = new ItemTooltipEvent(itemStack, entityPlayer, toolTip, showAdvancedItemTooltips);
        MinecraftForge.EVENT_BUS.post(event);
        return event;
    }

    public static ZombieEvent.SummonAidEvent fireZombieSummonAid(we zombie, adm world, int x, int y, int z, pr attacker, double summonChance) {
        ZombieEvent.SummonAidEvent summonEvent = new ZombieEvent.SummonAidEvent(zombie, world, x, y, z, attacker, summonChance);
        MinecraftForge.EVENT_BUS.post(summonEvent);
        return summonEvent;
    }

    public static boolean onEntityStruckByLightning(pk entity, uv bolt) {
        return MinecraftForge.EVENT_BUS.post(new EntityStruckByLightningEvent(entity, bolt));
    }

    public static int onItemUseStart(wn player, zx item, int duration) {
        PlayerUseItemEvent.Start event = new PlayerUseItemEvent.Start(player, item, duration);
        return MinecraftForge.EVENT_BUS.post(event) ? -1 : event.duration;
    }

    public static int onItemUseTick(wn player, zx item, int duration) {
        PlayerUseItemEvent.Tick event = new PlayerUseItemEvent.Tick(player, item, duration);
        return MinecraftForge.EVENT_BUS.post(event) ? -1 : event.duration;
    }

    public static boolean onUseItemStop(wn player, zx item, int duration) {
        return MinecraftForge.EVENT_BUS.post(new PlayerUseItemEvent.Stop(player, item, duration));
    }

    public static zx onItemUseFinish(wn player, zx item, int duration, zx result) {
        PlayerUseItemEvent.Finish event = new PlayerUseItemEvent.Finish(player, item, duration, result);
        MinecraftForge.EVENT_BUS.post(event);
        return event.result;
    }

    public static void onStartEntityTracking(pk entity, wn player) {
        MinecraftForge.EVENT_BUS.post(new PlayerEvent.StartTracking(player, entity));
    }

    public static void onStopEntityTracking(pk entity, wn player) {
        MinecraftForge.EVENT_BUS.post(new PlayerEvent.StopTracking(player, entity));
    }

    public static void firePlayerLoadingEvent(wn player, File playerDirectory, String uuidString) {
        MinecraftForge.EVENT_BUS.post(new PlayerEvent.LoadFromFile(player, playerDirectory, uuidString));
    }

    public static void firePlayerSavingEvent(wn player, File playerDirectory, String uuidString) {
        MinecraftForge.EVENT_BUS.post(new PlayerEvent.SaveToFile(player, playerDirectory, uuidString));
    }

    public static void firePlayerLoadingEvent(wn player, aty playerFileData, String uuidString) {
        atm sh = (atm)playerFileData;
        File dir = (File)ObfuscationReflectionHelper.getPrivateValue(atm.class, sh, "playersDirectory", "field_75771_c");
        MinecraftForge.EVENT_BUS.post(new PlayerEvent.LoadFromFile(player, dir, uuidString));
    }

    public static eu onClientChat(byte type, eu message) {
        ClientChatReceivedEvent event = new ClientChatReceivedEvent(type, message);
        return MinecraftForge.EVENT_BUS.post(event) ? null : event.message;
    }

    public static int onHoeUse(zx stack, wn player, adm worldIn, cj pos) {
        UseHoeEvent event = new UseHoeEvent(player, stack, worldIn, pos);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return -1;
        }
        if (event.getResult() == Event.Result.ALLOW) {
            stack.a(1, (pr)player);
            return 1;
        }
        return 0;
    }

    public static int onApplyBonemeal(wn player, adm world, cj pos, alz state, zx stack) {
        BonemealEvent event = new BonemealEvent(player, world, pos, state);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return -1;
        }
        if (event.getResult() == Event.Result.ALLOW) {
            if (!world.D) {
                --stack.b;
            }
            return 1;
        }
        return 0;
    }

    public static zx onBucketUse(wn player, adm world, zx stack, auh target) {
        FillBucketEvent event = new FillBucketEvent(player, stack, world, target);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return stack;
        }
        if (event.getResult() == Event.Result.ALLOW) {
            if (player.bA.d) {
                return stack;
            }
            if (--stack.b <= 0) {
                return event.result;
            }
            if (!player.bi.a(event.result)) {
                player.a(event.result, false);
            }
            return stack;
        }
        return null;
    }

    public static boolean canEntityUpdate(pk entity) {
        EntityEvent.CanUpdate event = new EntityEvent.CanUpdate(entity);
        MinecraftForge.EVENT_BUS.post(event);
        return event.canUpdate;
    }

    @Deprecated
    public static String onPlaySoundAt(pk entity, String name, float volume, float pitch) {
        PlaySoundAtEntityEvent event = new PlaySoundAtEntityEvent(entity, name, volume, pitch);
        MinecraftForge.EVENT_BUS.post(event);
        return event.name;
    }

    public static PlaySoundAtEntityEvent onPlaySoundAtEntity(pk entity, String name, float volume, float pitch) {
        PlaySoundAtEntityEvent event = new PlaySoundAtEntityEvent(entity, name, volume, pitch);
        MinecraftForge.EVENT_BUS.post(event);
        return event;
    }

    public static int onItemExpire(uz entity, zx item) {
        if (item == null) {
            return -1;
        }
        ItemExpireEvent event = new ItemExpireEvent(entity, item.b() == null ? 6000 : item.b().getEntityLifespan(item, entity.o));
        if (!MinecraftForge.EVENT_BUS.post(event)) {
            return -1;
        }
        return event.extraLife;
    }

    public static int onItemPickup(uz entityItem, wn entityIn, zx itemstack) {
        EntityItemPickupEvent event = new EntityItemPickupEvent(entityIn, entityItem);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return -1;
        }
        return event.getResult() == Event.Result.ALLOW ? 1 : 0;
    }

    public static void onPlayerDrops(wn player, ow cause, List<uz> capturedDrops, boolean recentlyHit) {
        PlayerDropsEvent event = new PlayerDropsEvent(player, cause, capturedDrops, recentlyHit);
        if (!MinecraftForge.EVENT_BUS.post(event)) {
            for (uz item : capturedDrops) {
                player.a(item);
            }
        }
    }

    public static boolean canInteractWith(wn player, pk entity) {
        return !MinecraftForge.EVENT_BUS.post(new EntityInteractEvent(player, entity));
    }

    public static boolean canMountEntity(pk entityMounting, pk entityBeingMounted, boolean isMounting) {
        boolean isCanceled = MinecraftForge.EVENT_BUS.post(new EntityMountEvent(entityMounting, entityBeingMounted, entityMounting.o, isMounting));
        if (isCanceled) {
            entityMounting.a(entityMounting.s, entityMounting.t, entityMounting.u, entityMounting.A, entityMounting.B);
            return false;
        }
        return true;
    }

    public static wn.a onPlayerSleepInBed(wn player, cj pos) {
        PlayerSleepInBedEvent event = new PlayerSleepInBedEvent(player, pos);
        MinecraftForge.EVENT_BUS.post(event);
        return event.result;
    }

    public static void onPlayerWakeup(wn player, boolean wakeImmediatly, boolean updateWorldFlag, boolean setSpawn) {
        MinecraftForge.EVENT_BUS.post(new PlayerWakeUpEvent(player, wakeImmediatly, updateWorldFlag, setSpawn));
    }

    public static void onPlayerFall(wn player, float distance, float multiplier) {
        MinecraftForge.EVENT_BUS.post(new PlayerFlyableFallEvent(player, distance, multiplier));
    }

    public static boolean onPlayerSpawnSet(wn player, cj pos, boolean forced) {
        return MinecraftForge.EVENT_BUS.post(new PlayerSetSpawnEvent(player, pos, forced));
    }

    public static void onPlayerClone(wn player, wn oldPlayer, boolean wasDeath) {
        MinecraftForge.EVENT_BUS.post(new PlayerEvent.Clone(player, oldPlayer, wasDeath));
    }

    public static boolean onExplosionStart(adm world, adi explosion) {
        return MinecraftForge.EVENT_BUS.post(new ExplosionEvent.Start(world, explosion));
    }

    public static void onExplosionDetonate(adm world, adi explosion, List<pk> list, double diameter) {
        MinecraftForge.EVENT_BUS.post(new ExplosionEvent.Detonate(world, explosion, list));
    }

    public static boolean onCreateWorldSpawn(adm world, adp settings) {
        return MinecraftForge.EVENT_BUS.post(new WorldEvent.CreateSpawnPosition(world, settings));
    }

    public static float onLivingHeal(pr entity, float amount) {
        LivingHealEvent event = new LivingHealEvent(entity, amount);
        return MinecraftForge.EVENT_BUS.post(event) ? 0.0f : event.amount;
    }

    public static boolean onPotionAttemptBreaw(zx[] stacks) {
        zx[] tmp = new zx[stacks.length];
        for (int x = 0; x < tmp.length; ++x) {
            tmp[x] = zx.b((zx)stacks[x]);
        }
        PotionBrewEvent.Pre event = new PotionBrewEvent.Pre(tmp);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            boolean changed = false;
            for (int x = 0; x < stacks.length; ++x) {
                changed |= zx.b((zx)tmp[x], (zx)stacks[x]);
                stacks[x] = event.getItem(x);
            }
            if (changed) {
                ForgeEventFactory.onPotionBrewed(stacks);
            }
            return true;
        }
        return false;
    }

    public static void onPotionBrewed(zx[] brewingItemStacks) {
        MinecraftForge.EVENT_BUS.post(new PotionBrewEvent.Post(brewingItemStacks));
    }

    public static boolean renderFireOverlay(wn player, float renderPartialTicks) {
        return ForgeEventFactory.renderBlockOverlay(player, renderPartialTicks, RenderBlockOverlayEvent.OverlayType.FIRE, afi.ab.Q(), new cj((pk)player));
    }

    public static boolean renderWaterOverlay(wn player, float renderPartialTicks) {
        return ForgeEventFactory.renderBlockOverlay(player, renderPartialTicks, RenderBlockOverlayEvent.OverlayType.WATER, afi.j.Q(), new cj((pk)player));
    }

    public static boolean renderBlockOverlay(wn player, float renderPartialTicks, RenderBlockOverlayEvent.OverlayType type, alz block, cj pos) {
        return MinecraftForge.EVENT_BUS.post(new RenderBlockOverlayEvent(player, renderPartialTicks, type, block, pos));
    }

    public static CapabilityDispatcher gatherCapabilities(akw tileEntity) {
        return ForgeEventFactory.gatherCapabilities(new AttachCapabilitiesEvent.TileEntity(tileEntity), null);
    }

    public static CapabilityDispatcher gatherCapabilities(pk entity) {
        return ForgeEventFactory.gatherCapabilities(new AttachCapabilitiesEvent.Entity(entity), null);
    }

    public static CapabilityDispatcher gatherCapabilities(zw item, zx stack, ICapabilityProvider parent) {
        return ForgeEventFactory.gatherCapabilities(new AttachCapabilitiesEvent.Item(item, stack), parent);
    }

    private static CapabilityDispatcher gatherCapabilities(AttachCapabilitiesEvent event, ICapabilityProvider parent) {
        MinecraftForge.EVENT_BUS.post(event);
        return event.getCapabilities().size() > 0 || parent != null ? new CapabilityDispatcher(event.getCapabilities(), parent) : null;
    }

    public static boolean fireSleepingLocationCheck(wn player, cj sleepingLocation) {
        SleepingLocationCheckEvent evt = new SleepingLocationCheckEvent(player, sleepingLocation);
        MinecraftForge.EVENT_BUS.post(evt);
        Event.Result canContinueSleep = evt.getResult();
        if (canContinueSleep == Event.Result.DEFAULT) {
            return player.o.p(player.bx).c().isBed((adq)player.o, player.bx, (pk)player);
        }
        return canContinueSleep == Event.Result.ALLOW;
    }
}

