/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Random;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidBlock;

public abstract class BlockFluidBase
extends ahu
implements IFluidBlock {
    protected static final Map<ahu, Boolean> defaultDisplacements = Maps.newHashMap();
    protected Map<ahu, Boolean> displacements = Maps.newHashMap();
    protected int quantaPerBlock = 8;
    protected float quantaPerBlockFloat = 8.0f;
    protected int density = 1;
    protected int densityDir = -1;
    protected int temperature = 295;
    protected int tickRate = 20;
    protected int renderPass = 1;
    protected int maxScaledLight = 0;
    protected final String fluidName;

    public BlockFluidBase(Fluid fluid, avf material) {
        super(material);
        this.a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        this.a(true);
        this.H();
        this.fluidName = fluid.getName();
        this.density = fluid.density;
        this.temperature = fluid.temperature;
        this.maxScaledLight = fluid.luminosity;
        this.tickRate = fluid.viscosity / 200;
        this.densityDir = fluid.density > 0 ? -1 : 1;
        fluid.setBlock(this);
        this.displacements.putAll(defaultDisplacements);
    }

    public BlockFluidBase setQuantaPerBlock(int quantaPerBlock) {
        if (quantaPerBlock > 16 || quantaPerBlock < 1) {
            quantaPerBlock = 8;
        }
        this.quantaPerBlock = quantaPerBlock;
        this.quantaPerBlockFloat = quantaPerBlock;
        return this;
    }

    public BlockFluidBase setDensity(int density) {
        if (density == 0) {
            density = 1;
        }
        this.density = density;
        this.densityDir = density > 0 ? -1 : 1;
        return this;
    }

    public BlockFluidBase setTemperature(int temperature) {
        this.temperature = temperature;
        return this;
    }

    public BlockFluidBase setTickRate(int tickRate) {
        if (tickRate <= 0) {
            tickRate = 20;
        }
        this.tickRate = tickRate;
        return this;
    }

    public BlockFluidBase setRenderPass(int renderPass) {
        this.renderPass = renderPass;
        return this;
    }

    public BlockFluidBase setMaxScaledLight(int maxScaledLight) {
        this.maxScaledLight = maxScaledLight;
        return this;
    }

    public boolean canDisplace(afx world, int x, int y2, int z2) {
        if (world.a(x, y2, z2).isAir(world, x, y2, z2)) {
            return true;
        }
        ahu block = world.a(x, y2, z2);
        if (block == this) {
            return false;
        }
        if (this.displacements.containsKey(block)) {
            return this.displacements.get(block);
        }
        avf material = block.o();
        if (material.c() || material == avf.E) {
            return false;
        }
        int density = BlockFluidBase.getDensity(world, x, y2, z2);
        if (density == Integer.MAX_VALUE) {
            return true;
        }
        return this.density > density;
    }

    public boolean displaceIfPossible(afn world, int x, int y2, int z2) {
        if (world.a(x, y2, z2).isAir((afx)world, x, y2, z2)) {
            return true;
        }
        ahu block = world.a(x, y2, z2);
        if (block == this) {
            return false;
        }
        if (this.displacements.containsKey(block)) {
            if (this.displacements.get(block).booleanValue()) {
                block.b(world, x, y2, z2, world.e(x, y2, z2), 0);
                return true;
            }
            return false;
        }
        avf material = block.o();
        if (material.c() || material == avf.E) {
            return false;
        }
        int density = BlockFluidBase.getDensity((afx)world, x, y2, z2);
        if (density == Integer.MAX_VALUE) {
            block.b(world, x, y2, z2, world.e(x, y2, z2), 0);
            return true;
        }
        return this.density > density;
    }

    public abstract int getQuantaValue(afx var1, int var2, int var3, int var4);

    public abstract boolean a(int var1, boolean var2);

    public abstract int getMaxRenderHeightMeta();

    public void b(afn world, int x, int y2, int z2) {
        world.a(x, y2, z2, (ahu)this, this.tickRate);
    }

    public void a(afn world, int x, int y2, int z2, ahu block) {
        world.a(x, y2, z2, (ahu)this, this.tickRate);
    }

    public boolean L() {
        return false;
    }

    public boolean b(afx world, int x, int y2, int z2) {
        return true;
    }

    public ayf a(afn world, int x, int y2, int z2) {
        return null;
    }

    public abn a(int par1, Random par2Random, int par3) {
        return null;
    }

    public int a(Random par1Random) {
        return 0;
    }

    public int a(afn world) {
        return this.tickRate;
    }

    public void a(afn world, int x, int y2, int z2, qn entity, ayk vec) {
        if (this.densityDir > 0) {
            return;
        }
        ayk vec_flow = this.getFlowVector((afx)world, x, y2, z2);
        vec.c += vec_flow.c * (double)(this.quantaPerBlock * 4);
        vec.d += vec_flow.d * (double)(this.quantaPerBlock * 4);
        vec.e += vec_flow.e * (double)(this.quantaPerBlock * 4);
    }

    public int getLightValue(afx world, int x, int y2, int z2) {
        if (this.maxScaledLight == 0) {
            return super.getLightValue(world, x, y2, z2);
        }
        int data = world.e(x, y2, z2);
        return (int)((float)data / this.quantaPerBlockFloat * (float)this.maxScaledLight);
    }

    public int b() {
        return FluidRegistry.renderIdFluid;
    }

    public boolean c() {
        return false;
    }

    public boolean d() {
        return false;
    }

    public int c(afx world, int x, int y2, int z2) {
        int lightThis = world.c(x, y2, z2, 0);
        int lightUp = world.c(x, y2 + 1, z2, 0);
        int lightThisBase = lightThis & 0xFF;
        int lightUpBase = lightUp & 0xFF;
        int lightThisExt = lightThis >> 16 & 0xFF;
        int lightUpExt = lightUp >> 16 & 0xFF;
        return (lightThisBase > lightUpBase ? lightThisBase : lightUpBase) | (lightThisExt > lightUpExt ? lightThisExt : lightUpExt) << 16;
    }

    public int w() {
        return this.renderPass;
    }

    public boolean a(afx world, int x, int y2, int z2, int side) {
        ahu block = world.a(x, y2, z2);
        if (block != this) {
            return !block.c();
        }
        return block.o() == this.o() ? false : super.a(world, x, y2, z2, side);
    }

    public static final int getDensity(afx world, int x, int y2, int z2) {
        ahu block = world.a(x, y2, z2);
        if (!(block instanceof BlockFluidBase)) {
            return Integer.MAX_VALUE;
        }
        return ((BlockFluidBase)block).density;
    }

    public static final int getTemperature(afx world, int x, int y2, int z2) {
        ahu block = world.a(x, y2, z2);
        if (!(block instanceof BlockFluidBase)) {
            return Integer.MAX_VALUE;
        }
        return ((BlockFluidBase)block).temperature;
    }

    public static double getFlowDirection(afx world, int x, int y2, int z2) {
        ahu block = world.a(x, y2, z2);
        if (!block.o().d()) {
            return -1000.0;
        }
        ayk vec = ((BlockFluidBase)block).getFlowVector(world, x, y2, z2);
        return vec.c == 0.0 && vec.e == 0.0 ? -1000.0 : Math.atan2(vec.e, vec.c) - 1.5707963267948966;
    }

    public final int getQuantaValueBelow(afx world, int x, int y2, int z2, int belowThis) {
        int quantaRemaining = this.getQuantaValue(world, x, y2, z2);
        if (quantaRemaining >= belowThis) {
            return -1;
        }
        return quantaRemaining;
    }

    public final int getQuantaValueAbove(afx world, int x, int y2, int z2, int aboveThis) {
        int quantaRemaining = this.getQuantaValue(world, x, y2, z2);
        if (quantaRemaining <= aboveThis) {
            return -1;
        }
        return quantaRemaining;
    }

    public final float getQuantaPercentage(afx world, int x, int y2, int z2) {
        int quantaRemaining = this.getQuantaValue(world, x, y2, z2);
        return (float)quantaRemaining / this.quantaPerBlockFloat;
    }

    public ayk getFlowVector(afx world, int x, int y2, int z2) {
        ayk vec = world.U().a(0.0, 0.0, 0.0);
        int decay = this.quantaPerBlock - this.getQuantaValue(world, x, y2, z2);
        for (int side = 0; side < 4; ++side) {
            int power;
            int x2 = x;
            int z22 = z2;
            switch (side) {
                case 0: {
                    --x2;
                    break;
                }
                case 1: {
                    --z22;
                    break;
                }
                case 2: {
                    ++x2;
                    break;
                }
                case 3: {
                    ++z22;
                }
            }
            int otherDecay = this.quantaPerBlock - this.getQuantaValue(world, x2, y2, z22);
            if (otherDecay >= this.quantaPerBlock) {
                if (world.a(x2, y2, z22).o().c() || (otherDecay = this.quantaPerBlock - this.getQuantaValue(world, x2, y2 - 1, z22)) < 0) continue;
                power = otherDecay - (decay - this.quantaPerBlock);
                vec = vec.c((double)((x2 - x) * power), (double)((y2 - y2) * power), (double)((z22 - z2) * power));
                continue;
            }
            if (otherDecay < 0) continue;
            power = otherDecay - decay;
            vec = vec.c((double)((x2 - x) * power), (double)((y2 - y2) * power), (double)((z22 - z2) * power));
        }
        if (world.a(x, y2 + 1, z2) == this) {
            boolean flag;
            boolean bl = flag = this.d(world, x, y2, z2 - 1, 2) || this.d(world, x, y2, z2 + 1, 3) || this.d(world, x - 1, y2, z2, 4) || this.d(world, x + 1, y2, z2, 5) || this.d(world, x, y2 + 1, z2 - 1, 2) || this.d(world, x, y2 + 1, z2 + 1, 3) || this.d(world, x - 1, y2 + 1, z2, 4) || this.d(world, x + 1, y2 + 1, z2, 5);
            if (flag) {
                vec = vec.a().c(0.0, -6.0, 0.0);
            }
        }
        vec = vec.a();
        return vec;
    }

    @Override
    public Fluid getFluid() {
        return FluidRegistry.getFluid(this.fluidName);
    }

    @Override
    public float getFilledPercentage(afn world, int x, int y2, int z2) {
        int quantaRemaining = this.getQuantaValue((afx)world, x, y2, z2) + 1;
        float remaining = (float)quantaRemaining / this.quantaPerBlockFloat;
        if (remaining > 1.0f) {
            remaining = 1.0f;
        }
        return remaining * (float)(this.density > 0 ? 1 : -1);
    }

    static {
        defaultDisplacements.put(ahz.ao, false);
        defaultDisplacements.put(ahz.av, false);
        defaultDisplacements.put(ahz.an, false);
        defaultDisplacements.put(ahz.as, false);
        defaultDisplacements.put(ahz.aH, false);
    }
}

