/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.network.internal;

import com.google.common.base.Throwables;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.network.internal.FMLMessage;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.common.registry.IThrowableEntity;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import org.apache.logging.log4j.Level;

public class EntitySpawnHandler
extends SimpleChannelInboundHandler<FMLMessage.EntityMessage> {
    protected void channelRead0(ChannelHandlerContext ctx, FMLMessage.EntityMessage msg) throws Exception {
        if (msg.getClass().equals(FMLMessage.EntitySpawnMessage.class)) {
            this.spawnEntity((FMLMessage.EntitySpawnMessage)msg);
        } else if (msg.getClass().equals(FMLMessage.EntityAdjustMessage.class)) {
            this.adjustEntity((FMLMessage.EntityAdjustMessage)msg);
        }
    }

    private void adjustEntity(FMLMessage.EntityAdjustMessage msg) {
        qn ent = FMLClientHandler.instance().getWorldClient().a(msg.entityId);
        if (ent != null) {
            ent.ca = msg.serverX;
            ent.cb = msg.serverY;
            ent.cc = msg.serverZ;
        } else {
            FMLLog.fine("Attempted to adjust the position of entity %d which is not present on the client", msg.entityId);
        }
    }

    private void spawnEntity(FMLMessage.EntitySpawnMessage spawnMsg) {
        ModContainer mc = Loader.instance().getIndexedModList().get(spawnMsg.modId);
        EntityRegistry.EntityRegistration er = EntityRegistry.instance().lookupModSpawn(mc, spawnMsg.modEntityTypeId);
        biz wc = FMLClientHandler.instance().getWorldClient();
        Class<? extends qn> cls = er.getEntityClass();
        try {
            qn entity;
            if (er.hasCustomSpawning()) {
                entity = er.doCustomSpawning(spawnMsg);
            } else {
                qn[] parts;
                entity = cls.getConstructor(afn.class).newInstance(wc);
                int offset = spawnMsg.entityId - entity.y();
                entity.d(spawnMsg.entityId);
                entity.b(spawnMsg.scaledX, spawnMsg.scaledY, spawnMsg.scaledZ, spawnMsg.scaledYaw, spawnMsg.scaledPitch);
                if (entity instanceof ri) {
                    ((ri)entity).aP = spawnMsg.scaledHeadYaw;
                }
                if ((parts = entity.at()) != null) {
                    for (int j = 0; j < parts.length; ++j) {
                        parts[j].d(parts[j].y() + offset);
                    }
                }
            }
            entity.ca = spawnMsg.rawX;
            entity.cb = spawnMsg.rawY;
            entity.cc = spawnMsg.rawZ;
            bje clientPlayer = FMLClientHandler.instance().getClientPlayerEntity();
            if (entity instanceof IThrowableEntity) {
                bje thrower = clientPlayer.y() == spawnMsg.throwerId ? clientPlayer : wc.a(spawnMsg.throwerId);
                ((IThrowableEntity)entity).setThrower((qn)thrower);
            }
            if (spawnMsg.dataWatcherList != null) {
                entity.z().a(spawnMsg.dataWatcherList);
            }
            if (spawnMsg.throwerId > 0) {
                entity.i(spawnMsg.speedScaledX, spawnMsg.speedScaledY, spawnMsg.speedScaledZ);
            }
            if (entity instanceof IEntityAdditionalSpawnData) {
                ((IEntityAdditionalSpawnData)entity).readSpawnData(spawnMsg.dataStream);
            }
            wc.a(spawnMsg.entityId, entity);
        }
        catch (Exception e) {
            FMLLog.log(Level.ERROR, e, "A severe problem occurred during the spawning of an entity", new Object[0]);
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        FMLLog.log(Level.ERROR, cause, "EntitySpawnHandler exception", new Object[0]);
        super.exceptionCaught(ctx, cause);
    }
}

