/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.commons;

import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.signature.SignatureVisitor;

public class RemappingSignatureAdapter
extends SignatureVisitor {
    private final SignatureVisitor v;
    private final Remapper remapper;
    private String className;

    public RemappingSignatureAdapter(SignatureVisitor signatureVisitor, Remapper remapper) {
        this(262144, signatureVisitor, remapper);
    }

    protected RemappingSignatureAdapter(int n, SignatureVisitor signatureVisitor, Remapper remapper) {
        super(n);
        this.v = signatureVisitor;
        this.remapper = remapper;
    }

    @Override
    public void visitClassType(String string) {
        this.className = string;
        this.v.visitClassType(this.remapper.mapType(string));
    }

    @Override
    public void visitInnerClassType(String string) {
        this.className = this.className + '$' + string;
        String string2 = this.remapper.mapType(this.className);
        this.v.visitInnerClassType(string2.substring(string2.lastIndexOf(36) + 1));
    }

    @Override
    public void visitFormalTypeParameter(String string) {
        this.v.visitFormalTypeParameter(string);
    }

    @Override
    public void visitTypeVariable(String string) {
        this.v.visitTypeVariable(string);
    }

    @Override
    public SignatureVisitor visitArrayType() {
        this.v.visitArrayType();
        return this;
    }

    @Override
    public void visitBaseType(char c) {
        this.v.visitBaseType(c);
    }

    @Override
    public SignatureVisitor visitClassBound() {
        this.v.visitClassBound();
        return this;
    }

    @Override
    public SignatureVisitor visitExceptionType() {
        this.v.visitExceptionType();
        return this;
    }

    @Override
    public SignatureVisitor visitInterface() {
        this.v.visitInterface();
        return this;
    }

    @Override
    public SignatureVisitor visitInterfaceBound() {
        this.v.visitInterfaceBound();
        return this;
    }

    @Override
    public SignatureVisitor visitParameterType() {
        this.v.visitParameterType();
        return this;
    }

    @Override
    public SignatureVisitor visitReturnType() {
        this.v.visitReturnType();
        return this;
    }

    @Override
    public SignatureVisitor visitSuperclass() {
        this.v.visitSuperclass();
        return this;
    }

    @Override
    public void visitTypeArgument() {
        this.v.visitTypeArgument();
    }

    @Override
    public SignatureVisitor visitTypeArgument(char c) {
        this.v.visitTypeArgument(c);
        return this;
    }

    @Override
    public void visitEnd() {
        this.v.visitEnd();
    }
}

