/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.util.log;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.appender.AbstractAppender;

public class LiteLoaderLogger
extends AbstractAppender {
    private static final int LOG_TAIL_SIZE = 500;
    private static Logger logger = (Logger)LogManager.getLogger((String)"LiteLoader");
    private static LinkedList<String> logTail = new LinkedList();
    private static long logIndex = 0L;

    protected LiteLoaderLogger() {
        super("Internal Log Appender", null, null);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(LogEvent event) {
        LinkedList<String> linkedList = logTail;
        synchronized (linkedList) {
            ++logIndex;
            String message = event.getMessage().getFormattedMessage();
            while (message.indexOf(10) > -1) {
                int LF = message.indexOf(10);
                logTail.add(message.substring(0, LF));
                if (logTail.size() > 500) {
                    logTail.remove();
                }
                message = message.substring(LF + 1);
            }
            logTail.add(message);
            if (logTail.size() > 500) {
                logTail.remove();
            }
        }
    }

    public static long getLogIndex() {
        return logIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getLogTail() {
        ArrayList<String> log = new ArrayList<String>();
        LinkedList<String> linkedList = logTail;
        synchronized (linkedList) {
            log.addAll(logTail);
        }
        return log;
    }

    public static Logger getLogger() {
        return logger;
    }

    private static void log(Level level, String format, Object ... data) {
        logger.log(level, String.format(format, data));
    }

    private static void log(Level level, Throwable th, String format, Object ... data) {
        logger.log(level, String.format(format, data), th);
    }

    public static void severe(String format, Object ... data) {
        LiteLoaderLogger.log(Level.ERROR, format, data);
    }

    public static void severe(Throwable th, String format, Object ... data) {
        LiteLoaderLogger.log(Level.ERROR, th, format, data);
    }

    public static void warning(String format, Object ... data) {
        LiteLoaderLogger.log(Level.WARN, format, data);
    }

    public static void warning(Throwable th, String format, Object ... data) {
        LiteLoaderLogger.log(Level.WARN, th, format, data);
    }

    public static void info(String format, Object ... data) {
        LiteLoaderLogger.log(Level.INFO, format, data);
    }

    static {
        logger.addAppender((Appender)new LiteLoaderLogger());
    }
}

