/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.update;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import com.mumfrey.liteloader.util.net.HttpStringRetriever;
import java.text.DateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;

public class UpdateSite
implements Comparator<Long> {
    private static Gson gson = new Gson();
    private final String updateSiteUrl;
    private final String updateSiteJsonFileName;
    private final String targetVersion;
    private final String artefact;
    private final long currentTimeStamp;
    private final Comparator<Long> timeStampComparator;
    private final Object lock = new Object();
    private HttpStringRetriever stringRetriever;
    private volatile boolean checkComplete = false;
    private volatile boolean checkSuccess = false;
    private volatile boolean updateAvailable = false;
    private String availableVersion = null;
    private String availableVersionDate = null;
    private String availableVersionURL = null;

    public UpdateSite(String updateSiteUrl, String jsonFileName, String targetVersion, String artefact, long currentTimeStamp, Comparator<Long> timeStampComparator) {
        this.updateSiteUrl = updateSiteUrl + (updateSiteUrl.endsWith("/") ? "" : "/");
        this.updateSiteJsonFileName = jsonFileName;
        this.targetVersion = targetVersion;
        this.artefact = artefact;
        this.currentTimeStamp = currentTimeStamp;
        this.timeStampComparator = timeStampComparator != null ? timeStampComparator : this;
    }

    public UpdateSite(String updateSiteUrl, String jsonFileName, String targetVersion, String artefact, long currentTimeStamp) {
        this(updateSiteUrl, jsonFileName, targetVersion, artefact, currentTimeStamp, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginUpdateCheck() {
        Object object = this.lock;
        synchronized (object) {
            if (this.stringRetriever == null) {
                this.stringRetriever = new HttpStringRetriever(String.format("%s%s", this.updateSiteUrl, this.updateSiteJsonFileName));
                this.stringRetriever.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCheckInProgress() {
        this.update();
        boolean checkInProgress = false;
        Object object = this.lock;
        synchronized (object) {
            checkInProgress = this.stringRetriever != null;
        }
        return checkInProgress;
    }

    public boolean isCheckComplete() {
        this.update();
        return this.checkComplete;
    }

    public boolean isCheckSucceess() {
        this.update();
        return this.checkComplete && this.checkSuccess;
    }

    public boolean isUpdateAvailable() {
        this.update();
        return this.updateAvailable;
    }

    public String getAvailableVersion() {
        this.update();
        return this.availableVersion;
    }

    public String getAvailableVersionDate() {
        this.update();
        return this.availableVersionDate;
    }

    public String getAvailableVersionURL() {
        this.update();
        return this.availableVersionURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() {
        Object object = this.lock;
        synchronized (object) {
            if (this.stringRetriever != null && this.stringRetriever.isDone()) {
                this.checkComplete = true;
                this.checkSuccess = this.stringRetriever.getSuccess();
                if (this.checkSuccess) {
                    try {
                        this.parseData(this.stringRetriever.getString());
                    }
                    catch (Exception ex) {
                        this.checkSuccess = false;
                        ex.printStackTrace();
                    }
                }
                this.stringRetriever = null;
            }
        }
    }

    private void parseData(String json) {
        this.updateAvailable = false;
        try {
            Map data = (Map)gson.fromJson(json, new TypeToken<Map<String, Map<String, Map<String, Map<String, Map<String, Map<String, String>>>>>>>(){}.getType());
            if (data.containsKey("versions")) {
                this.handleVersionsData((Map)data.get("versions"));
            } else {
                LiteLoaderLogger.warning("No key 'versions' in update site JSON", new Object[0]);
            }
        }
        catch (JsonSyntaxException ex) {
            LiteLoaderLogger.warning("Error parsing update site JSON: %s: %s", ((Object)((Object)ex)).getClass().getSimpleName(), ex.getMessage());
        }
    }

    private void handleVersionsData(Map<String, Map<String, Map<String, Map<String, Map<String, String>>>>> versions) {
        if (versions.containsKey(this.targetVersion)) {
            for (Map.Entry<String, Map<String, Map<String, Map<String, String>>>> versionDataEntry : versions.get(this.targetVersion).entrySet()) {
                this.handleVersionData(versionDataEntry.getKey(), versionDataEntry.getValue());
            }
        } else {
            LiteLoaderLogger.warning("No version entry for current version '%s' in update site JSON", this.targetVersion);
        }
    }

    private void handleVersionData(String key, Map<String, Map<String, Map<String, String>>> value) {
        if (key.equals("artefacts")) {
            if (value.containsKey(this.artefact)) {
                this.handleArtefactData(value.get(this.artefact));
            } else {
                LiteLoaderLogger.warning("No artefacts entry for specified artefact '%s' in update site JSON", this.artefact);
            }
        }
    }

    private void handleArtefactData(Map<String, Map<String, String>> availableArtefacts) {
        if (availableArtefacts.containsKey("latest")) {
            Map<String, String> latestArtefact = availableArtefacts.get("latest");
            this.checkAndUseRemoteArtefact(latestArtefact, this.currentTimeStamp, false);
        } else {
            LiteLoaderLogger.warning("No key 'latest' in update site JSON", new Object[0]);
            long bestTimeStamp = this.currentTimeStamp;
            Map<String, String> bestRemoteArtefact = null;
            for (Map<String, String> remoteArtefact : availableArtefacts.values()) {
                if (!this.checkAndUseRemoteArtefact(remoteArtefact, bestTimeStamp, true)) continue;
                bestTimeStamp = Long.parseLong(remoteArtefact.get("timestamp"));
                bestRemoteArtefact = remoteArtefact;
            }
            if (bestRemoteArtefact != null) {
                this.availableVersion = (String)bestRemoteArtefact.get("version");
                this.availableVersionURL = this.createArtefactURL((String)bestRemoteArtefact.get("file"));
                this.updateAvailable = this.compareTimeStamps(this.currentTimeStamp, bestTimeStamp);
            }
        }
    }

    private boolean checkAndUseRemoteArtefact(Map<String, String> artefact, long bestTimeStamp, boolean checkOnly) {
        if (artefact.containsKey("file") && artefact.containsKey("version") && artefact.containsKey("timestamp")) {
            Long remoteTimeStamp = Long.parseLong(artefact.get("timestamp"));
            if (checkOnly) {
                return this.compareTimeStamps(bestTimeStamp, remoteTimeStamp);
            }
            this.availableVersion = artefact.get("version");
            this.availableVersionDate = DateFormat.getDateTimeInstance().format(new Date(remoteTimeStamp * 1000L));
            this.availableVersionURL = this.createArtefactURL(artefact.get("file"));
            this.updateAvailable = this.compareTimeStamps(bestTimeStamp, remoteTimeStamp);
            return true;
        }
        return false;
    }

    private boolean compareTimeStamps(long bestTimeStamp, Long remoteTimeStamp) {
        return this.timeStampComparator.compare(bestTimeStamp, remoteTimeStamp) < 0;
    }

    private String createArtefactURL(String file) {
        return String.format("%s%s/%s/%s", this.updateSiteUrl, this.artefact.replace('.', '/').replace(':', '/'), this.targetVersion, file);
    }

    @Override
    public int compare(Long localTimestamp, Long remoteTimestamp) {
        if (localTimestamp == null && remoteTimestamp == null) {
            return 0;
        }
        if (localTimestamp == null) {
            return -1;
        }
        if (remoteTimestamp == null) {
            return 1;
        }
        return (int)(localTimestamp - remoteTimestamp);
    }
}

