/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.transformers;

import com.mumfrey.liteloader.core.runtime.Obf;
import com.mumfrey.liteloader.transformers.Callback;
import com.mumfrey.liteloader.transformers.InjectedCallbackCollisionError;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public abstract class CallbackInjectionTransformer
implements IClassTransformer {
    private Map<String, Map<String, Callback>> profilerCallbackMappings = new HashMap<String, Map<String, Callback>>();
    private Map<String, Map<String, Callback>> callbackMappings = new HashMap<String, Map<String, Callback>>();

    public CallbackInjectionTransformer() {
        this.addCallbacks();
    }

    protected abstract void addCallbacks();

    protected final void addCallback(String className, String methodName, String methodSignature, Callback callback) {
        if (callback.isProfilerCallback()) {
            if (!this.profilerCallbackMappings.containsKey(className)) {
                this.profilerCallbackMappings.put(className, new HashMap());
            }
            String signature = CallbackInjectionTransformer.generateSignature(className, methodName, methodSignature, callback.getProfilerMethod(), callback.getProfilerMethodSignature(), callback.getSectionName());
            this.addCallbackMapping(this.profilerCallbackMappings.get(className), signature, callback);
        } else {
            if (!this.callbackMappings.containsKey(className)) {
                this.callbackMappings.put(className, new HashMap());
            }
            String signature = CallbackInjectionTransformer.generateSignature(className, methodName, methodSignature, callback.getType());
            this.addCallbackMapping(this.callbackMappings.get(className), signature, callback);
        }
    }

    private void addCallbackMapping(Map<String, Callback> callbacks, String signature, Callback callback) {
        if (callbacks.containsKey(signature)) {
            Callback existingCallback = callbacks.get(signature);
            if (existingCallback.equals(callback)) {
                return;
            }
            if (callback.injectReturn() || existingCallback.injectReturn()) {
                String errorMessage = String.format("Callback for %s is already defined for %s, cannot add %s", signature, existingCallback, callback);
                LiteLoaderLogger.severe(errorMessage, new Object[0]);
                throw new InjectedCallbackCollisionError(errorMessage);
            }
            existingCallback.addChainedCallback(callback);
        } else {
            callbacks.put(signature, callback);
        }
    }

    public final byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass != null && this.profilerCallbackMappings.containsKey(transformedName) || this.callbackMappings.containsKey(transformedName)) {
            return this.injectCallbacks(basicClass, this.profilerCallbackMappings.get(transformedName), this.callbackMappings.get(transformedName));
        }
        return basicClass;
    }

    private byte[] injectCallbacks(byte[] basicClass, Map<String, Callback> profilerMappings, Map<String, Callback> mappings) {
        ClassNode classNode = this.readClass(basicClass);
        String className = classNode.name.replace('/', '.');
        String classType = Type.getObjectType((String)classNode.name).toString();
        for (MethodNode method : classNode.methods) {
            Callback callback;
            Callback callback2;
            InsnList callbackInsns;
            String headSignature;
            int returnNumber = 0;
            String section = null;
            int methodReturnOpcode = Type.getReturnType((String)method.desc).getOpcode(172);
            if (mappings != null && mappings.containsKey(headSignature = CallbackInjectionTransformer.generateSignature(classNode.name, method.name, method.desc, Callback.CallbackType.REDIRECT)) && (callbackInsns = this.genCallbackInsns(classType, method, callback2 = mappings.get(headSignature))) != null) {
                LiteLoaderLogger.info("Injecting %s callback for %s in class %s", callback2.getType().name().toLowerCase(), callback2, className);
                method.instructions.insert(callbackInsns);
                if (callback2.injectReturn()) continue;
            }
            HashMap<MethodInsnNode, Callback> profilerCallbackInjectionNodes = new HashMap<MethodInsnNode, Callback>();
            ListIterator iter = method.instructions.iterator();
            AbstractInsnNode lastInsn = null;
            while (iter.hasNext()) {
                String returnSignature;
                AbstractInsnNode insn = (AbstractInsnNode)iter.next();
                if (profilerMappings != null && insn.getOpcode() == 182) {
                    MethodInsnNode invokeNode = (MethodInsnNode)insn;
                    if (Obf.Profiler.ref.equals(invokeNode.owner) || Obf.Profiler.obf.equals(invokeNode.owner)) {
                        String signature;
                        section = "";
                        if (lastInsn instanceof LdcInsnNode) {
                            section = ((LdcInsnNode)lastInsn).cst.toString();
                        }
                        if (profilerMappings.containsKey(signature = CallbackInjectionTransformer.generateSignature(classNode.name, method.name, method.desc, invokeNode.name, invokeNode.desc, section))) {
                            profilerCallbackInjectionNodes.put(invokeNode, profilerMappings.get(signature).getNextCallback());
                        }
                    }
                } else if (mappings != null && insn.getOpcode() == methodReturnOpcode && mappings.containsKey(returnSignature = CallbackInjectionTransformer.generateSignature(classNode.name, method.name, method.desc, Callback.CallbackType.RETURN))) {
                    callback = mappings.get(returnSignature);
                    InsnList callbackInsns2 = this.genCallbackInsns(classType, method, callback, returnNumber++);
                    if (callbackInsns2 != null) {
                        LiteLoaderLogger.info("Injecting method return callback for %s in class %s", callback, className);
                        method.instructions.insertBefore(insn, callbackInsns2);
                    } else {
                        LiteLoaderLogger.severe("Skipping callback mapping %s because the return behaviour does not match the method signature", returnSignature);
                    }
                }
                lastInsn = insn;
            }
            for (Map.Entry profilerCallbackNode : profilerCallbackInjectionNodes.entrySet()) {
                callback = (Callback)profilerCallbackNode.getValue();
                LiteLoaderLogger.info("Injecting profiler invokation callback for %s in class %s", callback, className);
                InsnList injected = this.genProfilerCallbackInsns(new InsnList(), callback, callback.refNumber++);
                method.instructions.insert((AbstractInsnNode)profilerCallbackNode.getKey(), injected);
            }
        }
        return this.writeClass(classNode);
    }

    private InsnList genProfilerCallbackInsns(InsnList injected, Callback callback, int refNumber) {
        injected.add((AbstractInsnNode)new LdcInsnNode((Object)refNumber));
        injected.add((AbstractInsnNode)new MethodInsnNode(184, callback.getCallbackClass(), callback.getCallbackMethod(), "(I)V"));
        if (callback.getChainedCallbacks().size() > 0) {
            for (Callback chainedCallback : callback.getChainedCallbacks()) {
                this.genProfilerCallbackInsns(injected, chainedCallback, refNumber);
            }
        }
        return injected;
    }

    private InsnList genCallbackInsns(String classType, MethodNode methodNode, Callback callback) {
        return this.genCallbackInsns(classType, methodNode, callback, -1);
    }

    private InsnList genCallbackInsns(String classType, MethodNode methodNode, Callback callback, int returnNumber) {
        return this.genCallbackInsns(new InsnList(), classType, methodNode, callback, returnNumber);
    }

    private InsnList genCallbackInsns(InsnList injected, String classType, MethodNode methodNode, Callback callback, int returnNumber) {
        String classInstanceArg;
        boolean methodReturnsVoid = Type.getReturnType((String)methodNode.desc).equals((Object)Type.VOID_TYPE);
        boolean methodIsStatic = (methodNode.access & 8) == 8;
        boolean hasReturnRef = returnNumber > -1;
        Type callbackReturnType = Type.getReturnType((String)methodNode.desc);
        String callbackReturnValueArg = methodReturnsVoid ? "" : callbackReturnType.toString();
        String string = classInstanceArg = methodIsStatic ? "" : classType;
        if (hasReturnRef) {
            injected.insert((AbstractInsnNode)new IntInsnNode(16, returnNumber));
        }
        if (!methodIsStatic) {
            injected.add((AbstractInsnNode)new VarInsnNode(25, 0));
        }
        int argNumber = methodIsStatic ? 0 : 1;
        for (Type type : Type.getArgumentTypes((String)methodNode.desc)) {
            injected.add((AbstractInsnNode)new VarInsnNode(type.getOpcode(21), argNumber++));
        }
        String callbackMethodDesc = String.format("(%s%s%s%s)%s", callbackReturnValueArg, hasReturnRef ? "I" : "", classInstanceArg, CallbackInjectionTransformer.getMethodArgs(methodNode), callbackReturnType);
        injected.add((AbstractInsnNode)new MethodInsnNode(184, callback.getCallbackClass(), callback.getCallbackMethod(), callbackMethodDesc));
        if (callback.injectReturn()) {
            injected.add((AbstractInsnNode)new InsnNode(callbackReturnType.getOpcode(172)));
        } else if (callback.getChainedCallbacks().size() > 0) {
            for (Callback chainedCallback : callback.getChainedCallbacks()) {
                this.genCallbackInsns(injected, classType, methodNode, chainedCallback, returnNumber);
            }
        }
        return injected;
    }

    private static String getMethodArgs(MethodNode method) {
        return method.desc.substring(1, method.desc.lastIndexOf(41));
    }

    private static String generateSignature(String className, String methodName, String methodSignature, String invokeName, String invokeSig, String section) {
        return String.format("%s::%s%s@%s%s/%s", className.replace('.', '/'), methodName, methodSignature, invokeName, invokeSig, section);
    }

    private static String generateSignature(String className, String methodName, String methodSignature, Callback.CallbackType callbackType) {
        return String.format("%s::%s%s@%s", className.replace('.', '/'), methodName, methodSignature, callbackType.toString().toLowerCase());
    }

    protected final ClassNode readClass(byte[] basicClass) {
        ClassReader classReader = new ClassReader(basicClass);
        ClassNode classNode = new ClassNode();
        classReader.accept((ClassVisitor)classNode, 8);
        return classNode;
    }

    protected final byte[] writeClass(ClassNode classNode) {
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public static String generateDescriptor(Type returnType, Object ... args) {
        return CallbackInjectionTransformer.generateDescriptor(0, (Object)returnType, args);
    }

    public static String generateDescriptor(Obf returnType, Object ... args) {
        return CallbackInjectionTransformer.generateDescriptor(0, (Object)returnType, args);
    }

    public static String generateDescriptor(String returnType, Object ... args) {
        return CallbackInjectionTransformer.generateDescriptor(0, (Object)returnType, args);
    }

    public static String generateDescriptor(int obfType, Object returnType, Object ... args) {
        StringBuilder sb = new StringBuilder().append('(');
        for (Object arg : args) {
            sb.append(CallbackInjectionTransformer.toDescriptor(obfType, arg));
        }
        return sb.append(')').append(returnType != null ? CallbackInjectionTransformer.toDescriptor(obfType, returnType) : "V").toString();
    }

    private static String toDescriptor(int obfType, Object arg) {
        if (arg instanceof Obf) {
            return ((Obf)((Object)arg)).getDescriptor(obfType);
        }
        if (arg instanceof String) {
            return (String)arg;
        }
        if (arg instanceof Type) {
            return arg.toString();
        }
        if (arg instanceof Class) {
            return Type.getDescriptor((Class)((Class)arg)).toString();
        }
        return arg == null ? "" : arg.toString();
    }
}

