/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.transformers;

import com.mumfrey.liteloader.core.runtime.Obf;
import java.util.ArrayList;
import java.util.List;

public class Callback {
    private final CallbackType callbackType;
    private final String sectionName;
    private final String profilerMethod;
    private final String callbackClass;
    private final String callbackMethod;
    int refNumber;
    private final List<Callback> chainedCallbacks;

    public Callback(CallbackType callbackType, String callbackMethod, String callbackClass) {
        this(callbackType, callbackMethod, callbackClass, null, 0);
    }

    public Callback(CallbackType callbackType, String callbackMethod, String callbackClass, String section, int obfType) {
        if (section == null && callbackType.isSectionRequired()) {
            throw new RuntimeException(String.format("Callback of type %s requires a section name but no section name was provided", callbackType.name()));
        }
        this.callbackType = callbackType;
        this.callbackClass = callbackClass.replace('.', '/');
        this.callbackMethod = callbackMethod;
        this.sectionName = section;
        this.chainedCallbacks = new ArrayList<Callback>();
        this.profilerMethod = callbackType.getProfilerMethod(obfType);
    }

    private Callback(Callback other, int refNumber) {
        this.callbackType = other.callbackType;
        this.callbackClass = other.callbackClass;
        this.callbackMethod = other.callbackMethod;
        this.sectionName = other.sectionName;
        this.chainedCallbacks = other.chainedCallbacks;
        this.profilerMethod = other.profilerMethod;
        this.refNumber = refNumber;
    }

    public CallbackType getType() {
        return this.callbackType;
    }

    public String getCallbackClass() {
        return this.callbackClass;
    }

    public String getCallbackMethod() {
        return this.callbackMethod;
    }

    public boolean injectReturn() {
        return this.callbackType.injectReturn();
    }

    public boolean isProfilerCallback() {
        return this.callbackType.isProfilerCallback();
    }

    public String getSectionName() {
        return this.sectionName;
    }

    public String getProfilerMethod() {
        return this.profilerMethod;
    }

    public String getProfilerMethodSignature() {
        return this.callbackType.getProfilerMethodSignature();
    }

    public Callback getNextCallback() {
        return new Callback(this, this.refNumber++);
    }

    void addChainedCallback(Callback chained) {
        this.chainedCallbacks.add(chained);
    }

    public List<Callback> getChainedCallbacks() {
        return this.chainedCallbacks;
    }

    public String toString() {
        return this.callbackMethod;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof Callback)) {
            return false;
        }
        Callback callback = (Callback)other;
        return callback.callbackClass.equals(this.callbackClass) && callback.callbackMethod.equals(this.callbackMethod) && callback.callbackType == this.callbackType;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public static enum CallbackType {
        REDIRECT(true),
        EVENT(false),
        RETURN(false),
        PROFILER_STARTSECTION(Obf.startSection, true),
        PROFILER_ENDSECTION(Obf.endSection, false),
        PROFILER_ENDSTARTSECTION(Obf.endStartSection, true);

        private final boolean injectReturn;
        private final boolean isProfilerCallback;
        private final boolean sectionRequired;
        private final Obf profilerMethod;

        private CallbackType(boolean returnFrom) {
            this.injectReturn = returnFrom;
            this.isProfilerCallback = false;
            this.profilerMethod = null;
            this.sectionRequired = false;
        }

        private CallbackType(Obf profilerMethod, boolean sectionRequired) {
            this.injectReturn = false;
            this.isProfilerCallback = true;
            this.profilerMethod = profilerMethod;
            this.sectionRequired = sectionRequired;
        }

        boolean injectReturn() {
            return this.injectReturn;
        }

        boolean isProfilerCallback() {
            return this.isProfilerCallback;
        }

        String getProfilerMethod(int obfType) {
            return this.profilerMethod != null ? this.profilerMethod.names[obfType] : "";
        }

        String getProfilerMethodSignature() {
            return this.sectionRequired ? "(Ljava/lang/String;)V" : "()V";
        }

        boolean isSectionRequired() {
            return this.sectionRequired;
        }
    }
}

