/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.modconfig;

import com.google.common.base.Strings;
import com.google.common.io.Files;
import com.mumfrey.liteloader.Configurable;
import com.mumfrey.liteloader.LiteMod;
import com.mumfrey.liteloader.modconfig.ConfigPanel;
import com.mumfrey.liteloader.modconfig.ConfigStrategy;
import com.mumfrey.liteloader.modconfig.Exposable;
import com.mumfrey.liteloader.modconfig.ExposableConfigWriter;
import com.mumfrey.liteloader.modconfig.ExposableOptions;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ConfigManager {
    private Map<Class<? extends LiteMod>, Class<? extends ConfigPanel>> configPanels = new HashMap<Class<? extends LiteMod>, Class<? extends ConfigPanel>>();
    private Map<Exposable, ExposableConfigWriter> configWriters = new HashMap<Exposable, ExposableConfigWriter>();
    private List<ExposableConfigWriter> configWriterList = new LinkedList<ExposableConfigWriter>();

    public void registerMod(LiteMod mod) {
        Class<? extends ConfigPanel> panelClass;
        if (mod instanceof Configurable && (panelClass = ((Configurable)((Object)mod)).getConfigPanelClass()) != null) {
            this.configPanels.put(mod.getClass(), panelClass);
        }
        this.registerExposable(mod, null, false);
    }

    public void registerExposable(Exposable exposable, String fallbackFileName, boolean ignoreMissingConfigAnnotation) {
        ExposableOptions options = exposable.getClass().getAnnotation(ExposableOptions.class);
        if (options != null) {
            if (fallbackFileName == null) {
                fallbackFileName = options.filename();
            }
            this.initConfigWriter(exposable, fallbackFileName, options.strategy(), options.aggressive());
        } else if (ignoreMissingConfigAnnotation) {
            this.initConfigWriter(exposable, fallbackFileName, ConfigStrategy.Versioned, false);
        }
    }

    private void initConfigWriter(Exposable exposable, String fileName, ConfigStrategy strategy, boolean aggressive) {
        ExposableConfigWriter configWriter;
        if (this.configWriters.containsKey(exposable)) {
            return;
        }
        if (Strings.isNullOrEmpty((String)fileName) && (fileName = exposable.getClass().getSimpleName().toLowerCase()).startsWith("litemod")) {
            fileName = fileName.substring(7);
        }
        if ((configWriter = ExposableConfigWriter.create(exposable, strategy, fileName, aggressive)) != null) {
            this.configWriters.put(exposable, configWriter);
            this.configWriterList.add(configWriter);
        }
    }

    public void migrateModConfig(LiteMod mod, File newConfigPath, File oldConfigPath) {
        File newConfigFile;
        File legacyConfigFile;
        ExposableConfigWriter writer;
        if (this.configWriters.containsKey(mod) && (writer = this.configWriters.get(mod)).isVersioned() && (legacyConfigFile = new File(oldConfigPath, (newConfigFile = writer.getConfigFile()).getName())).exists() && !newConfigFile.exists()) {
            try {
                Files.copy((File)legacyConfigFile, (File)newConfigFile);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public boolean hasPanel(Class<? extends LiteMod> modClass) {
        return modClass != null && this.configPanels.containsKey(modClass);
    }

    public ConfigPanel getPanel(Class<? extends LiteMod> modClass) {
        if (modClass != null && this.configPanels.containsKey(modClass)) {
            try {
                return this.configPanels.get(modClass).newInstance();
            }
            catch (InstantiationException ex) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            this.configPanels.remove(modClass);
        }
        return null;
    }

    public void initConfig(Exposable exposable) {
        if (this.configWriters.containsKey(exposable)) {
            this.configWriters.get(exposable).init();
        }
    }

    public void invalidateConfig(Exposable exposable) {
        if (this.configWriters.containsKey(exposable)) {
            this.configWriters.get(exposable).invalidate();
        }
    }

    public void onTick() {
        for (ExposableConfigWriter writer : this.configWriterList) {
            writer.onTick();
        }
    }

    public void syncConfig() {
        for (ExposableConfigWriter writer : this.configWriterList) {
            writer.sync();
        }
    }
}

