/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.launch;

import com.google.common.base.Throwables;
import com.google.gson.Gson;
import com.mumfrey.liteloader.launch.ClassPathUtilities;
import com.mumfrey.liteloader.launch.ClassTransformerManager;
import com.mumfrey.liteloader.launch.ILoaderBootstrap;
import com.mumfrey.liteloader.util.SortableValue;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import net.minecraft.launchwrapper.ITweaker;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;

public class LiteLoaderTweaker
implements ITweaker {
    public static final String VERSION = "1.7.2";
    private static LiteLoaderTweaker instance;
    private static final String OPTION_GENERATE_MAPPINGS = "genMappings";
    private File jarFile;
    private URL jarUrl;
    private List<String> singularLaunchArgs = new ArrayList<String>();
    private Map<String, String> launchArgs;
    private ArgumentAcceptingOptionSpec<String> jarOption;
    private ArgumentAcceptingOptionSpec<String> modsOption;
    private OptionSet parsedOptions;
    private int tweakOrder = 0;
    private Set<String> allCascadingTweaks = new HashSet<String>();
    private Set<SortableValue<String>> sortedCascadingTweaks = new TreeSet<SortableValue<String>>();
    private boolean isPrimary;
    private ILoaderBootstrap bootstrap;
    private ClassTransformerManager transformerManager;
    private static final String bootstrapClassName = "com.mumfrey.liteloader.core.LiteLoaderBootstrap";
    private static final String[] requiredTransformers;
    private static final String[] requiredDownstreamTransformers;
    private static final String genTransformerClassName = "com.mumfrey.liteloader.core.gen.GenProfilerTransformer";
    private static final String[] defaultPacketTransformers;

    public void acceptOptions(List<String> args, File gameDirectory, File assetsDirectory, String profile) {
        List modsToLoad = null;
        instance = this;
        OptionParser optionParser = new OptionParser();
        this.jarOption = optionParser.accepts("versionJar", "Minecraft version jar to use").withRequiredArg().ofType(String.class);
        this.modsOption = optionParser.accepts("mods", "Comma-separated list of mods to load").withRequiredArg().ofType(String.class).withValuesSeparatedBy(',');
        optionParser.allowsUnrecognizedOptions();
        NonOptionArgumentSpec nonOptions = optionParser.nonOptions();
        this.parsedOptions = optionParser.parse(args.toArray(new String[args.size()]));
        this.launchArgs = (Map)Launch.blackboard.get("launchArgs");
        if (this.launchArgs == null) {
            this.launchArgs = new HashMap<String, String>();
            Launch.blackboard.put("launchArgs", this.launchArgs);
        }
        this.parseArgs(this.parsedOptions.valuesOf((OptionSpec)nonOptions));
        this.provideRequiredArgs(gameDirectory, assetsDirectory);
        if (this.parsedOptions.has(this.modsOption)) {
            modsToLoad = this.modsOption.values(this.parsedOptions);
        }
        this.initJarUrl();
        if (this.jarFile != null) {
            LiteLoaderLogger.info("Injecting version jar '%s'", this.jarFile.getAbsolutePath());
            Launch.classLoader.addURL(this.jarUrl);
            LiteLoaderTweaker.addURLToParentClassLoader(this.jarUrl);
        }
        LiteLoaderLogger.info("Bootstrapping LiteLoader 1.7.2", new Object[0]);
        this.bootstrap = this.spawnBootstrap(bootstrapClassName, (ClassLoader)Launch.classLoader, gameDirectory, assetsDirectory, profile);
        this.transformerManager = new ClassTransformerManager(requiredTransformers);
        this.transformerManager.injectTransformers(defaultPacketTransformers);
        StartupState.CONSTRUCT.completed();
        this.preInit(modsToLoad);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initJarUrl() {
        if (this.parsedOptions.has(this.jarOption)) {
            try {
                String jarPath = (String)this.jarOption.value(this.parsedOptions);
                if (jarPath.matches("^[0-9\\.]+$")) {
                    jarPath = String.format("versions/%1$s/%1$s.jar", jarPath);
                }
                LiteLoaderLogger.info("Version jar '%s' was specified on the command line", jarPath);
                this.jarFile = new File(jarPath);
                this.jarUrl = this.jarFile.toURI().toURL();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            String resource = "/jarfile.ref";
            InputStream refResource = LiteLoaderTweaker.class.getResourceAsStream(resource);
            File refContainer = ClassPathUtilities.getPathToResource(LiteLoaderTweaker.class, resource);
            if (refResource != null && refContainer != null) {
                InputStreamReader refReader = new InputStreamReader(refResource);
                try {
                    Map refMap = (Map)new Gson().fromJson((Reader)refReader, HashMap.class);
                    if (refMap.containsKey("jarfile")) {
                        String jarPath = (String)refMap.get("jarfile");
                        LiteLoaderLogger.info("Version jar '%s' specified via jarfile.ref", jarPath);
                        this.jarFile = new File(refContainer.getParentFile(), jarPath);
                        this.jarUrl = this.jarFile.toURI().toURL();
                        return;
                    }
                }
                catch (IOException ex) {
                }
                finally {
                    try {
                        refReader.close();
                        refResource.close();
                    }
                    catch (IOException ex) {}
                }
            }
            URL[] urls = Launch.classLoader.getURLs();
            this.jarUrl = urls[urls.length - 1];
        }
    }

    public void provideRequiredArgs(File gameDirectory, File assetsDirectory) {
        if (!this.launchArgs.containsKey("--version")) {
            this.addClassifiedArg("--version", VERSION);
        }
        if (!this.launchArgs.containsKey("--gameDir") && gameDirectory != null) {
            this.addClassifiedArg("--gameDir", gameDirectory.getAbsolutePath());
        }
        if (!this.launchArgs.containsKey("--assetsDir") && assetsDirectory != null) {
            this.addClassifiedArg("--assetsDir", assetsDirectory.getAbsolutePath());
        }
    }

    private void parseArgs(List<String> args) {
        String classifier = null;
        for (String arg : args) {
            if (arg.startsWith("-")) {
                if (classifier != null) {
                    this.addClassifiedArg(classifier, "");
                    classifier = null;
                    continue;
                }
                if (arg.contains("=")) {
                    this.addClassifiedArg(arg.substring(0, arg.indexOf(61)), arg.substring(arg.indexOf(61) + 1));
                    continue;
                }
                classifier = arg;
                continue;
            }
            if (classifier != null) {
                this.addClassifiedArg(classifier, arg);
                classifier = null;
                continue;
            }
            this.singularLaunchArgs.add(arg);
        }
    }

    private void addClassifiedArg(String classifiedArg, String arg) {
        this.launchArgs.put(classifiedArg, arg);
    }

    public void injectIntoClassLoader(LaunchClassLoader classLoader) {
        classLoader.addClassLoaderExclusion("com.mumfrey.liteloader.core.runtime.");
        LiteLoaderTweaker.instance.transformerManager.injectUpstreamTransformers(classLoader);
        if (LiteLoaderTweaker.instance.bootstrap.getBooleanProperty(OPTION_GENERATE_MAPPINGS)) {
            LiteLoaderLogger.info("Injecting gen trasnformer '%s'", genTransformerClassName);
            LiteLoaderTweaker.instance.transformerManager.injectTransformer(genTransformerClassName);
        }
        for (String transformerClassName : requiredDownstreamTransformers) {
            LiteLoaderLogger.info("Queuing required class transformer '%s'", transformerClassName);
            LiteLoaderTweaker.instance.transformerManager.injectTransformer(transformerClassName);
        }
    }

    public String getLaunchTarget() {
        this.isPrimary = true;
        LiteLoaderTweaker.preBeginGame();
        return "net.minecraft.client.main.Main";
    }

    public String[] getLaunchArguments() {
        ArrayList<String> args = new ArrayList<String>();
        for (String string : this.singularLaunchArgs) {
            args.add(string);
        }
        for (Map.Entry entry : this.launchArgs.entrySet()) {
            args.add(((String)entry.getKey()).trim());
            args.add(((String)entry.getValue()).trim());
        }
        this.singularLaunchArgs.clear();
        this.launchArgs.clear();
        return args.toArray(new String[args.size()]);
    }

    public static boolean addCascadedTweaker(String tweakClass, int priority) {
        return instance.addTweakToSortedList(tweakClass, priority);
    }

    private boolean addTweakToSortedList(String tweakClass, int priority) {
        if (tweakClass != null && !this.allCascadingTweaks.contains(tweakClass)) {
            this.allCascadingTweaks.add(tweakClass);
            this.sortedCascadingTweaks.add(new SortableValue<String>(priority, this.tweakOrder++, tweakClass));
            return true;
        }
        return false;
    }

    private void injectDiscoveredTweakClasses() {
        if (this.sortedCascadingTweaks.size() > 0) {
            if (StartupState.getCurrent() != StartupState.PREINIT || !StartupState.PREINIT.isInState()) {
                LiteLoaderLogger.warning("Failed to inject cascaded tweak classes because preInit is already complete", new Object[0]);
                return;
            }
            LiteLoaderLogger.info("Injecting cascaded tweakers...", new Object[0]);
            List tweakClasses = (List)Launch.blackboard.get("TweakClasses");
            List tweakers = (List)Launch.blackboard.get("Tweaks");
            if (tweakClasses != null && tweakers != null) {
                for (SortableValue<String> tweak : this.sortedCascadingTweaks) {
                    String tweakClass = tweak.getValue();
                    LiteLoaderLogger.info("Injecting tweak class %s with priority %d", tweakClass, tweak.getPriority());
                    this.injectTweakClass(tweakClass, tweakClasses, tweakers);
                }
            }
            this.sortedCascadingTweaks.clear();
        }
    }

    private void injectTweakClass(String tweakClass, List<String> tweakClasses, List<ITweaker> tweakers) {
        if (!tweakClasses.contains(tweakClass)) {
            for (ITweaker existingTweaker : tweakers) {
                if (!tweakClass.equals(existingTweaker.getClass().getName())) continue;
                return;
            }
            tweakClasses.add(tweakClass);
        }
    }

    public static boolean addURLToParentClassLoader(URL url) {
        if (StartupState.getCurrent() == StartupState.PREINIT && StartupState.PREINIT.isInState()) {
            try {
                URLClassLoader classLoader = (URLClassLoader)Launch.class.getClassLoader();
                Method mAddUrl = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                mAddUrl.setAccessible(true);
                mAddUrl.invoke((Object)classLoader, url);
                return true;
            }
            catch (Exception ex) {
                LiteLoaderLogger.warning(ex, "addURLToParentClassLoader failed: %s", ex.getMessage());
            }
        }
        return false;
    }

    private ILoaderBootstrap spawnBootstrap(String bootstrapClassName, ClassLoader classLoader, File gameDirectory, File assetsDirectory, String profile) {
        if (!StartupState.CONSTRUCT.isInState()) {
            throw new IllegalStateException("spawnBootstrap is not valid outside constructor");
        }
        try {
            Class<?> bootstrapClass = Class.forName(bootstrapClassName, false, classLoader);
            Constructor<?> bootstrapCtor = bootstrapClass.getDeclaredConstructor(File.class, File.class, String.class);
            bootstrapCtor.setAccessible(true);
            return (ILoaderBootstrap)bootstrapCtor.newInstance(gameDirectory, assetsDirectory, profile);
        }
        catch (Exception ex) {
            Throwables.propagate((Throwable)ex);
            return null;
        }
    }

    private void preInit(List<String> modsToLoad) {
        StartupState.PREINIT.gotoState();
        try {
            this.bootstrap.preInit(Launch.classLoader, true, modsToLoad);
            this.injectDiscoveredTweakClasses();
            StartupState.PREINIT.completed();
        }
        catch (Throwable th) {
            LiteLoaderLogger.severe(th, "Error during LiteLoader PREINIT: %s %s", th.getClass().getName(), th.getMessage());
        }
    }

    public static void preBeginGame() {
        StartupState.BEGINGAME.gotoState();
        try {
            LiteLoaderTweaker.instance.transformerManager.injectDownstreamTransformers(Launch.classLoader);
            StartupState.BEGINGAME.completed();
        }
        catch (Throwable th) {
            LiteLoaderLogger.severe(th, "Error during LiteLoader BEGINGAME: %s %s", th.getClass().getName(), th.getMessage());
        }
    }

    public static void init() {
        StartupState.INIT.gotoState();
        try {
            LiteLoaderTweaker.instance.bootstrap.init(Launch.classLoader);
            StartupState.INIT.completed();
        }
        catch (Throwable th) {
            LiteLoaderLogger.severe(th, "Error during LiteLoader INIT: %s %s", th.getClass().getName(), th.getMessage());
        }
    }

    public static void postInit() {
        StartupState.POSTINIT.gotoState();
        try {
            LiteLoaderTweaker.instance.bootstrap.postInit();
            StartupState.POSTINIT.completed();
            StartupState.DONE.gotoState();
        }
        catch (Throwable th) {
            LiteLoaderLogger.severe(th, "Error during LiteLoader POSTINIT: %s %s", th.getClass().getName(), th.getMessage());
        }
    }

    public static URL getJarUrl() {
        return LiteLoaderTweaker.instance.jarUrl;
    }

    public static boolean isPrimary() {
        return LiteLoaderTweaker.instance.isPrimary;
    }

    public static ClassTransformerManager getTransformerManager() {
        return LiteLoaderTweaker.instance.transformerManager;
    }

    static {
        requiredTransformers = new String[]{"com.mumfrey.liteloader.launch.LiteLoaderTransformer", "com.mumfrey.liteloader.core.transformers.CrashReportTransformer"};
        requiredDownstreamTransformers = new String[]{"com.mumfrey.liteloader.core.transformers.LiteLoaderCallbackInjectionTransformer", "com.mumfrey.liteloader.core.transformers.MinecraftOverlayTransformer"};
        defaultPacketTransformers = new String[]{"com.mumfrey.liteloader.core.transformers.LoginSuccessPacketTransformer", "com.mumfrey.liteloader.core.transformers.ChatPacketTransformer", "com.mumfrey.liteloader.core.transformers.JoinGamePacketTransformer", "com.mumfrey.liteloader.core.transformers.CustomPayloadPacketTransformer", "com.mumfrey.liteloader.core.transformers.ServerChatPacketTransformer", "com.mumfrey.liteloader.core.transformers.ServerCustomPayloadPacketTransformer"};
    }

    static enum StartupState {
        CONSTRUCT,
        PREINIT,
        BEGINGAME,
        INIT,
        POSTINIT,
        DONE;

        private static StartupState currentState;
        private boolean inState;
        private boolean completed;

        public boolean isCompleted() {
            return this.completed;
        }

        public boolean isInState() {
            return this.inState;
        }

        public StartupState gotoState() {
            for (StartupState otherState : StartupState.values()) {
                if (!otherState.isInState() || otherState == this) continue;
                if (otherState.canGotoState(this)) {
                    otherState.leaveState();
                    continue;
                }
                throw new IllegalStateException(String.format("Cannot go to state \"%s\" as %s %s", new Object[]{this.name(), otherState, otherState.getNextState() == this ? "" : "and expects \"" + otherState.getNextState().name() + "\" instead"}));
            }
            currentState = this;
            this.inState = true;
            this.completed = false;
            return this;
        }

        public String toString() {
            return String.format("\"%s\" is %s %s", this.name(), this.inState ? "[ACTIVE]" : "not [ACTIVE]", this.completed ? "and [COMPLETED]" : "but not [COMPLETED]");
        }

        public void leaveState() {
            this.inState = false;
        }

        public void completed() {
            if (!this.inState || this.completed) {
                throw new IllegalStateException("Attempted to complete state " + this.name() + " but the state is already completed or is not active");
            }
            this.completed = true;
        }

        private StartupState getNextState() {
            return this.ordinal() < StartupState.values().length - 1 ? StartupState.values()[this.ordinal() + 1] : null;
        }

        public boolean canGotoState(StartupState next) {
            if (this.inState && next == this.getNextState()) {
                return this.completed;
            }
            return !this.inState;
        }

        public static StartupState getCurrent() {
            return currentState;
        }

        static {
            currentState = CONSTRUCT.gotoState();
        }
    }
}

