/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.launch;

import com.mumfrey.liteloader.core.runtime.Obf;
import com.mumfrey.liteloader.launch.LiteLoaderTweaker;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class LiteLoaderTransformer
implements IClassTransformer {
    private static final String LITELOADER_TWEAKER_CLASS = LiteLoaderTweaker.class.getName().replace('.', '/');
    private static final String METHOD_PRE_BEGIN_GAME = "preBeginGame";
    private static final String METHOD_INIT = "init";
    private static final String METHOD_POSTINIT = "postInit";
    private static boolean postInit = false;

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (Obf.MinecraftMain.name.equals(name)) {
            return this.transformMain(basicClass);
        }
        if ((Obf.RenderLightningBolt.name.equals(name) || Obf.RenderLightningBolt.obf.equals(name)) && !postInit) {
            return this.transformRenderLightningBolt(basicClass);
        }
        return basicClass;
    }

    private byte[] transformMain(byte[] basicClass) {
        ClassNode classNode = this.readClass(basicClass);
        for (MethodNode method : classNode.methods) {
            if (!"main".equals(method.name)) continue;
            method.instructions.insert((AbstractInsnNode)new MethodInsnNode(184, LITELOADER_TWEAKER_CLASS, METHOD_PRE_BEGIN_GAME, "()V"));
        }
        return this.writeClass(classNode);
    }

    private byte[] transformRenderLightningBolt(byte[] basicClass) {
        ClassNode classNode = this.readClass(basicClass);
        for (MethodNode method : classNode.methods) {
            if (!"<init>".equals(method.name)) continue;
            method.instructions.insert((AbstractInsnNode)new MethodInsnNode(184, LITELOADER_TWEAKER_CLASS, METHOD_POSTINIT, "()V"));
            method.instructions.insert((AbstractInsnNode)new MethodInsnNode(184, LITELOADER_TWEAKER_CLASS, METHOD_INIT, "()V"));
        }
        return this.writeClass(classNode);
    }

    private ClassNode readClass(byte[] basicClass) {
        ClassReader classReader = new ClassReader(basicClass);
        ClassNode classNode = new ClassNode();
        classReader.accept((ClassVisitor)classNode, 8);
        return classNode;
    }

    private byte[] writeClass(ClassNode classNode) {
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

