/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.launch;

import com.mumfrey.liteloader.launch.InjectionStrategy;
import com.mumfrey.liteloader.launch.LiteLoaderTweaker;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Map;
import java.util.Stack;
import java.util.jar.JarFile;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import sun.misc.URLClassPath;

public abstract class ClassPathUtilities {
    private static Field ucp;
    private static Field classPathURLs;
    private static Field classPathPath;
    private static Field classPathLoaderMap;
    private static Field classPathLoaderList;
    private static boolean canInject;

    public static void injectIntoClassPath(URLClassLoader classLoader, URL url, InjectionStrategy strategy) {
        if (strategy == null || strategy.getPosition() == null) {
            ClassPathUtilities.addURL(classLoader, url);
            return;
        }
        if (strategy.getPosition() == InjectionStrategy.InjectionPosition.Top) {
            ClassPathUtilities.injectIntoClassPath(classLoader, url);
        } else if (strategy.getPosition() == InjectionStrategy.InjectionPosition.Base) {
            ClassPathUtilities.injectIntoClassPath(classLoader, url, LiteLoaderTweaker.getJarUrl());
        } else if (strategy.getPosition() == InjectionStrategy.InjectionPosition.Above) {
            String[] params = strategy.getParams();
            if (params.length > 0) {
                ClassPathUtilities.injectIntoClassPath(classLoader, url, params[0]);
            }
        } else {
            ClassPathUtilities.addURL(classLoader, url);
        }
    }

    public static void injectIntoClassPath(URLClassLoader classLoader, URL url) {
        ClassPathUtilities.injectIntoClassPath(classLoader, url, (URL)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void injectIntoClassPath(URLClassLoader classLoader, URL url, URL above) {
        if (canInject) {
            LiteLoaderLogger.info("ClassPathUtilities: attempting to inject %s into %s", url, classLoader.getClass().getSimpleName());
            try {
                URLClassPath classPath = (URLClassPath)ucp.get(classLoader);
                Stack urls = (Stack)classPathURLs.get(classPath);
                ArrayList path = (ArrayList)classPathPath.get(classPath);
                Stack stack = urls;
                synchronized (stack) {
                    if (!path.contains(url)) {
                        urls.add(url);
                        if (above == null) {
                            path.add(0, url);
                        } else {
                            for (int pos = path.size() - 1; pos > 0; --pos) {
                                if (!above.equals(path.get(pos))) continue;
                                path.add(pos, url);
                            }
                        }
                    }
                }
            }
            catch (Exception ex) {
                LiteLoaderLogger.warning("ClassPathUtilities: failed to inject %s", url);
            }
        }
        ClassPathUtilities.addURL(classLoader, url);
    }

    public static void injectIntoClassPath(URLClassLoader classLoader, URL url, String above) {
        if ((above = above.trim().toLowerCase()).length() < 1) {
            return;
        }
        for (URL classPathUrl : classLoader.getURLs()) {
            if (!classPathUrl.toString().toLowerCase().contains(above)) continue;
            ClassPathUtilities.injectIntoClassPath(classLoader, url, classPathUrl);
            return;
        }
    }

    public static void addURL(URLClassLoader classLoader, URL url) {
        if (classLoader instanceof LaunchClassLoader) {
            ((LaunchClassLoader)classLoader).addURL(url);
        } else {
            try {
                Method mAddUrl = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                mAddUrl.setAccessible(true);
                mAddUrl.invoke((Object)classLoader, url);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static File getPathToResource(Class<?> contextClass, String resource) {
        URL res = contextClass.getResource(resource);
        if (res == null) {
            return null;
        }
        boolean returnParent = true;
        String jarPath = res.toString();
        if (jarPath.startsWith("jar:") && jarPath.indexOf(33) > -1) {
            jarPath = jarPath.substring(4, jarPath.indexOf(33));
            returnParent = false;
        }
        if (jarPath.startsWith("file:")) {
            try {
                File targetFile = new File(new URI(jarPath));
                return returnParent ? targetFile.getParentFile() : targetFile;
            }
            catch (URISyntaxException ex) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean deleteClassPathJarContaining(Class<?> contextClass, String resource) {
        File jarFile = ClassPathUtilities.getPathToResource(contextClass, resource);
        if (jarFile != null && jarFile.exists() && jarFile.isFile() && jarFile.getName().endsWith(".jar")) {
            return ClassPathUtilities.deleteClassPathJar(jarFile.getName());
        }
        return false;
    }

    public static boolean deleteClassPathJar(String jarFileName) {
        try {
            JarFile jar = ClassPathUtilities.getJarFromClassLoader((URLClassLoader)Launch.classLoader, jarFileName, false);
            JarFile parentJar = ClassPathUtilities.getJarFromClassLoader((URLClassLoader)Launch.class.getClassLoader(), jarFileName, false);
            if (jar != null && parentJar != null && jar.getName().equals(parentJar.getName())) {
                final JarFile jarInClassLoader = ClassPathUtilities.getJarFromClassLoader((URLClassLoader)Launch.classLoader, jarFileName, true);
                final JarFile jarInParentClassLoader = ClassPathUtilities.getJarFromClassLoader((URLClassLoader)Launch.class.getClassLoader(), jarFileName, true);
                final File jarFileInClassLoader = new File(jarInClassLoader.getName());
                final File jarFileInParentClassLoader = new File(jarInParentClassLoader.getName());
                try {
                    Boolean deleted = AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                        @Override
                        public Boolean run() throws Exception {
                            jarInClassLoader.close();
                            jarInParentClassLoader.close();
                            boolean deletedJarFile = jarFileInClassLoader.delete();
                            boolean deletedParentJarFile = jarFileInParentClassLoader.delete();
                            return deletedJarFile || deletedParentJarFile;
                        }
                    });
                    return deleted;
                }
                catch (PrivilegedActionException ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    private static JarFile getJarFromClassLoader(URLClassLoader classLoader, String fileName, boolean removeFromClassPath) throws MalformedURLException {
        JarFile jar = null;
        try {
            URLClassPath classPath = (URLClassPath)ucp.get(classLoader);
            Map loaderMap = (Map)classPathLoaderMap.get(classPath);
            for (Map.Entry loaderEntry : loaderMap.entrySet()) {
                String url = (String)loaderEntry.getKey();
                if (!url.endsWith(fileName)) continue;
                Object loader = loaderEntry.getValue();
                Field jarField = loader.getClass().getDeclaredField("jar");
                jarField.setAccessible(true);
                jar = (JarFile)jarField.get(loader);
                if (!removeFromClassPath) continue;
                jarField.set(loader, null);
                Stack urls = (Stack)classPathURLs.get(classPath);
                ArrayList path = (ArrayList)classPathPath.get(classPath);
                ArrayList loaders = (ArrayList)classPathLoaderList.get(classPath);
                loaders.remove(loader);
                loaderMap.remove(url);
                URL jarURL = new URL(url);
                urls.remove(jarURL);
                path.remove(jarURL);
            }
        }
        catch (IllegalArgumentException ex) {
        }
        catch (SecurityException ex) {
        }
        catch (IllegalAccessException ex) {
        }
        catch (NoSuchFieldException ex) {
            ex.printStackTrace();
        }
        return jar;
    }

    static {
        try {
            ucp = URLClassLoader.class.getDeclaredField("ucp");
            ucp.setAccessible(true);
            classPathURLs = URLClassPath.class.getDeclaredField("urls");
            classPathURLs.setAccessible(true);
            classPathPath = URLClassPath.class.getDeclaredField("path");
            classPathPath.setAccessible(true);
            classPathLoaderMap = URLClassPath.class.getDeclaredField("lmap");
            classPathLoaderMap.setAccessible(true);
            classPathLoaderList = URLClassPath.class.getDeclaredField("loaders");
            classPathLoaderList.setAccessible(true);
            canInject = true;
        }
        catch (Throwable th) {
            LiteLoaderLogger.severe(th, "ClassPathUtilities: Error initialising ClassPathUtilities, special class path injection disabled", new Object[0]);
            th.printStackTrace();
        }
    }
}

