/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.gui;

import com.mumfrey.liteloader.LiteMod;
import com.mumfrey.liteloader.core.EnabledModsList;
import com.mumfrey.liteloader.core.LiteLoader;
import com.mumfrey.liteloader.core.LiteLoaderVersion;
import com.mumfrey.liteloader.core.Loadable;
import com.mumfrey.liteloader.gui.GuiAboutPanel;
import com.mumfrey.liteloader.gui.GuiCheckUpdatePanel;
import com.mumfrey.liteloader.gui.GuiCheckbox;
import com.mumfrey.liteloader.gui.GuiConfigPanelContainer;
import com.mumfrey.liteloader.gui.GuiHoverLabel;
import com.mumfrey.liteloader.gui.GuiLiteLoaderLog;
import com.mumfrey.liteloader.gui.GuiModListEntry;
import com.mumfrey.liteloader.gui.GuiSimpleScrollBar;
import com.mumfrey.liteloader.gui.ModInfoScreenPanel;
import com.mumfrey.liteloader.modconfig.ConfigManager;
import com.mumfrey.liteloader.modconfig.ConfigPanel;
import java.nio.DoubleBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.lwjgl.BufferUtils;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiScreenModInfo
extends bcd {
    private static final int LEFT_EDGE = 80;
    private static final int MARGIN = 12;
    private static final int TAB_WIDTH = 20;
    private static final int TAB_HEIGHT = 40;
    private static final int TAB_TOP = 20;
    private static final int PANEL_TOP = 83;
    private static final int PANEL_BOTTOM = 26;
    private static final int SCROLLBAR_WIDTH = 5;
    private static final double TWEEN_RATE = 0.08;
    private static DoubleBuffer doubleBuffer = BufferUtils.createByteBuffer((int)64).asDoubleBuffer();
    public static bqo aboutTextureResource = new bqo("liteloader", "textures/gui/about.png");
    private bcd mainMenu;
    private long tickNumber;
    private double lastTick;
    private double tweenAmount = 0.0;
    private boolean mouseDown;
    private boolean toggled;
    private int doubleClickTime = 0;
    private float tabOpacity = 0.0f;
    private boolean hideTab = true;
    private List<GuiModListEntry> mods = new ArrayList<GuiModListEntry>();
    private GuiModListEntry selectedMod = null;
    private String activeModText;
    private String versionText;
    private int listHeight = 100;
    private GuiSimpleScrollBar scrollBar = new GuiSimpleScrollBar();
    private ban btnToggle;
    private ban btnConfig;
    private GuiCheckbox chkEnabled;
    private ConfigManager configManager;
    private ModInfoScreenPanel currentPanel;

    public GuiScreenModInfo(azd minecraft, bcd mainMenu, LiteLoader loader, EnabledModsList enabledModsList, ConfigManager configManager, boolean hideTab) {
        this.k = minecraft;
        this.q = minecraft.l;
        this.mainMenu = mainMenu;
        this.configManager = configManager;
        this.hideTab = hideTab;
        this.versionText = bra.a((String)"gui.about.versiontext", (Object[])new Object[]{LiteLoader.getVersion()});
        this.populateModList(loader, enabledModsList);
    }

    private void populateModList(LiteLoader loader, EnabledModsList enabledModsList) {
        GuiModListEntry modListEntry;
        this.activeModText = bra.a((String)"gui.about.modsloaded", (Object[])new Object[]{loader.getLoadedMods().size()});
        TreeMap<String, GuiModListEntry> sortedMods = new TreeMap<String, GuiModListEntry>();
        for (LiteMod liteMod : loader.getLoadedMods()) {
            modListEntry = new GuiModListEntry(loader, enabledModsList, this.k.l, liteMod);
            sortedMods.put(modListEntry.getKey(), modListEntry);
        }
        for (Loadable loadable : loader.getDisabledMods()) {
            modListEntry = new GuiModListEntry(loader, enabledModsList, this.k.l, loadable);
            sortedMods.put(modListEntry.getKey(), modListEntry);
        }
        for (Loadable loadable : loader.getInjectedTweaks()) {
            modListEntry = new GuiModListEntry(loader, enabledModsList, this.k.l, loadable);
            sortedMods.put(modListEntry.getKey(), modListEntry);
        }
        this.mods.addAll(sortedMods.values());
        if (this.mods.size() > 0) {
            this.selectedMod = this.mods.get(0);
        }
    }

    public void release() {
        this.mainMenu = null;
    }

    public bcd getScreen() {
        return this.mainMenu;
    }

    public boolean isTweeningOrOpen() {
        return this.tweenAmount > 0.0;
    }

    public void r_() {
        if (this.currentPanel != null) {
            this.currentPanel.setSize(this.l - 80, this.m);
        }
        int rightPanelLeftEdge = 96 + (this.l - 80 - 12 - 12 - 4) / 2;
        this.n.clear();
        this.btnToggle = new ban(0, rightPanelLeftEdge, this.m - 26 - 24, 90, 20, bra.a((String)"gui.enablemod", (Object[])new Object[0]));
        this.n.add(this.btnToggle);
        this.btnConfig = new ban(1, rightPanelLeftEdge + 92, this.m - 26 - 24, 69, 20, bra.a((String)"gui.modsettings", (Object[])new Object[0]));
        this.n.add(this.btnConfig);
        if (!this.hideTab) {
            this.chkEnabled = new GuiCheckbox(2, 92, this.m - 26 + 9, bra.a((String)"gui.about.showtabmessage", (Object[])new Object[0]));
            this.n.add(this.chkEnabled);
        }
        this.n.add(new GuiHoverLabel(3, 130 + this.q.a(this.versionText) + 6, 50, this.q, bra.a((String)"gui.about.checkupdates", (Object[])new Object[0])));
        this.selectMod(this.selectedMod);
        Keyboard.enableRepeatEvents((boolean)true);
    }

    public void b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void a(azd minecraft, int width, int height) {
        if (this.k.n == this) {
            this.mainMenu.a(minecraft, width, height);
        }
        super.a(minecraft, width, height);
    }

    public void c() {
        if (this.currentPanel != null) {
            this.currentPanel.onTick();
        }
        ++this.tickNumber;
        if (this.k.n == this) {
            this.k.n = this.mainMenu;
            this.mainMenu.c();
            this.k.n = this;
            if (this.chkEnabled != null) {
                this.chkEnabled.checked = LiteLoader.getInstance().getDisplayModInfoScreenTab();
            }
        }
        if (this.toggled) {
            this.onToggled();
        }
        if (this.doubleClickTime > 0) {
            --this.doubleClickTime;
        }
    }

    public void a(int mouseX, int mouseY, float partialTicks) {
        boolean active;
        boolean bl = active = this.k.n == this;
        if (active) {
            GL11.glClear((int)256);
            this.mainMenu.a(-10, -10, partialTicks);
            GL11.glClear((int)256);
        } else {
            this.l = this.mainMenu.l;
            this.m = this.mainMenu.m;
        }
        float xOffset = (float)(this.l - 80) * this.calcTween(partialTicks, active) + 16.0f + this.tabOpacity * -32.0f;
        int offsetMouseX = mouseX - (int)xOffset;
        boolean mouseOverTab = !this.hideTab && offsetMouseX > 60 && offsetMouseX < 80 && mouseY > 20 && mouseY < 60;
        this.handleMouseClick(offsetMouseX, mouseY, partialTicks, active, mouseOverTab);
        this.tabOpacity = mouseOverTab || this.isTweeningOrOpen() ? 0.5f : Math.max(0.0f, this.tabOpacity - partialTicks * 0.1f);
        this.drawPanel(offsetMouseX, mouseY, partialTicks, active, xOffset);
        if (mouseOverTab && this.tweenAmount < 0.01) {
            GuiScreenModInfo.drawTooltip(this.q, LiteLoader.getVersionDisplayString(), mouseX, mouseY, this.l, this.m, 0xFFFFFF, -1342177280);
            GuiScreenModInfo.drawTooltip(this.q, this.activeModText, mouseX, mouseY + 13, this.l, this.m, 0xCCCCCC, -1342177280);
        }
    }

    private void drawPanel(int mouseX, int mouseY, float partialTicks, boolean active, float xOffset) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)xOffset, (float)0.0f, (float)0.0f);
        GuiScreenModInfo.a((int)80, (int)0, (int)this.l, (int)this.m, (int)-1342177280);
        if (!this.hideTab) {
            GuiScreenModInfo.a((int)80, (int)0, (int)81, (int)20, (int)-1);
            GuiScreenModInfo.a((int)80, (int)60, (int)81, (int)this.m, (int)-1);
            this.k.N().a(aboutTextureResource);
            GuiScreenModInfo.glDrawTexturedRect(60, 20, 21, 40, 80, 80, 122, 160, 0.5f + this.tabOpacity);
        } else {
            GuiScreenModInfo.a((int)80, (int)0, (int)81, (int)this.m, (int)-1);
            this.k.N().a(aboutTextureResource);
        }
        if (this.isTweeningOrOpen()) {
            if (this.currentPanel != null && this.currentPanel.isCloseRequested()) {
                this.closeCurrentPanel();
            }
            if (this.currentPanel != null) {
                this.drawCurrentPanel(mouseX, mouseY, partialTicks);
            } else {
                this.drawInfoPanel(mouseX, mouseY, partialTicks, 80, 26);
                int innerWidth = this.l - 80 - 12 - 12 - 4;
                int panelWidth = innerWidth / 2;
                int panelHeight = this.m - 26 - 83;
                this.drawModsList(mouseX, mouseY, partialTicks, panelWidth, panelHeight);
                this.drawSelectedMod(mouseX, mouseY, partialTicks, panelWidth, panelHeight);
                super.a(mouseX, mouseY, partialTicks);
            }
        } else if (this.currentPanel != null) {
            this.closeCurrentPanel();
        }
        GL11.glPopMatrix();
    }

    private void drawCurrentPanel(int mouseX, int mouseY, float partialTicks) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)80.0f, (float)0.0f, (float)0.0f);
        this.currentPanel.draw(mouseX - 80, mouseY, partialTicks);
        GL11.glPopMatrix();
    }

    protected void drawInfoPanel(int mouseX, int mouseY, float partialTicks, int left, int bottom) {
        int right = this.l - 12 - 80 + left;
        GuiScreenModInfo.glDrawTexturedRect(left + 12, 12, 128, 40, 0, 0, 256, 80, 1.0f);
        GuiScreenModInfo.glDrawTexturedRect(right - 32, 12, 32, 45, 0, 80, 64, 170, 1.0f);
        this.q.b(this.versionText, left + 12 + 38, 50, -1);
        this.q.b(this.activeModText, left + 12 + 38, 60, -5592406);
        GuiScreenModInfo.a((int)(left + 12), (int)80, (int)right, (int)81, (int)-6710887);
        GuiScreenModInfo.a((int)(left + 12), (int)(this.m - bottom + 2), (int)right, (int)(this.m - bottom + 3), (int)-6710887);
    }

    private void drawModsList(int mouseX, int mouseY, float partialTicks, int width, int height) {
        this.scrollBar.drawScrollBar(mouseX, mouseY, partialTicks, 92 + width - 5, 83, 5, height, this.listHeight);
        GuiScreenModInfo.glEnableClipping(92, 92 + width - 5 - 1, 83, this.m - 26);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)(83 - this.scrollBar.getValue()), (float)0.0f);
        mouseY -= 83 - this.scrollBar.getValue();
        int yPos = 0;
        for (GuiModListEntry mod : this.mods) {
            yPos += mod.drawListEntry(mouseX, mouseY, partialTicks, 92, yPos, width - 6, mod == this.selectedMod);
        }
        yPos = 0;
        for (GuiModListEntry mod : this.mods) {
            yPos += mod.postRenderListEntry(mouseX, mouseY, partialTicks, 92, yPos, width - 6, mod == this.selectedMod);
        }
        GL11.glPopMatrix();
        GuiScreenModInfo.glDisableClipping();
        this.listHeight = yPos;
        this.scrollBar.setMaxValue(this.listHeight - height);
    }

    private void drawSelectedMod(int mouseX, int mouseY, float partialTicks, int width, int height) {
        if (this.selectedMod != null) {
            int left = 92 + width;
            int right = this.l - 12;
            int spaceForButtons = this.btnConfig.m || this.btnToggle.m ? 28 : 0;
            GuiScreenModInfo.glEnableClipping(left, right, 83, this.m - 26 - spaceForButtons);
            this.selectedMod.drawInfo(mouseX, mouseY, partialTicks, left, 83, right - left, height - spaceForButtons);
            GuiScreenModInfo.glDisableClipping();
        }
    }

    private void selectMod(GuiModListEntry mod) {
        if (this.selectedMod != null) {
            this.selectedMod.mouseReleased();
        }
        this.selectedMod = mod;
        this.btnToggle.m = false;
        this.btnConfig.m = false;
        if (this.selectedMod != null && this.selectedMod.canBeToggled()) {
            this.btnToggle.m = true;
            this.btnToggle.j = this.selectedMod.willBeEnabled() ? bra.a((String)"gui.disablemod", (Object[])new Object[0]) : bra.a((String)"gui.enablemod", (Object[])new Object[0]);
            this.btnConfig.m = this.configManager.hasPanel(this.selectedMod.getModClass());
        }
    }

    private void toggleSelectedMod() {
        if (this.selectedMod != null) {
            this.selectedMod.toggleEnabled();
            this.selectMod(this.selectedMod);
        }
    }

    protected void a(ban button) {
        if (button.k == 0) {
            this.toggleSelectedMod();
        }
        if (button.k == 1) {
            this.openConfigPanel();
        }
        if (button.k == 2 && this.chkEnabled != null) {
            this.chkEnabled.checked = !this.chkEnabled.checked;
            LiteLoader.getInstance().setDisplayModInfoScreenTab(this.chkEnabled.checked);
            if (!this.chkEnabled.checked) {
                this.chkEnabled.j = bra.a((String)"gui.about.showtabmessage", (Object[])new Object[0]) + bra.a((String)"gui.about.keystrokehint", (Object[])new Object[0]);
            }
        }
        if (button.k == 3) {
            this.setCurrentPanel(new GuiCheckUpdatePanel(this.k, LiteLoaderVersion.getUpdateSite(), "LiteLoader"));
        }
    }

    protected void a(char keyChar, int keyCode) {
        if (this.currentPanel != null) {
            this.currentPanel.keyPressed(keyChar, keyCode);
            return;
        }
        if (keyCode == 1) {
            this.onToggled();
            return;
        }
        if (keyCode == 200) {
            int selectedIndex = this.mods.indexOf((Object)this.selectedMod) - 1;
            if (selectedIndex > -1) {
                this.selectMod(this.mods.get(selectedIndex));
            }
            this.scrollSelectedModIntoView();
        } else if (keyCode == 208) {
            int selectedIndex = this.mods.indexOf((Object)this.selectedMod);
            if (selectedIndex > -1 && selectedIndex < this.mods.size() - 1) {
                this.selectMod(this.mods.get(selectedIndex + 1));
            }
            this.scrollSelectedModIntoView();
        } else if (keyCode == 57 || keyCode == 28 || keyCode == 156 || keyCode == 205) {
            this.toggleSelectedMod();
        } else if (keyCode == 61) {
            this.setCurrentPanel(new GuiLiteLoaderLog(this.k));
        } else if (keyCode == 59) {
            this.setCurrentPanel(new GuiAboutPanel(this.k, this));
        }
    }

    private void scrollSelectedModIntoView() {
        if (this.selectedMod == null) {
            return;
        }
        int yPos = 0;
        for (GuiModListEntry mod : this.mods) {
            if (mod == this.selectedMod) break;
            yPos += mod.getHeight();
        }
        if (yPos < this.scrollBar.getValue()) {
            this.scrollBar.setValue(yPos);
            return;
        }
        int panelHeight = this.m - 26 - 83;
        int modHeight = this.selectedMod.getHeight();
        if (yPos - this.scrollBar.getValue() + modHeight > panelHeight) {
            this.scrollBar.setValue(yPos - panelHeight + modHeight);
        }
    }

    protected void a(int mouseX, int mouseY, int button) {
        if (this.currentPanel != null) {
            this.currentPanel.mousePressed(mouseX - 80, mouseY, button);
            return;
        }
        if (button == 0) {
            if (this.scrollBar.wasMouseOver()) {
                this.scrollBar.setDragging(true);
            }
            if (mouseY > 83 && mouseY < this.m - 26) {
                GuiModListEntry lastSelectedMod = this.selectedMod;
                for (GuiModListEntry mod : this.mods) {
                    if (!mod.mouseWasOverListEntry()) continue;
                    this.selectMod(mod);
                    if (mod == lastSelectedMod && this.doubleClickTime > 0 && this.btnConfig.m) {
                        this.a(this.btnConfig);
                    }
                    this.doubleClickTime = 5;
                }
                if (this.selectedMod != null && this.selectedMod == lastSelectedMod) {
                    this.selectedMod.mousePressed();
                }
            }
        }
        super.a(mouseX, mouseY, button);
    }

    protected void b(int mouseX, int mouseY, int button) {
        if (this.currentPanel != null) {
            if (button == -1) {
                this.currentPanel.mouseMoved(mouseX - 80, mouseY);
            } else {
                this.currentPanel.mouseReleased(mouseX - 80, mouseY, button);
            }
            return;
        }
        if (button == 0) {
            this.scrollBar.setDragging(false);
            if (this.selectedMod != null) {
                this.selectedMod.mouseReleased();
            }
        }
        super.b(mouseX, mouseY, button);
    }

    public void d() {
        int mouseWheelDelta = Mouse.getEventDWheel();
        if (mouseWheelDelta != 0) {
            if (this.currentPanel != null) {
                this.currentPanel.mouseWheelScrolled(mouseWheelDelta);
            } else {
                this.mouseWheelScrolled(mouseWheelDelta / 8);
            }
        }
        super.d();
    }

    private void mouseWheelScrolled(int mouseWheelDelta) {
        if (this.selectedMod == null || !this.selectedMod.mouseWheelScrolled(mouseWheelDelta)) {
            this.scrollBar.offsetValue(-mouseWheelDelta);
        }
    }

    public void handleMouseClick(int mouseX, int mouseY, float partialTicks, boolean active, boolean mouseOverTab) {
        boolean mouseDown = Mouse.isButtonDown((int)0);
        if ((active && mouseX < 80 && this.tweenAmount > 0.75 || mouseOverTab) && !this.mouseDown && mouseDown) {
            this.mouseDown = true;
            this.toggled = true;
        } else if (this.mouseDown && !mouseDown) {
            this.mouseDown = false;
        }
    }

    private float calcTween(float partialTicks, boolean active) {
        double tickValue = (float)this.tickNumber + partialTicks;
        if (active && this.tweenAmount < 1.0) {
            this.tweenAmount = Math.min(1.0, this.tweenAmount + (tickValue - this.lastTick) * 0.08);
        } else if (!active && this.isTweeningOrOpen()) {
            this.tweenAmount = Math.max(0.0, this.tweenAmount - (tickValue - this.lastTick) * 0.08);
        }
        this.lastTick = tickValue;
        return 1.0f - (float)Math.sin(this.tweenAmount * 0.5 * Math.PI);
    }

    private void onToggled() {
        this.toggled = false;
        this.k.a((bcd)(this.k.n == this ? this.mainMenu : this));
    }

    private void openConfigPanel() {
        ConfigPanel panel;
        if (this.selectedMod != null && this.selectedMod.getModClass() != null && (panel = this.configManager.getPanel(this.selectedMod.getModClass())) != null) {
            this.setCurrentPanel(new GuiConfigPanelContainer(this.k, panel, this.selectedMod.getModInstance()));
        }
    }

    private void setCurrentPanel(ModInfoScreenPanel newPanel) {
        this.closeCurrentPanel();
        this.currentPanel = newPanel;
        this.currentPanel.setSize(this.l - 80, this.m);
        this.currentPanel.onShown();
    }

    private void closeCurrentPanel() {
        if (this.currentPanel != null) {
            this.currentPanel.onHidden();
            this.currentPanel = null;
        }
    }

    public static final boolean isSupportedOnScreen(bcd guiScreen) {
        return guiScreen instanceof btj || guiScreen instanceof bbw || guiScreen instanceof bbt;
    }

    protected static void drawTooltip(bag fontRenderer, String tooltipText, int mouseX, int mouseY, int screenWidth, int screenHeight, int colour, int backgroundColour) {
        int textSize = fontRenderer.a(tooltipText);
        mouseX = Math.max(0, Math.min(screenWidth - 4, mouseX - 4));
        mouseY = Math.max(0, Math.min(screenHeight - 16, mouseY));
        GuiScreenModInfo.a((int)(mouseX - textSize - 2), (int)mouseY, (int)(mouseX + 2), (int)(mouseY + 12), (int)backgroundColour);
        fontRenderer.a(tooltipText, mouseX - textSize, mouseY + 2, colour);
    }

    static void glDrawTexturedRect(int x, int y, int width, int height, int u, int v, int u2, int v2, float alpha) {
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glAlphaFunc((int)516, (float)0.0f);
        GL11.glEnable((int)3553);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        float texMapScale = 0.00390625f;
        blz tessellator = blz.a;
        tessellator.b();
        tessellator.a((double)(x + 0), (double)(y + height), 0.0, (double)((float)u * texMapScale), (double)((float)v2 * texMapScale));
        tessellator.a((double)(x + width), (double)(y + height), 0.0, (double)((float)u2 * texMapScale), (double)((float)v2 * texMapScale));
        tessellator.a((double)(x + width), (double)(y + 0), 0.0, (double)((float)u2 * texMapScale), (double)((float)v * texMapScale));
        tessellator.a((double)(x + 0), (double)(y + 0), 0.0, (double)((float)u * texMapScale), (double)((float)v * texMapScale));
        tessellator.a();
        GL11.glDisable((int)3042);
        GL11.glAlphaFunc((int)516, (float)0.01f);
    }

    static final void glEnableClipping(int xLeft, int xRight, int yTop, int yBottom) {
        if (xLeft != -1) {
            doubleBuffer.clear();
            doubleBuffer.put(1.0).put(0.0).put(0.0).put(-xLeft).flip();
            GL11.glClipPlane((int)12290, (DoubleBuffer)doubleBuffer);
            GL11.glEnable((int)12290);
        }
        if (xRight != -1) {
            doubleBuffer.clear();
            doubleBuffer.put(-1.0).put(0.0).put(0.0).put(xRight).flip();
            GL11.glClipPlane((int)12291, (DoubleBuffer)doubleBuffer);
            GL11.glEnable((int)12291);
        }
        if (yTop != -1) {
            doubleBuffer.clear();
            doubleBuffer.put(0.0).put(1.0).put(0.0).put(-yTop).flip();
            GL11.glClipPlane((int)12292, (DoubleBuffer)doubleBuffer);
            GL11.glEnable((int)12292);
        }
        if (yBottom != -1) {
            doubleBuffer.clear();
            doubleBuffer.put(0.0).put(-1.0).put(0.0).put(yBottom).flip();
            GL11.glClipPlane((int)12293, (DoubleBuffer)doubleBuffer);
            GL11.glEnable((int)12293);
        }
    }

    static final void glDisableClipping() {
        GL11.glDisable((int)12293);
        GL11.glDisable((int)12292);
        GL11.glDisable((int)12291);
        GL11.glDisable((int)12290);
    }
}

