/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.gui;

import com.mumfrey.liteloader.LiteMod;
import com.mumfrey.liteloader.core.EnabledModsList;
import com.mumfrey.liteloader.core.LiteLoader;
import com.mumfrey.liteloader.core.LiteLoaderEnumerator;
import com.mumfrey.liteloader.core.Loadable;
import com.mumfrey.liteloader.core.LoadableMod;
import com.mumfrey.liteloader.core.TweakContainer;
import com.mumfrey.liteloader.gui.GuiScreenModInfo;
import com.mumfrey.liteloader.gui.GuiSimpleScrollBar;
import java.util.Set;
import org.lwjgl.opengl.GL11;

public class GuiModListEntry
extends bai {
    private static final int PANEL_HEIGHT = 32;
    private static final int PANEL_SPACING = 4;
    private bag fontRenderer;
    private LiteMod modInstance;
    private Class<? extends LiteMod> modClass;
    private String identifier;
    private String name;
    private String version;
    private String author = bra.a((String)"gui.unknown", (Object[])new Object[0]);
    private String url = null;
    private String description = "";
    private boolean enabled;
    private boolean isMissingDependencies;
    private Set<String> missingDependencies;
    private boolean canBeToggled;
    private boolean willBeEnabled;
    private boolean mouseOverListEntry;
    private boolean mouseOverInfo;
    private boolean mouseOverScrollBar;
    private boolean external;
    private boolean providesTweak;
    private boolean providesTransformer;
    private GuiSimpleScrollBar scrollBar = new GuiSimpleScrollBar();

    GuiModListEntry(LiteLoader loader, EnabledModsList enabledMods, bag fontRenderer, LiteMod modInstance) {
        this.fontRenderer = fontRenderer;
        this.modInstance = modInstance;
        this.modClass = modInstance.getClass();
        this.identifier = loader.getModIdentifier(this.modClass);
        this.name = modInstance.getName();
        this.version = modInstance.getVersion();
        this.enabled = true;
        this.canBeToggled = this.identifier != null && enabledMods.saveAllowed();
        this.willBeEnabled = true;
        LoadableMod<?> modContainer = loader.getModContainer(this.modClass);
        this.author = modContainer.getAuthor();
        this.url = modContainer.getMetaValue("url", null);
        this.description = modContainer.getDescription(LiteLoaderEnumerator.getModClassName(modInstance));
        if (modContainer instanceof TweakContainer) {
            this.providesTweak = ((TweakContainer)((Object)modContainer)).hasTweakClass();
            this.providesTransformer = ((TweakContainer)((Object)modContainer)).hasClassTransformers();
        }
    }

    GuiModListEntry(LiteLoader loader, EnabledModsList enabledMods, bag fontRenderer, Loadable<?> modContainer) {
        this.fontRenderer = fontRenderer;
        this.identifier = modContainer.getIdentifier().toLowerCase();
        this.name = modContainer.getDisplayName();
        this.version = modContainer.getVersion();
        this.author = modContainer.getAuthor();
        this.enabled = modContainer.isEnabled(enabledMods, LiteLoader.getProfile());
        this.canBeToggled = modContainer.isToggleable() && enabledMods.saveAllowed();
        this.willBeEnabled = enabledMods.isEnabled(LiteLoader.getProfile(), this.identifier);
        this.external = modContainer.isExternalJar();
        this.description = modContainer.getDescription(null);
        if (modContainer instanceof LoadableMod) {
            LoadableMod loadableMod = (LoadableMod)modContainer;
            this.url = loadableMod.getMetaValue("url", null);
            this.missingDependencies = loadableMod.getMissingDependencies();
            boolean bl = this.isMissingDependencies = this.missingDependencies.size() > 0;
            if (this.isMissingDependencies) {
                this.enabled = false;
                this.description = bra.a((String)"gui.description.missingdeps", (Object[])new Object[0]) + "\n" + this.missingDependencies.toString();
            }
        }
        if (modContainer instanceof TweakContainer) {
            TweakContainer tweakContainer = (TweakContainer)modContainer;
            this.providesTweak = tweakContainer.hasTweakClass();
            this.providesTransformer = tweakContainer.hasClassTransformers();
        }
    }

    public int drawListEntry(int mouseX, int mouseY, float partialTicks, int xPosition, int yPosition, int width, boolean selected) {
        String status;
        int colour1 = selected ? (this.external ? -1337470550 : -1337489967) : -1342177280;
        this.a(xPosition, yPosition, xPosition + width, yPosition + 32, colour1, -1338821837);
        this.fontRenderer.b(this.name, xPosition + 5, yPosition + 2, this.isMissingDependencies ? -22016 : (this.enabled ? (this.external ? -12070486 : -1) : -6710887));
        this.fontRenderer.b(bra.a((String)"gui.about.versiontext", (Object[])new Object[]{this.version}), xPosition + 5, yPosition + 12, -6710887);
        String string = status = this.external ? bra.a((String)"gui.status.loaded", (Object[])new Object[0]) : bra.a((String)"gui.status.active", (Object[])new Object[0]);
        if (this.isMissingDependencies) {
            status = "\u00a7e" + bra.a((String)"gui.status.missingdeps", (Object[])new Object[0]);
            if (this.canBeToggled && !this.willBeEnabled) {
                status = "\u00a7c" + bra.a((String)"gui.status.pending.disabled", (Object[])new Object[0]);
            }
        } else if (this.canBeToggled) {
            if (!this.enabled && !this.willBeEnabled) {
                status = "\u00a77" + bra.a((String)"gui.status.disabled", (Object[])new Object[0]);
            }
            if (!this.enabled && this.willBeEnabled) {
                status = "\u00a7a" + bra.a((String)"gui.status.pending.enabled", (Object[])new Object[0]);
            }
            if (this.enabled && !this.willBeEnabled) {
                status = "\u00a7c" + bra.a((String)"gui.status.pending.disabled", (Object[])new Object[0]);
            }
        }
        this.fontRenderer.b(status, xPosition + 5, yPosition + 22, this.external ? -1337470550 : -12089903);
        this.mouseOverListEntry = this.isMouseOver(mouseX, mouseY, xPosition, yPosition, width, 32);
        GuiModListEntry.a((int)xPosition, (int)yPosition, (int)(xPosition + 1), (int)(yPosition + 32), (int)(this.mouseOverListEntry ? -1 : -6710887));
        return 36;
    }

    public int postRenderListEntry(int mouseX, int mouseY, float partialTicks, int xPosition, int yPosition, int width, boolean selected) {
        int iconX = xPosition + width - 14;
        if (this.providesTweak) {
            iconX = this.drawPropertyIcon(iconX, yPosition + 32 - 14, mouseX, mouseY, 158, 80, bra.a((String)"gui.mod.providestweak", (Object[])new Object[0]));
        }
        if (this.providesTransformer) {
            iconX = this.drawPropertyIcon(iconX, yPosition + 32 - 14, mouseX, mouseY, 170, 80, bra.a((String)"gui.mod.providestransformer", (Object[])new Object[0]));
        }
        return 36;
    }

    protected int drawPropertyIcon(int iconX, int yPosition, int mouseX, int mouseY, int u, int v, String tooltipText) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        azd.A().N().a(GuiScreenModInfo.aboutTextureResource);
        this.b(iconX, yPosition, u, v, 12, 12);
        if (mouseX >= iconX && mouseX <= iconX + 12 && mouseY >= yPosition && mouseY <= yPosition + 12) {
            GuiScreenModInfo.drawTooltip(this.fontRenderer, tooltipText, mouseX, mouseY, 4096, 4096, -1, Integer.MIN_VALUE);
        }
        return iconX - 14;
    }

    public int getHeight() {
        return 36;
    }

    public void drawInfo(int mouseX, int mouseY, float partialTicks, int xPosition, int yPosition, int width, int height) {
        int bottom = height + yPosition;
        this.mouseOverInfo = this.isMouseOver(mouseX, mouseY, xPosition, yPosition += 2, width, height);
        this.fontRenderer.b(this.name, xPosition + 5, yPosition, -1);
        this.fontRenderer.b(bra.a((String)"gui.about.versiontext", (Object[])new Object[]{this.version}), xPosition + 5, yPosition += 10, -6710887);
        GuiModListEntry.a((int)(xPosition + 5), (int)(yPosition += 10), (int)(xPosition + width), (int)(yPosition + 1), (int)-6710887);
        this.fontRenderer.b(bra.a((String)"gui.about.authors", (Object[])new Object[0]) + ": \u00a77" + this.author, xPosition + 5, yPosition += 4, -1);
        yPosition += 10;
        if (this.url != null) {
            this.fontRenderer.b(this.url, xPosition + 5, yPosition, -1337489967);
            yPosition += 10;
        }
        GuiModListEntry.a((int)(xPosition + 5), (int)yPosition, (int)(xPosition + width), (int)(yPosition + 1), (int)-6710887);
        GuiModListEntry.a((int)(xPosition + 5), (int)(bottom - 1), (int)(xPosition + width), (int)bottom, (int)-6710887);
        int scrollHeight = bottom - (yPosition += 4) - 3;
        int totalHeight = this.fontRenderer.b(this.description, width - 11);
        this.scrollBar.setMaxValue(totalHeight - scrollHeight);
        this.scrollBar.drawScrollBar(mouseX, mouseY, partialTicks, xPosition + width - 5, yPosition, 5, scrollHeight, totalHeight);
        this.mouseOverScrollBar = this.isMouseOver(mouseX, mouseY, xPosition + width - 5, yPosition, 5, scrollHeight);
        GuiScreenModInfo.glEnableClipping(-1, -1, yPosition, bottom - 3);
        this.fontRenderer.a(this.description, xPosition + 5, yPosition - this.scrollBar.getValue(), width - 11, -1);
    }

    private boolean isMouseOver(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX > x && mouseX < x + width && mouseY > y && mouseY < y + height;
    }

    public void mousePressed() {
        if (this.mouseOverScrollBar) {
            this.scrollBar.setDragging(true);
        }
    }

    public void mouseReleased() {
        this.scrollBar.setDragging(false);
    }

    public void toggleEnabled() {
        if (this.canBeToggled) {
            this.willBeEnabled = !this.willBeEnabled;
            LiteLoader.getInstance().setModEnabled(this.identifier, this.willBeEnabled);
        }
    }

    public String getKey() {
        return this.identifier + Integer.toHexString(((Object)((Object)this)).hashCode());
    }

    public LiteMod getModInstance() {
        return this.modInstance;
    }

    public Class<? extends LiteMod> getModClass() {
        return this.modClass;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean canBeToggled() {
        return this.canBeToggled;
    }

    public boolean willBeEnabled() {
        return this.willBeEnabled;
    }

    public boolean mouseWasOverListEntry() {
        return this.mouseOverListEntry;
    }

    public boolean mouseWheelScrolled(int mouseWheelDelta) {
        if (this.mouseOverInfo) {
            this.scrollBar.offsetValue(-mouseWheelDelta);
            return true;
        }
        return false;
    }
}

