/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.gui;

import com.mumfrey.liteloader.gui.GuiCheckbox;
import com.mumfrey.liteloader.gui.GuiHoverLabel;
import com.mumfrey.liteloader.gui.GuiScreenModInfo;
import com.mumfrey.liteloader.gui.GuiSimpleScrollBar;
import com.mumfrey.liteloader.gui.ModInfoScreenPanel;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import com.mumfrey.liteloader.util.net.PastebinUpload;
import java.net.URI;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.lwjgl.opengl.GL11;

public class GuiLiteLoaderLog
extends ModInfoScreenPanel {
    private static boolean useNativeRes = false;
    GuiSimpleScrollBar scrollBar = new GuiSimpleScrollBar();
    private List<String> logEntries = new ArrayList<String>();
    private long logIndex = -1L;
    private int totalHeight = -1;
    private GuiCheckbox chkScale;
    private float guiScale;
    private ban btnUpload;
    private PastebinUpload logUpload;
    private String pasteBinURL;
    private int throb;
    private boolean closeDialog;

    GuiLiteLoaderLog(azd minecraft) {
        super(minecraft);
    }

    private void updateLog() {
        this.logEntries = LiteLoaderLogger.getLogTail();
        this.logIndex = LiteLoaderLogger.getLogIndex();
        this.totalHeight = (int)((float)(this.logEntries.size() * 10) / (this.chkScale.checked ? this.guiScale : 1.0f));
        this.scrollBar.setMaxValue(this.totalHeight);
        this.scrollBar.setValue(this.totalHeight);
    }

    @Override
    void setSize(int width, int height) {
        super.setSize(width, height);
        this.controls.add(new ban(0, this.width - 59 - 12, this.height - 40 + 9, 60, 20, bra.a((String)"gui.done", (Object[])new Object[0])));
        this.btnUpload = new ban(1, this.width - 145 - 12, this.height - 40 + 9, 80, 20, bra.a((String)"gui.log.postlog", (Object[])new Object[0]));
        this.controls.add(this.btnUpload);
        this.chkScale = new GuiCheckbox(2, 12, this.height - 40 + 15, bra.a((String)"gui.log.scalecheckbox", (Object[])new Object[0]));
        this.controls.add(this.chkScale);
        this.chkScale.checked = useNativeRes;
        bam res = new bam(this.mc.u, this.mc.d, this.mc.e);
        this.guiScale = res.e();
        this.updateLog();
    }

    @Override
    void onShown() {
    }

    @Override
    void onHidden() {
    }

    @Override
    void onTick() {
        ++this.throb;
        if (LiteLoaderLogger.getLogIndex() > this.logIndex) {
            this.updateLog();
        }
        if (this.logUpload != null && this.logUpload.isCompleted()) {
            this.pasteBinURL = this.logUpload.getPasteUrl().trim();
            this.logUpload = null;
            int xMid = this.width / 2;
            if (this.pasteBinURL.startsWith("http:")) {
                LiteLoaderLogger.info("Log file upload succeeded, url is %s", this.pasteBinURL);
                int urlWidth = this.mc.l.a(this.pasteBinURL);
                this.controls.add(new GuiHoverLabel(3, xMid - urlWidth / 2, this.height / 2, this.mc.l, "\u00a7n" + this.pasteBinURL));
            } else {
                LiteLoaderLogger.info("Log file upload failed, reason is %s", this.pasteBinURL);
            }
            this.controls.add(new ban(4, xMid - 40, this.height - 40 - 12 - 24, 80, 20, bra.a((String)"gui.log.closedialog", (Object[])new Object[0])));
        }
        if (this.closeDialog) {
            this.closeDialog = false;
            this.pasteBinURL = null;
            this.setSize(this.width, this.height);
        }
    }

    @Override
    void draw(int mouseX, int mouseY, float partialTicks) {
        this.innerTop = 26 - this.scrollBar.getValue();
        this.mc.l.b(bra.a((String)"gui.log.title", (Object[])new Object[0]), 12, 12, -1);
        GuiLiteLoaderLog.a((int)12, (int)22, (int)(this.width - 12), (int)23, (int)-6710887);
        GuiLiteLoaderLog.a((int)12, (int)(this.height - 40 + 2), (int)(this.width - 12), (int)(this.height - 40 + 3), (int)-6710887);
        GuiScreenModInfo.glEnableClipping(12, this.width - 12 - 6, 26, this.height - 40);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)12.0f, (float)this.innerTop, (float)0.0f);
        this.drawLog(this.scrollBar.getValue());
        GuiScreenModInfo.glDisableClipping();
        GL11.glPopMatrix();
        int xMid = this.width / 2;
        int yMid = this.height / 2;
        if (this.logUpload != null || this.pasteBinURL != null) {
            GuiLiteLoaderLog.a((int)24, (int)38, (int)(this.width - 12 - 12), (int)(this.height - 40 - 12), (int)-1073741824);
            if (this.logUpload != null) {
                this.a(this.mc.l, bra.a((String)"gui.log.uploading", (Object[])new Object[0]), xMid, yMid - 10, -1);
                this.drawThrobber(xMid - 90, yMid - 14, this.throb);
            } else if (this.pasteBinURL.startsWith("http:")) {
                this.a(this.mc.l, bra.a((String)"gui.log.uploadsuccess", (Object[])new Object[0]), xMid, yMid - 14, -11141291);
            } else {
                this.a(this.mc.l, bra.a((String)"gui.log.uploadfailed", (Object[])new Object[0]), xMid, yMid - 10, -43691);
            }
        }
        this.scrollBar.setMaxValue(this.totalHeight - this.innerHeight);
        this.scrollBar.drawScrollBar(mouseX, mouseY, partialTicks, this.width - 12 - 5, 26, 5, this.innerHeight, Math.max(this.innerHeight, this.totalHeight));
        super.draw(mouseX, mouseY, partialTicks);
    }

    private void drawLog(int offset) {
        int yPos = 0;
        int height = this.innerHeight;
        if (this.chkScale.checked) {
            float scale = 1.0f / this.guiScale;
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            height = (int)((float)height * this.guiScale);
            offset = (int)((float)offset * this.guiScale);
        }
        for (String logLine : this.logEntries) {
            if (yPos > offset - 10 && yPos <= offset + height) {
                this.mc.l.b(logLine, 0, yPos, this.getMessageColour(logLine.toLowerCase()));
            }
            yPos += 10;
        }
    }

    private int getMessageColour(String logLine) {
        if (logLine.startsWith("liteloader")) {
            return 0xFFFFFF;
        }
        if (logLine.startsWith("active pack:")) {
            return 0xFFFF55;
        }
        if (logLine.startsWith("success")) {
            return 0x55FF55;
        }
        if (logLine.startsWith("discovering")) {
            return 0xFFFF55;
        }
        if (logLine.startsWith("searching")) {
            return 43520;
        }
        if (logLine.startsWith("considering")) {
            return 0xFFAA00;
        }
        if (logLine.startsWith("not adding")) {
            return 0xFF5555;
        }
        if (logLine.startsWith("mod in")) {
            return 0xAA0000;
        }
        if (logLine.startsWith("error")) {
            return 0xAA0000;
        }
        if (logLine.startsWith("adding newest")) {
            return 0x5555FF;
        }
        if (logLine.startsWith("found")) {
            return 0xFFFF55;
        }
        if (logLine.startsWith("discovered")) {
            return 0xFFFF55;
        }
        if (logLine.startsWith("setting up")) {
            return 0xAA00AA;
        }
        if (logLine.startsWith("adding \"")) {
            return 0xAA00AA;
        }
        if (logLine.startsWith("injecting")) {
            return 0xFF55FF;
        }
        if (logLine.startsWith("loading")) {
            return 0x5555FF;
        }
        if (logLine.startsWith("initialising")) {
            return 0x55FFFF;
        }
        if (logLine.startsWith("calling late")) {
            return 43690;
        }
        if (logLine.startsWith("dependency check")) {
            return 0xFFAA00;
        }
        if (logLine.startsWith("dependency")) {
            return 0xFF5500;
        }
        return 0xCCCCCC;
    }

    @Override
    void actionPerformed(ban control) {
        if (control.k == 0) {
            this.close();
        }
        if (control.k == 1) {
            this.postLog();
        }
        if (control.k == 2 && this.chkScale != null) {
            useNativeRes = this.chkScale.checked = !this.chkScale.checked;
            this.updateLog();
        }
        if (control.k == 3 && this.pasteBinURL != null) {
            this.openURI(URI.create(this.pasteBinURL));
        }
        if (control.k == 4) {
            this.closeDialog = true;
        }
    }

    @Override
    void mouseWheelScrolled(int mouseWheelDelta) {
        this.scrollBar.offsetValue(-mouseWheelDelta / 8);
    }

    @Override
    void mousePressed(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0 && this.scrollBar.wasMouseOver()) {
            this.scrollBar.setDragging(true);
        }
        super.mousePressed(mouseX, mouseY, mouseButton);
    }

    @Override
    void mouseReleased(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0) {
            this.scrollBar.setDragging(false);
        }
    }

    @Override
    void mouseMoved(int mouseX, int mouseY) {
    }

    @Override
    void keyPressed(char keyChar, int keyCode) {
        if (keyCode == 1) {
            this.close();
        }
        if (keyCode == 57) {
            this.actionPerformed(this.chkScale);
        }
        if (keyCode == 200) {
            this.scrollBar.offsetValue(-10);
        }
        if (keyCode == 208) {
            this.scrollBar.offsetValue(10);
        }
        if (keyCode == 201) {
            this.scrollBar.offsetValue(-this.innerHeight + 10);
        }
        if (keyCode == 209) {
            this.scrollBar.offsetValue(this.innerHeight - 10);
        }
        if (keyCode == 199) {
            this.scrollBar.setValue(0);
        }
        if (keyCode == 207) {
            this.scrollBar.setValue(this.totalHeight);
        }
    }

    private void postLog() {
        this.btnUpload.l = false;
        StringBuilder completeLog = new StringBuilder();
        for (String logLine : this.logEntries) {
            completeLog.append(logLine).append("\r\n");
        }
        String pasteName = "LiteLoaderLog-" + DateFormat.getDateTimeInstance().format(new Date());
        LiteLoaderLogger.info("Uploading log file %s to pastebin...", pasteName);
        this.logUpload = new PastebinUpload("LiteLoader", pasteName, completeLog.toString(), PastebinUpload.UNLISTED);
        this.logUpload.start();
    }

    private void openURI(URI uri) {
        try {
            Class<?> desktop = Class.forName("java.awt.Desktop");
            Object instance = desktop.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            desktop.getMethod("browse", URI.class).invoke(instance, uri);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

