/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.core.transformers;

import com.mumfrey.liteloader.core.runtime.Obf;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class CrashReportTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (Obf.CrashReport$6.name.equals(name) || Obf.CrashReport$6.obf.equals(name)) {
            try {
                return this.transformCallableJVMFlags(basicClass);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return basicClass;
    }

    private byte[] transformCallableJVMFlags(byte[] basicClass) {
        ClassReader classReader = new ClassReader(basicClass);
        ClassNode classNode = new ClassNode();
        classReader.accept((ClassVisitor)classNode, 8);
        for (MethodNode method : classNode.methods) {
            if (!"<init>".equals(method.name)) continue;
            this.transformCallableJVMFlagsConstructor(method);
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public void transformCallableJVMFlagsConstructor(MethodNode ctor) {
        InsnList code = new InsnList();
        code.add((AbstractInsnNode)new VarInsnNode(25, 1));
        code.add((AbstractInsnNode)new MethodInsnNode(184, "com/mumfrey/liteloader/core/LiteLoader", "populateCrashReport", "(Ljava/lang/Object;)V"));
        for (AbstractInsnNode insnNode : ctor.instructions) {
            if (insnNode.getOpcode() != 177) continue;
            ctor.instructions.insertBefore(insnNode, code);
        }
    }
}

