/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.core;

import com.mumfrey.liteloader.util.PrivateFields;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import java.util.List;

public class SoundHandlerReloadInhibitor {
    private bqx resourceManager;
    private btc soundHandler;
    private boolean inhibited;
    private int storedIndex;

    SoundHandlerReloadInhibitor(bqx resourceManager, btc soundHandler) {
        this.resourceManager = resourceManager;
        this.soundHandler = soundHandler;
    }

    public boolean inhibit() {
        try {
            List<bqq> reloadListeners;
            if (!this.inhibited && (reloadListeners = PrivateFields.reloadListeners.get(this.resourceManager)) != null) {
                this.storedIndex = reloadListeners.indexOf(this.soundHandler);
                if (this.storedIndex > -1) {
                    LiteLoaderLogger.info("Inhibiting sound handler reload", new Object[0]);
                    reloadListeners.remove(this.soundHandler);
                    this.inhibited = true;
                    return true;
                }
            }
        }
        catch (Exception ex) {
            LiteLoaderLogger.warning("Error inhibiting sound handler reload", new Object[0]);
        }
        return false;
    }

    public boolean unInhibit(boolean reload) {
        try {
            List<bqq> reloadListeners;
            if (this.inhibited && (reloadListeners = PrivateFields.reloadListeners.get(this.resourceManager)) != null) {
                if (this.storedIndex > -1) {
                    reloadListeners.add(this.storedIndex, (bqq)this.soundHandler);
                } else {
                    reloadListeners.add((bqq)this.soundHandler);
                }
                LiteLoaderLogger.info("Sound handler reload inhibit removed", new Object[0]);
                if (reload) {
                    LiteLoaderLogger.info("Reloading sound handler", new Object[0]);
                    this.soundHandler.a((bqp)this.resourceManager);
                }
                this.inhibited = false;
                return true;
            }
        }
        catch (Exception ex) {
            LiteLoaderLogger.warning("Error removing sound handler reload inhibit", new Object[0]);
        }
        return false;
    }

    public boolean isInhibited() {
        return this.inhibited;
    }
}

