/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.core;

import com.mumfrey.liteloader.LiteMod;
import com.mumfrey.liteloader.ServerPluginChannelListener;
import com.mumfrey.liteloader.core.LiteLoader;
import com.mumfrey.liteloader.core.PluginChannels;
import com.mumfrey.liteloader.core.exceptions.UnregisteredChannelException;
import com.mumfrey.liteloader.permissions.PermissionsManagerClient;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import java.util.LinkedList;

public class ServerPluginChannels
extends PluginChannels<ServerPluginChannelListener> {
    private static ServerPluginChannels instance;

    ServerPluginChannels() {
        instance = this;
    }

    static ServerPluginChannels getInstance() {
        return instance;
    }

    void addListener(LiteMod listener) {
        if (listener instanceof ServerPluginChannelListener) {
            this.addPluginChannelListener((ServerPluginChannelListener)listener);
        }
    }

    void onServerStartup() {
        this.clearPluginChannels(null);
    }

    void onPlayerJoined(mm player) {
        this.sendRegisteredPluginChannels(player);
    }

    public void onPluginChannelMessage(ib netHandler, in customPayload) {
        if (customPayload != null && customPayload.c() != null) {
            String channel = customPayload.c();
            byte[] data = customPayload.e();
            mm sender = ((mx)netHandler).b;
            this.onPluginChannelMessage(sender, channel, data);
        }
    }

    protected void onPluginChannelMessage(mm sender, String channel, byte[] data) {
        if ("REGISTER".equals(channel)) {
            this.onRegisterPacketReceived(data);
        } else if (this.pluginChannels.containsKey(channel)) {
            try {
                PermissionsManagerClient permissionsManager = LiteLoader.getPermissionsManager();
                if (permissionsManager != null) {
                    permissionsManager.onCustomPayload(channel, data.length, data);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.onModPacketReceived(sender, channel, data, data.length);
        }
    }

    protected void onModPacketReceived(mm sender, String channel, byte[] data, int length) {
        for (ServerPluginChannelListener pluginChannelListener : (LinkedList)this.pluginChannels.get(channel)) {
            try {
                pluginChannelListener.onCustomPayload(sender, channel, length, data);
                throw new RuntimeException();
            }
            catch (Exception ex) {
                int failCount = 1;
                if (this.faultingPluginChannelListeners.containsKey(pluginChannelListener)) {
                    failCount = (Integer)this.faultingPluginChannelListeners.get(pluginChannelListener) + 1;
                }
                if (failCount >= 1000) {
                    LiteLoaderLogger.warning("Plugin channel listener %s exceeded fault threshold on channel %s with %s", pluginChannelListener.getName(), channel, ex.getClass().getSimpleName());
                    this.faultingPluginChannelListeners.remove(pluginChannelListener);
                    continue;
                }
                this.faultingPluginChannelListeners.put(pluginChannelListener, failCount);
            }
        }
    }

    protected void sendRegisteredPluginChannels(mm player) {
        try {
            byte[] registrationData = this.getRegistrationData();
            if (registrationData != null) {
                this.sendRegistrationData(player, registrationData);
            }
        }
        catch (Exception ex) {
            LiteLoaderLogger.warning(ex, "Error dispatching REGISTER packet to client %s", player.b_());
        }
    }

    protected void sendRegistrationData(mm recipient, byte[] registrationData) {
        ServerPluginChannels.dispatch(recipient, new gi("REGISTER", registrationData));
    }

    static boolean dispatch(mm recipient, gi payload) {
        try {
            if (recipient != null && recipient.a != null) {
                recipient.a.a((fk)payload);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean sendMessage(mm recipient, String channel, byte[] data, PluginChannels.ChannelPolicy policy) {
        if (!policy.allows(ServerPluginChannels.getInstance(), channel)) {
            if (policy.isSilent()) {
                return false;
            }
            throw new UnregisteredChannelException(channel);
        }
        if (channel == null || channel.length() > 16 || "REGISTER".equals(channel) || "UNREGISTER".equals(channel)) {
            throw new RuntimeException("Invalid channel name specified");
        }
        gi payload = new gi(channel, data);
        return ServerPluginChannels.dispatch(recipient, payload);
    }
}

