/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.core;

import com.mumfrey.liteloader.core.ClientPluginChannels;
import com.mumfrey.liteloader.core.CommonPluginChannelListener;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class PluginChannels<L extends CommonPluginChannelListener> {
    protected static final String CHANNEL_REGISTER = "REGISTER";
    protected static final String CHANNEL_UNREGISTER = "UNREGISTER";
    protected static final int WARN_FAULT_THRESHOLD = 1000;
    protected HashMap<String, LinkedList<L>> pluginChannels = new HashMap();
    protected LinkedList<L> pluginChannelListeners = new LinkedList();
    protected Set<String> remotePluginChannels = new HashSet<String>();
    protected Map<L, Integer> faultingPluginChannelListeners = new HashMap<L, Integer>();

    PluginChannels() {
    }

    public Set<String> getLocalChannels() {
        return Collections.unmodifiableSet(this.pluginChannels.keySet());
    }

    public Set<String> getRemoteChannels() {
        return Collections.unmodifiableSet(this.remotePluginChannels);
    }

    public boolean isRemoteChannelRegistered(String channel) {
        return this.remotePluginChannels.contains(channel);
    }

    void addPluginChannelListener(L pluginChannelListener) {
        if (!this.pluginChannelListeners.contains(pluginChannelListener)) {
            this.pluginChannelListeners.add(pluginChannelListener);
        }
    }

    protected void clearPluginChannels(es netHandler) {
        this.pluginChannels.clear();
        this.remotePluginChannels.clear();
        this.faultingPluginChannelListeners.clear();
    }

    protected void onRegisterPacketReceived(byte[] data) {
        try {
            String channels = new String(data, "UTF8");
            for (String channel : channels.split("\u0000")) {
                this.remotePluginChannels.add(channel);
            }
        }
        catch (UnsupportedEncodingException ex) {
            LiteLoaderLogger.warning(ex, "Error decoding REGISTER packet from remote host %s", ex.getClass().getSimpleName());
        }
    }

    protected byte[] getRegistrationData() {
        for (CommonPluginChannelListener pluginChannelListener : this.pluginChannelListeners) {
            this.addPluginChannelsFor(pluginChannelListener);
        }
        if (this.pluginChannels.keySet().size() > 0) {
            StringBuilder channelList = new StringBuilder();
            boolean separator = false;
            for (String channel : this.pluginChannels.keySet()) {
                if (separator) {
                    channelList.append("\u0000");
                }
                channelList.append(channel);
                separator = true;
            }
            return channelList.toString().getBytes(Charset.forName("UTF8"));
        }
        return null;
    }

    protected void addPluginChannelsFor(L pluginChannelListener) {
        List<String> channels = pluginChannelListener.getChannels();
        if (channels != null) {
            for (String channel : channels) {
                if (channel.length() > 16 || channel.toUpperCase().equals(CHANNEL_REGISTER) || channel.toUpperCase().equals(CHANNEL_UNREGISTER)) continue;
                if (!this.pluginChannels.containsKey(channel)) {
                    this.pluginChannels.put(channel, new LinkedList());
                }
                this.pluginChannels.get(channel).add(pluginChannelListener);
            }
        }
    }

    @Deprecated
    public static boolean sendMessage(String channel, byte[] data, ChannelPolicy policy) {
        return ClientPluginChannels.sendMessage(channel, data, policy);
    }

    public static enum ChannelPolicy {
        DISPATCH,
        DISPATCH_IF_REGISTERED,
        DISPATCH_ALWAYS;


        public boolean allows(PluginChannels<?> channels, String channel) {
            if (this == DISPATCH_ALWAYS) {
                return true;
            }
            return channels.isRemoteChannelRegistered(channel);
        }

        public boolean isSilent() {
            return this != DISPATCH_IF_REGISTERED;
        }
    }
}

