/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.core;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.mumfrey.liteloader.core.LoadableFile;
import com.mumfrey.liteloader.core.LoadableMod;
import com.mumfrey.liteloader.launch.InjectionStrategy;
import com.mumfrey.liteloader.resources.ModResourcePack;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import joptsimple.internal.Strings;

public class LoadableModFile
extends LoadableFile
implements LoadableMod<File> {
    private static final long serialVersionUID = -7952147161905688459L;
    private static final int MAX_DISCOVERY_DEPTH = 16;
    protected static Gson gson = new Gson();
    protected boolean valid = false;
    protected String modName;
    protected String targetVersion;
    protected List<String> classTransformerClassNames = new ArrayList<String>();
    protected long timeStamp;
    protected float revision = 0.0f;
    protected boolean hasRevision = false;
    protected Object resourcePack = null;
    protected Map<String, String> metaData = new HashMap<String, String>();
    private Set<String> dependencies = new HashSet<String>();
    private Set<String> missingDependencies = new HashSet<String>();
    protected List<String> classNames = null;

    LoadableModFile(File file, String strVersion) {
        super(file.getAbsolutePath());
        this.timeStamp = this.lastModified();
        this.parseVersionFile(strVersion);
    }

    protected void parseVersionFile(String strVersionData) {
        if (Strings.isNullOrEmpty((String)strVersionData)) {
            return;
        }
        try {
            this.metaData = (Map)gson.fromJson(strVersionData, HashMap.class);
        }
        catch (JsonSyntaxException jsx) {
            LiteLoaderLogger.warning("Error reading %s in %s, JSON syntax exception: %s", "litemod.json", this.getAbsolutePath(), jsx.getMessage());
            return;
        }
        this.modName = this.getMetaValue("name", this.getDefaultName());
        this.version = this.getMetaValue("version", "Unknown");
        this.author = this.getMetaValue("author", "Unknown");
        this.targetVersion = this.metaData.get("mcversion");
        if (this.targetVersion == null) {
            LiteLoaderLogger.warning("Mod in %s has no loader version number reading %s" + this.getAbsolutePath(), "litemod.json");
            return;
        }
        try {
            this.revision = Float.parseFloat(this.metaData.get("revision"));
            this.hasRevision = true;
        }
        catch (NullPointerException ex) {
        }
        catch (Exception ex) {
            LiteLoaderLogger.warning("Mod in %s has an invalid revision number reading %s", this.getAbsolutePath(), "litemod.json");
        }
        this.valid = true;
        this.tweakClassName = this.metaData.get("tweakClass");
        this.tweakPriority = 0;
        for (String name : this.getMetaValues("classTransformerClasses", ",")) {
            if (Strings.isNullOrEmpty((String)name)) continue;
            this.classTransformerClassNames.add(name);
        }
        this.injectionStrategy = InjectionStrategy.parseStrategy(this.metaData.get("injectAt"));
        for (String dependency : this.getMetaValues("dependsOn", ",")) {
            this.dependencies.add(dependency);
        }
    }

    protected String getDefaultName() {
        return this.getName().replaceAll("[^a-zA-Z]", "");
    }

    @Override
    public String getModName() {
        return this.modName;
    }

    @Override
    public String getIdentifier() {
        return this.modName.toLowerCase();
    }

    @Override
    public String getDisplayName() {
        return this.getName();
    }

    @Override
    public String getDescription(String key) {
        String descriptionKey = "description";
        if (key != null && key.length() > 0) {
            descriptionKey = descriptionKey + "." + key.toLowerCase();
        }
        return this.getMetaValue(descriptionKey, this.getMetaValue("description", ""));
    }

    @Override
    public boolean isExternalJar() {
        return false;
    }

    @Override
    public boolean isToggleable() {
        return true;
    }

    @Override
    public boolean hasValidMetaData() {
        return this.valid;
    }

    @Override
    public String getTargetVersion() {
        return this.targetVersion;
    }

    @Override
    public float getRevision() {
        return this.revision;
    }

    @Override
    public String getMetaValue(String metaKey, String defaultValue) {
        return this.metaData.containsKey(metaKey) ? this.metaData.get(metaKey) : defaultValue;
    }

    public String[] getMetaValues(String metaKey, String separator) {
        return this.metaData.containsKey(metaKey) ? this.metaData.get(metaKey).split(separator) : new String[]{};
    }

    @Override
    public Set<String> getMetaDataKeys() {
        return Collections.unmodifiableSet(this.metaData.keySet());
    }

    @Override
    public boolean hasClassTransformers() {
        return this.classTransformerClassNames.size() > 0;
    }

    @Override
    public List<String> getClassTransformerClassNames() {
        return this.classTransformerClassNames;
    }

    @Override
    public <T> T getResourcePack() {
        return (T)this.resourcePack;
    }

    @Override
    public void initResourcePack(String name) {
        if (this.resourcePack == null) {
            LiteLoaderLogger.info("Setting up \"%s\" as mod resource pack with identifier \"%s\"", this.getName(), name);
            this.resourcePack = new ModResourcePack(name, this);
        }
    }

    @Override
    public boolean hasResourcePack() {
        return this.resourcePack != null;
    }

    @Override
    public boolean hasDependencies() {
        return this.dependencies.size() > 0;
    }

    @Override
    public Set<String> getDependencies() {
        return this.dependencies;
    }

    @Override
    public void registerMissingDependency(String dependency) {
        this.missingDependencies.add(dependency);
    }

    @Override
    public Set<String> getMissingDependencies() {
        return this.missingDependencies;
    }

    @Override
    public List<String> getContainedClassNames() {
        if (this.classNames == null) {
            this.classNames = this.enumerateClassNames();
        }
        return this.classNames;
    }

    protected List<String> enumerateClassNames() {
        if (this.isDirectory()) {
            return LoadableModFile.enumerateDirectory(new ArrayList<String>(), this, "", 0);
        }
        return LoadableModFile.enumerateZipFile(this);
    }

    @Override
    public void addContainedMod(String modName) {
    }

    @Override
    public int compareTo(File other) {
        if (other == null || !(other instanceof LoadableModFile)) {
            return -1;
        }
        LoadableModFile otherMod = (LoadableModFile)other;
        if (otherMod.hasRevision) {
            return this.hasRevision && this.revision - otherMod.revision > 0.0f ? -1 : 1;
        }
        if (this.hasRevision) {
            return -1;
        }
        return (int)(otherMod.timeStamp - this.timeStamp);
    }

    protected static List<String> enumerateZipFile(File file) {
        ZipFile zipFile;
        ArrayList<String> classes = new ArrayList<String>();
        try {
            zipFile = new ZipFile(file);
        }
        catch (IOException ex) {
            return classes;
        }
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String entryName = entry.getName();
            if (entry.getSize() <= 0L || !entryName.endsWith(".class")) continue;
            classes.add(entryName.substring(0, entryName.length() - 6).replace('/', '.'));
        }
        try {
            zipFile.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
        return classes;
    }

    protected static List<String> enumerateDirectory(List<String> classes, File packagePath, String packageName, int depth) {
        File[] classFiles;
        if (depth > 16) {
            return classes;
        }
        for (File classFile : classFiles = packagePath.listFiles()) {
            if (classFile.isDirectory()) {
                LoadableModFile.enumerateDirectory(classes, classFile, packageName + classFile.getName() + ".", depth + 1);
                continue;
            }
            if (!classFile.getName().endsWith(".class")) continue;
            String classFileName = classFile.getName();
            classes.add(packageName + classFileName.substring(0, classFileName.length() - 6));
        }
        return classes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String zipEntryToString(ZipFile zip, ZipEntry entry) throws IOException {
        BufferedReader reader = null;
        StringBuilder sb = new StringBuilder();
        try {
            String versionFileLine;
            InputStream stream = zip.getInputStream(entry);
            reader = new BufferedReader(new InputStreamReader(stream));
            while ((versionFileLine = reader.readLine()) != null) {
                sb.append(versionFileLine);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return sb.toString();
    }
}

