/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.core;

import com.google.common.primitives.Ints;
import com.mumfrey.liteloader.core.EnabledModsList;
import com.mumfrey.liteloader.core.TweakContainer;
import com.mumfrey.liteloader.launch.ClassPathUtilities;
import com.mumfrey.liteloader.launch.InjectionStrategy;
import com.mumfrey.liteloader.launch.LiteLoaderTweaker;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.launchwrapper.LaunchClassLoader;

public class LoadableFile
extends File
implements TweakContainer<File> {
    private static final Pattern versionPattern = Pattern.compile("([0-9]+\\.)+[0-9]+([_A-Z0-9]+)?");
    private static final long serialVersionUID = 1L;
    protected boolean injected;
    protected InjectionStrategy injectionStrategy = null;
    protected String tweakClassName;
    protected int tweakPriority = 1000;
    protected String[] classPathEntries = null;
    protected String displayName = this.getName();
    protected String version = "Unknown";
    protected String author = "Unknown";

    public LoadableFile(File parent) {
        super(parent.getAbsolutePath());
        this.guessVersionFromName();
        this.readMetaData();
    }

    protected LoadableFile(String pathname) {
        super(pathname);
    }

    private void guessVersionFromName() {
        Matcher versionPatternMatcher = versionPattern.matcher(this.getName());
        while (versionPatternMatcher.find()) {
            this.version = versionPatternMatcher.group();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readMetaData() {
        JarFile jar = null;
        try {
            jar = new JarFile(this);
            if (jar.getManifest() != null) {
                Integer tweakOrder;
                String classPath;
                LiteLoaderLogger.info("Searching for tweaks in '%s'", this.getName());
                Attributes manifestAttributes = jar.getManifest().getMainAttributes();
                this.tweakClassName = manifestAttributes.getValue("TweakClass");
                if (this.tweakClassName != null && (classPath = manifestAttributes.getValue("Class-Path")) != null) {
                    this.classPathEntries = classPath.split(" ");
                }
                if ((tweakOrder = Ints.tryParse((String)manifestAttributes.getValue("TweakOrder"))) != null) {
                    this.tweakPriority = tweakOrder;
                }
                if (manifestAttributes.getValue("Implementation-Title") != null) {
                    this.displayName = manifestAttributes.getValue("Implementation-Title");
                }
                if (manifestAttributes.getValue("TweakName") != null) {
                    this.displayName = manifestAttributes.getValue("TweakName");
                }
                if (manifestAttributes.getValue("Implementation-Version") != null) {
                    this.version = manifestAttributes.getValue("Implementation-Version");
                }
                if (manifestAttributes.getValue("TweakVersion") != null) {
                    this.version = manifestAttributes.getValue("TweakVersion");
                }
                if (manifestAttributes.getValue("Implementation-Vendor") != null) {
                    this.author = manifestAttributes.getValue("Implementation-Vendor");
                }
                if (manifestAttributes.getValue("TweakAuthor") != null) {
                    this.author = manifestAttributes.getValue("TweakAuthor");
                }
                this.injectionStrategy = InjectionStrategy.parseStrategy(manifestAttributes.getValue("TweakInjectionStrategy"), InjectionStrategy.TOP);
            }
        }
        catch (Exception ex) {
            LiteLoaderLogger.warning("Error parsing manifest entries in '%s'", this.getAbsolutePath());
        }
        finally {
            try {
                if (jar != null) {
                    jar.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public File getTarget() {
        return this;
    }

    @Override
    public File toFile() {
        return this;
    }

    @Override
    public String getLocation() {
        return this.getAbsolutePath();
    }

    @Override
    public URL getURL() throws MalformedURLException {
        return this.toURI().toURL();
    }

    @Override
    public String getIdentifier() {
        return this.getName().toLowerCase();
    }

    @Override
    public boolean hasTweakClass() {
        return this.tweakClassName != null;
    }

    @Override
    public String getTweakClassName() {
        return this.tweakClassName;
    }

    @Override
    public int getTweakPriority() {
        return this.tweakPriority;
    }

    @Override
    public String[] getClassPathEntries() {
        return this.classPathEntries;
    }

    @Override
    public boolean hasClassTransformers() {
        return false;
    }

    @Override
    public List<String> getClassTransformerClassNames() {
        return new ArrayList<String>();
    }

    @Override
    public boolean isInjected() {
        return this.injected;
    }

    @Override
    public boolean injectIntoClassPath(LaunchClassLoader classLoader, boolean injectIntoParent) throws MalformedURLException {
        if (!this.injected) {
            ClassPathUtilities.injectIntoClassPath((URLClassLoader)classLoader, this.getURL(), this.getInjectionStrategy());
            if (injectIntoParent) {
                LiteLoaderTweaker.addURLToParentClassLoader(this.getURL());
            }
            this.injected = true;
            return true;
        }
        return false;
    }

    @Override
    public InjectionStrategy getInjectionStrategy() {
        return this.injectionStrategy;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    @Override
    public String getDescription(String key) {
        return "";
    }

    @Override
    public boolean isExternalJar() {
        return true;
    }

    @Override
    public boolean isToggleable() {
        return false;
    }

    @Override
    public boolean isEnabled(EnabledModsList enabledModsList, String profile) {
        return enabledModsList.isEnabled(profile, this.getIdentifier());
    }
}

