/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.core;

import com.mumfrey.liteloader.LiteMod;
import com.mumfrey.liteloader.core.EnabledModsList;
import com.mumfrey.liteloader.core.EnumeratorModule;
import com.mumfrey.liteloader.core.EnumeratorModuleClassPath;
import com.mumfrey.liteloader.core.EnumeratorModuleFolder;
import com.mumfrey.liteloader.core.LiteLoaderBootstrap;
import com.mumfrey.liteloader.core.Loadable;
import com.mumfrey.liteloader.core.LoadableMod;
import com.mumfrey.liteloader.core.PluggableEnumerator;
import com.mumfrey.liteloader.core.TweakContainer;
import com.mumfrey.liteloader.core.exceptions.OutdatedLoaderException;
import com.mumfrey.liteloader.launch.LiteLoaderTweaker;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;

public class LiteLoaderEnumerator
implements PluggableEnumerator {
    private static final String OPTION_SEARCH_MODS = "search.mods";
    private static final String OPTION_SEARCH_JAR = "search.jar";
    private static final String OPTION_SEARCH_CLASSPATH = "search.classpath";
    private final LiteLoaderBootstrap bootstrap;
    private final LaunchClassLoader classLoader;
    private final EnabledModsList enabledModsList;
    private final Map<String, Class<? extends LiteMod>> modsToLoad = new HashMap<String, Class<? extends LiteMod>>();
    private final Map<String, LoadableMod<?>> disabledMods = new HashMap();
    private final Map<String, LoadableMod<?>> containers = new HashMap();
    private final Map<String, LoadableMod<?>> modContainers = new HashMap();
    private final List<TweakContainer<File>> tweakContainers = new ArrayList<TweakContainer<File>>();
    private final List<Loadable<File>> injectedTweaks = new ArrayList<Loadable<File>>();
    private final List<EnumeratorModule<?>> modules = new ArrayList();
    private boolean searchModsFolder = true;
    private boolean searchProtectionDomain = true;
    private boolean searchClassPath = true;

    public LiteLoaderEnumerator(LiteLoaderBootstrap bootstrap, LaunchClassLoader classLoader, EnabledModsList enabledModsList, boolean loadTweaks) {
        this.bootstrap = bootstrap;
        this.classLoader = classLoader;
        this.enabledModsList = enabledModsList;
        this.initModules(loadTweaks);
        this.getSharedModList();
    }

    private void initModules(boolean loadTweaks) {
        this.readSettings();
        if (this.searchClassPath) {
            this.registerModule(new EnumeratorModuleClassPath(loadTweaks));
        }
        if (this.searchProtectionDomain) {
            LiteLoaderLogger.info("Protection domain searching is no longer required or supported, protection domain search has been disabled", new Object[0]);
            this.searchProtectionDomain = false;
        }
        if (this.searchModsFolder) {
            File modsFolder = this.bootstrap.getModsFolder();
            this.registerModule(new EnumeratorModuleFolder(modsFolder, loadTweaks, true));
            File versionedModsFolder = this.bootstrap.getVersionedModsFolder();
            this.registerModule(new EnumeratorModuleFolder(versionedModsFolder, loadTweaks, false));
        }
        this.writeSettings();
    }

    public Map<String, Map<String, String>> getSharedModList() {
        try {
            HashMap sharedModList = (HashMap)Launch.blackboard.get("modList");
            if (sharedModList == null) {
                sharedModList = new HashMap();
                Launch.blackboard.put("modList", sharedModList);
            }
            return sharedModList;
        }
        catch (Exception ex) {
            LiteLoaderLogger.warning("Shared mod list was invalid or not accessible, this isn't especially bad but something isn't quite right", new Object[0]);
            return null;
        }
    }

    private void readSettings() {
        this.searchModsFolder = this.bootstrap.getAndStoreBooleanProperty(OPTION_SEARCH_MODS, true);
        this.searchProtectionDomain = this.bootstrap.getAndStoreBooleanProperty(OPTION_SEARCH_JAR, false);
        this.searchClassPath = this.bootstrap.getAndStoreBooleanProperty(OPTION_SEARCH_CLASSPATH, true);
        if (!(this.searchModsFolder || this.searchProtectionDomain || this.searchClassPath)) {
            LiteLoaderLogger.warning("Invalid configuration, no search locations defined. Enabling all search locations.", new Object[0]);
            this.searchModsFolder = true;
            this.searchClassPath = true;
        }
    }

    private void writeSettings() {
        this.bootstrap.setBooleanProperty(OPTION_SEARCH_MODS, this.searchModsFolder);
        this.bootstrap.setBooleanProperty(OPTION_SEARCH_JAR, this.searchProtectionDomain);
        this.bootstrap.setBooleanProperty(OPTION_SEARCH_CLASSPATH, this.searchClassPath);
    }

    @Override
    public void registerModule(EnumeratorModule<?> module) {
        if (module != null && !this.modules.contains(module)) {
            LiteLoaderLogger.info("Registering %s: %s", module.getClass().getSimpleName(), module);
            this.modules.add(module);
            module.init(this);
        }
    }

    @Override
    public boolean getAndStoreBooleanProperty(String propertyName, boolean defaultValue) {
        return this.bootstrap.getAndStoreBooleanProperty(propertyName, defaultValue);
    }

    @Override
    public void setBooleanProperty(String propertyName, boolean value) {
        this.bootstrap.setBooleanProperty(propertyName, value);
    }

    public Collection<Class<? extends LiteMod>> getModsToLoad() {
        return this.modsToLoad.values();
    }

    public Collection<LoadableMod<?>> getDisabledMods() {
        return this.disabledMods.values();
    }

    public List<Loadable<File>> getInjectedTweaks() {
        return this.injectedTweaks;
    }

    public int modsToLoadCount() {
        return this.modsToLoad.size();
    }

    public boolean hasModsToLoad() {
        return this.modsToLoad.size() > 0;
    }

    public String getModMetaData(Class<? extends LiteMod> modClass, String metaDataKey, String defaultValue) {
        return this.getModContainer(modClass).getMetaValue(metaDataKey, defaultValue);
    }

    public LoadableMod<?> getContainer(String identifier) {
        return this.containers.get(identifier);
    }

    public LoadableMod<?> getModContainer(Class<? extends LiteMod> modClass) {
        return this.modContainers.containsKey(modClass.getSimpleName()) ? this.modContainers.get(modClass.getSimpleName()) : LoadableMod.NONE;
    }

    public String getModIdentifier(Class<? extends LiteMod> modClass) {
        String modClassName = modClass.getSimpleName();
        if (!this.modContainers.containsKey(modClassName)) {
            return LiteLoaderEnumerator.getModClassName(modClass);
        }
        return this.modContainers.get(modClassName).getIdentifier();
    }

    protected void discoverMods() {
        for (EnumeratorModule<?> enumeratorModule : this.modules) {
            enumeratorModule.enumerate(this, this.enabledModsList, this.bootstrap.getProfile());
        }
        for (TweakContainer tweakContainer : this.tweakContainers) {
            this.addTweaksFrom(tweakContainer);
        }
    }

    protected void discoverModClasses() {
        try {
            for (EnumeratorModule<?> module : this.modules) {
                module.injectIntoClassLoader(this, this.classLoader, this.enabledModsList, this.bootstrap.getProfile());
            }
            for (EnumeratorModule<?> module : this.modules) {
                module.registerMods(this, this.classLoader);
            }
            LiteLoaderLogger.info("Mod class discovery completed", new Object[0]);
        }
        catch (Throwable th) {
            LiteLoaderLogger.warning(th, "Mod class discovery failed", new Object[0]);
            return;
        }
    }

    @Override
    public boolean isContainerEnabled(LoadableMod<?> container) {
        if (container != null) {
            if (container.isEnabled(this.enabledModsList, this.bootstrap.getProfile()) && this.checkDependencies(container)) {
                this.containers.put(container.getIdentifier(), container);
            } else {
                this.disabledMods.put(container.getIdentifier(), container);
                return false;
            }
        }
        return true;
    }

    @Override
    public void registerTweakContainer(TweakContainer<File> container) {
        if (!container.isEnabled(this.enabledModsList, this.bootstrap.getProfile())) {
            LiteLoaderLogger.info("Mod %s is disabled for profile %s, not injecting tranformers", container.getIdentifier(), this.bootstrap.getProfile());
            return;
        }
        this.tweakContainers.add(container);
    }

    private void addTweaksFrom(TweakContainer<File> tweakContainer) {
        if (this.checkDependencies(tweakContainer)) {
            if (tweakContainer.hasTweakClass()) {
                this.addTweakFrom(tweakContainer);
            }
            if (tweakContainer.hasClassTransformers()) {
                this.addClassTransformersFrom(tweakContainer, tweakContainer.getClassTransformerClassNames());
            }
        }
    }

    private void addTweakFrom(TweakContainer<File> container) {
        try {
            String tweakClass = container.getTweakClassName();
            int tweakPriority = container.getTweakPriority();
            LiteLoaderLogger.info("Mod file '%s' provides tweakClass '%s', adding to Launch queue with priority %d", container.getName(), tweakClass, tweakPriority);
            if (LiteLoaderTweaker.addCascadedTweaker(tweakClass, tweakPriority)) {
                String[] classPathEntries;
                LiteLoaderLogger.info("tweakClass '%s' was successfully added", tweakClass);
                container.injectIntoClassPath(this.classLoader, true);
                if (container.isExternalJar()) {
                    this.injectedTweaks.add(container);
                }
                if ((classPathEntries = container.getClassPathEntries()) != null) {
                    for (String classPathEntry : classPathEntries) {
                        try {
                            File classPathJar = new File(this.bootstrap.getGameDirectory(), classPathEntry);
                            URL classPathJarUrl = classPathJar.toURI().toURL();
                            LiteLoaderLogger.info("Adding Class-Path entry: %s", classPathEntry);
                            LiteLoaderTweaker.addURLToParentClassLoader(classPathJarUrl);
                            this.classLoader.addURL(classPathJarUrl);
                        }
                        catch (MalformedURLException ex) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    private void addClassTransformersFrom(TweakContainer<File> container, List<String> classTransformerClasses) {
        try {
            for (String classTransformerClass : classTransformerClasses) {
                LiteLoaderLogger.info("Mod file '%s' provides classTransformer '%s', adding to class loader", container.getName(), classTransformerClass);
                if (!LiteLoaderTweaker.getTransformerManager().injectTransformer(classTransformerClass)) continue;
                LiteLoaderLogger.info("classTransformer '%s' was successfully added", classTransformerClass);
                container.injectIntoClassPath(this.classLoader, true);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    @Override
    public void registerModsFrom(LoadableMod<?> container, boolean registerContainer) {
        LinkedList<Class<LiteMod>> modClasses = LiteLoaderEnumerator.getSubclassesFor(container, (ClassLoader)this.classLoader, LiteMod.class, "LiteMod");
        for (Class clazz : modClasses) {
            this.registerMod(clazz, registerContainer ? container : null);
        }
        if (modClasses.size() > 0) {
            LiteLoaderLogger.info("Found %s potential matches", modClasses.size());
        }
    }

    @Override
    public void registerMod(Class<? extends LiteMod> mod, LoadableMod<?> container) {
        if (this.modsToLoad.containsKey(mod.getSimpleName())) {
            LiteLoaderLogger.warning("Mod name collision for mod with class '%s', maybe you have more than one copy?", mod.getSimpleName());
        }
        this.modsToLoad.put(mod.getSimpleName(), mod);
        if (container != null) {
            this.modContainers.put(mod.getSimpleName(), container);
            container.addContainedMod(LiteLoaderEnumerator.getModClassName(mod));
        }
    }

    private static <T> LinkedList<Class<? extends T>> getSubclassesFor(LoadableMod<?> container, ClassLoader classloader, Class<T> superClass, String prefix) {
        LinkedList<Class<T>> classes = new LinkedList<Class<T>>();
        if (container != null) {
            try {
                for (String fullClassName : container.getContainedClassNames()) {
                    String className;
                    boolean isDefaultPackage = fullClassName.lastIndexOf(46) == -1;
                    String string = className = isDefaultPackage ? fullClassName : fullClassName.substring(fullClassName.lastIndexOf(46) + 1);
                    if (prefix != null && !className.startsWith(prefix)) continue;
                    LiteLoaderEnumerator.checkAndAddClass(classloader, superClass, classes, fullClassName);
                }
            }
            catch (OutdatedLoaderException ex) {
                classes.clear();
                LiteLoaderLogger.info("Error searching in '%s', missing API component '%s', your loader is probably out of date", container, ex.getMessage());
            }
            catch (Throwable th) {
                LiteLoaderLogger.warning(th, "Enumeration error", new Object[0]);
            }
        }
        return classes;
    }

    private static <T> void checkAndAddClass(ClassLoader classloader, Class<T> superClass, LinkedList<Class<? extends T>> classes, String className) throws OutdatedLoaderException {
        if (className.indexOf(36) > -1) {
            return;
        }
        try {
            Class<?> subClass = classloader.loadClass(className);
            if (subClass != null && !superClass.equals(subClass) && superClass.isAssignableFrom(subClass) && !subClass.isInterface() && !classes.contains(subClass)) {
                Class<?> matchingClass = subClass;
                classes.add(matchingClass);
            }
        }
        catch (Throwable th) {
            if (th.getCause() != null) {
                String missingClassName = th.getCause().getMessage();
                if (th.getCause() instanceof NoClassDefFoundError && missingClassName != null && missingClassName.startsWith("com/mumfrey/liteloader/")) {
                    throw new OutdatedLoaderException(missingClassName.substring(missingClassName.lastIndexOf(47) + 1));
                }
            }
            LiteLoaderLogger.warning(th, "checkAndAddClass error", new Object[0]);
        }
    }

    @Override
    public boolean checkDependencies(TweakContainer<File> tweakContainer) {
        if (tweakContainer instanceof LoadableMod) {
            return this.checkDependencies((LoadableMod)((Object)tweakContainer));
        }
        return true;
    }

    @Override
    public boolean checkDependencies(LoadableMod<?> base) {
        if (base == null || !base.hasDependencies()) {
            return true;
        }
        HashSet<String> circularDependencySet = new HashSet<String>();
        circularDependencySet.add(base.getIdentifier());
        boolean result = this.checkDependencies(base, base, circularDependencySet);
        LiteLoaderLogger.info("Dependency check for %s %s", base.getIdentifier(), result ? "passed" : "failed");
        return result;
    }

    private boolean checkDependencies(LoadableMod<?> base, LoadableMod<?> container, Set<String> circularDependencySet) {
        if (container.getDependencies().size() == 0) {
            return true;
        }
        boolean result = true;
        for (String dependency : container.getDependencies()) {
            if (circularDependencySet.contains(dependency)) continue;
            circularDependencySet.add(dependency);
            LoadableMod<?> dependencyContainer = this.getContainer(dependency);
            if (dependencyContainer != null) {
                if (this.enabledModsList.isEnabled(this.bootstrap.getProfile(), dependency)) {
                    result &= this.checkDependencies(base, dependencyContainer, circularDependencySet);
                    continue;
                }
                base.registerMissingDependency(dependency);
                result = false;
                continue;
            }
            base.registerMissingDependency(dependency);
            result = false;
        }
        return result;
    }

    public static String getModClassName(LiteMod mod) {
        return LiteLoaderEnumerator.getModClassName(mod.getClass());
    }

    public static String getModClassName(Class<? extends LiteMod> mod) {
        return mod.getSimpleName().substring(7);
    }
}

