/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.core;

import com.mumfrey.liteloader.core.EnabledModsList;
import com.mumfrey.liteloader.core.LiteLoader;
import com.mumfrey.liteloader.core.LiteLoaderEnumerator;
import com.mumfrey.liteloader.core.LiteLoaderVersion;
import com.mumfrey.liteloader.launch.ILoaderBootstrap;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Properties;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.layout.PatternLayout;

class LiteLoaderBootstrap
implements ILoaderBootstrap {
    public static final LiteLoaderVersion VERSION = LiteLoaderVersion.CURRENT;
    private final File gameDirectory;
    private final File assetsDirectory;
    private final String profile;
    private final File modsFolder;
    private final File versionedModsFolder;
    private final File configBaseFolder;
    private File logFile;
    private File propertiesFile;
    private File enabledModsFile;
    private Properties internalProperties = new Properties();
    private Properties localProperties = new Properties();
    private String branding = null;
    private LiteLoaderEnumerator enumerator;
    private EnabledModsList enabledModsList;

    public LiteLoaderBootstrap(File gameDirectory, File assetsDirectory, String profile) {
        this.gameDirectory = gameDirectory;
        this.assetsDirectory = assetsDirectory;
        this.profile = profile;
        this.modsFolder = new File(this.gameDirectory, "mods");
        this.versionedModsFolder = new File(this.modsFolder, LiteLoaderVersion.CURRENT.getMinecraftVersion());
        this.configBaseFolder = new File(this.gameDirectory, "liteconfig");
        this.logFile = new File(this.configBaseFolder, "liteloader.log");
        this.propertiesFile = new File(this.configBaseFolder, "liteloader.properties");
        this.enabledModsFile = new File(this.configBaseFolder, "liteloader.profiles.json");
        if (!this.modsFolder.exists()) {
            this.modsFolder.mkdirs();
        }
        if (!this.versionedModsFolder.exists()) {
            this.versionedModsFolder.mkdirs();
        }
        if (!this.configBaseFolder.exists()) {
            this.configBaseFolder.mkdirs();
        }
    }

    @Override
    public void preInit(LaunchClassLoader classLoader, boolean loadTweaks, List<String> modsToLoad) {
        LiteLoaderLogger.info("LiteLoader begin PREINIT...", new Object[0]);
        if (!this.prepare()) {
            return;
        }
        LiteLoaderLogger.info("LiteLoader %s starting up...", LiteLoaderVersion.CURRENT.getLoaderVersion());
        if (this.branding != null) {
            LiteLoaderLogger.info("Active Pack: %s", this.branding);
        }
        LiteLoaderLogger.info("Java reports OS=\"%s\"", System.getProperty("os.name").toLowerCase());
        this.enabledModsList = EnabledModsList.createFrom(this.enabledModsFile);
        this.enabledModsList.processModsList(this.profile, modsToLoad);
        this.enumerator = new LiteLoaderEnumerator(this, classLoader, this.enabledModsList, loadTweaks);
        this.enumerator.discoverMods();
        LiteLoaderLogger.info("LiteLoader PREINIT complete", new Object[0]);
    }

    @Override
    public void init(LaunchClassLoader classLoader) {
        if (this.enumerator == null) {
            return;
        }
        LiteLoaderLogger.info("LiteLoader begin INIT...", new Object[0]);
        LiteLoader.init(this, this.enumerator, this.enabledModsList, classLoader);
    }

    @Override
    public void postInit() {
        if (this.enumerator == null) {
            return;
        }
        LiteLoaderLogger.info("LiteLoader begin POSTINIT...", new Object[0]);
        LiteLoader.getInstance().postInit();
    }

    private boolean prepare() {
        try {
            this.prepareProperties();
            this.prepareLogger();
            this.branding = this.internalProperties.getProperty("brand", null);
            if (this.branding != null && this.branding.length() < 1) {
                this.branding = null;
            }
            if (this.branding != null) {
                this.localProperties.setProperty("brand", this.branding);
            } else {
                this.localProperties.remove("brand");
            }
        }
        catch (Throwable th) {
            LiteLoaderLogger.severe(th, "Error initialising LiteLoader Bootstrap", new Object[0]);
            return false;
        }
        return true;
    }

    private void prepareLogger() throws SecurityException, IOException {
        Logger logger = LiteLoaderLogger.getLogger();
        PatternLayout layout = PatternLayout.createLayout((String)"[%d{HH:mm:ss}] [%t/%level]: %msg%n", (Configuration)logger.getContext().getConfiguration(), null, (String)"UTF-8", (String)"True");
        FileAppender fileAppender = FileAppender.createAppender((String)this.logFile.getAbsolutePath(), (String)"False", (String)"False", (String)"LiteLoader", (String)"True", (String)"True", (String)"True", (Layout)layout, null, (String)"False", (String)"", (Configuration)logger.getContext().getConfiguration());
        fileAppender.start();
        logger.addAppender((Appender)fileAppender);
    }

    private void prepareProperties() {
        try {
            InputStream propertiesStream = LiteLoaderBootstrap.class.getResourceAsStream("/liteloader.properties");
            if (propertiesStream != null) {
                this.internalProperties.load(propertiesStream);
                propertiesStream.close();
            }
        }
        catch (Throwable th) {
            this.internalProperties = new Properties();
        }
        try {
            this.localProperties = new Properties(this.internalProperties);
            InputStream localPropertiesStream = this.getLocalPropertiesStream();
            if (localPropertiesStream != null) {
                this.localProperties.load(localPropertiesStream);
                localPropertiesStream.close();
            }
        }
        catch (Throwable th) {
            this.localProperties = new Properties(this.internalProperties);
        }
    }

    private InputStream getLocalPropertiesStream() throws FileNotFoundException {
        if (this.propertiesFile.exists()) {
            return new FileInputStream(this.propertiesFile);
        }
        return LiteLoaderBootstrap.class.getResourceAsStream("/liteloader.properties");
    }

    public void writeProperties() {
        try {
            this.localProperties.store(new FileWriter(this.propertiesFile), String.format("Properties for LiteLoader %s", new Object[]{LiteLoaderVersion.CURRENT}));
        }
        catch (Throwable th) {
            LiteLoaderLogger.warning(th, "Error writing liteloader properties", new Object[0]);
        }
    }

    public File getGameDirectory() {
        return this.gameDirectory;
    }

    public File getAssetsDirectory() {
        return this.assetsDirectory;
    }

    public String getProfile() {
        return this.profile;
    }

    public File getModsFolder() {
        return this.modsFolder;
    }

    public File getVersionedModsFolder() {
        return this.versionedModsFolder;
    }

    public File getConfigBaseFolder() {
        return this.configBaseFolder;
    }

    @Override
    public boolean getAndStoreBooleanProperty(String propertyName, boolean defaultValue) {
        boolean result = this.localProperties.getProperty(propertyName, String.valueOf(defaultValue)).equalsIgnoreCase("true");
        this.localProperties.setProperty(propertyName, String.valueOf(result));
        return result;
    }

    @Override
    public boolean getBooleanProperty(String propertyName) {
        return this.localProperties.getProperty(propertyName, "false").equalsIgnoreCase("true");
    }

    @Override
    public void setBooleanProperty(String propertyName, boolean value) {
        this.localProperties.setProperty(propertyName, String.valueOf(value));
    }

    public void storeLastKnownModRevision(String modKey) {
        if (this.localProperties != null) {
            this.localProperties.setProperty(modKey, String.valueOf(LiteLoaderVersion.CURRENT.getLoaderRevision()));
            this.writeProperties();
        }
    }

    public int getLastKnownModRevision(String modKey) {
        if (this.localProperties != null) {
            String storedRevision = this.localProperties.getProperty(modKey, "0");
            return Integer.parseInt(storedRevision);
        }
        return 0;
    }

    public String getBranding() {
        return this.branding;
    }

    static void setBranding(String brand) {
        try {
            String oldBrand = ClientBrandRetriever.getClientModName();
            if (oldBrand.equals("vanilla")) {
                char[] newValue = brand.toCharArray();
                Field stringValue = String.class.getDeclaredField("value");
                stringValue.setAccessible(true);
                stringValue.set(oldBrand, newValue);
                try {
                    Field stringCount = String.class.getDeclaredField("count");
                    stringCount.setAccessible(true);
                    stringCount.set(oldBrand, newValue.length);
                }
                catch (NoSuchFieldException ex) {}
            }
        }
        catch (Throwable th) {
            LiteLoaderLogger.warning(th, "Setting branding failed", new Object[0]);
        }
    }
}

