/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.core;

import com.mumfrey.liteloader.LiteMod;
import com.mumfrey.liteloader.core.ClientPluginChannels;
import com.mumfrey.liteloader.core.EnabledModsList;
import com.mumfrey.liteloader.core.Events;
import com.mumfrey.liteloader.core.LiteLoaderBootstrap;
import com.mumfrey.liteloader.core.LiteLoaderEnumerator;
import com.mumfrey.liteloader.core.LiteLoaderVersion;
import com.mumfrey.liteloader.core.Loadable;
import com.mumfrey.liteloader.core.LoadableMod;
import com.mumfrey.liteloader.core.ServerPluginChannels;
import com.mumfrey.liteloader.core.SoundHandlerReloadInhibitor;
import com.mumfrey.liteloader.core.overlays.IMinecraft;
import com.mumfrey.liteloader.crashreport.CallableLaunchWrapper;
import com.mumfrey.liteloader.crashreport.CallableLiteLoaderBrand;
import com.mumfrey.liteloader.crashreport.CallableLiteLoaderMods;
import com.mumfrey.liteloader.gui.GuiScreenModInfo;
import com.mumfrey.liteloader.modconfig.ConfigManager;
import com.mumfrey.liteloader.modconfig.Exposable;
import com.mumfrey.liteloader.permissions.PermissionsManagerClient;
import com.mumfrey.liteloader.resources.InternalResourcePack;
import com.mumfrey.liteloader.util.Input;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import java.io.File;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.activity.InvalidActivityException;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.apache.logging.log4j.Logger;
import org.lwjgl.input.Keyboard;

public final class LiteLoader {
    public static final String MOD_SYSTEM = "liteloader";
    private static final String OPTION_MOD_INFO_SCREEN = "modInfoScreen";
    private static final String OPTION_SOUND_MANAGER_FIX = "soundManagerFix";
    private static final String OPTION_GENERATE_MAPPINGS = "genMappings";
    private static LiteLoader instance;
    private static final Logger logger;
    private static LaunchClassLoader classLoader;
    private File modsFolder;
    private File configBaseFolder;
    private File commonConfigFolder;
    private File versionConfigFolder;
    private azd minecraft;
    private final LiteLoaderBootstrap bootstrap;
    private final LiteLoaderEnumerator enumerator;
    private final EnabledModsList enabledModsList;
    private final Map<String, bqr> registeredResourcePacks = new HashMap<String, bqr>();
    private String loadedModsList = "none";
    private final LinkedList<LiteMod> mods = new LinkedList();
    private final LinkedList<LiteMod> loadedMods = new LinkedList();
    private final LinkedList<Loadable<?>> disabledMods = new LinkedList();
    private Events events;
    private final ClientPluginChannels clientPluginChannels = new ClientPluginChannels();
    private final ServerPluginChannels serverPluginChannels = new ServerPluginChannels();
    private final PermissionsManagerClient permissionsManager = PermissionsManagerClient.getInstance();
    private final ConfigManager configManager;
    private boolean startupComplete;
    private boolean pendingResourceReload;
    private boolean inhibitSoundManagerReload = true;
    private SoundHandlerReloadInhibitor soundHandlerReloadInhibitor;
    private Input input;
    private boolean displayModInfoScreenTab = true;
    private boolean hideModInfoScreenTab = false;
    private GuiScreenModInfo modInfoScreen;

    private LiteLoader(LiteLoaderBootstrap bootstrap, LiteLoaderEnumerator enumerator, EnabledModsList enabledModsList) {
        this.bootstrap = bootstrap;
        this.enumerator = enumerator;
        this.enabledModsList = enabledModsList;
        this.setupPaths(bootstrap);
        this.configManager = new ConfigManager();
        this.input = new Input(new File(this.commonConfigFolder, "liteloader.keys.properties"));
    }

    private void setupPaths(LiteLoaderBootstrap bootstrap) {
        this.modsFolder = bootstrap.getModsFolder();
        this.configBaseFolder = bootstrap.getConfigBaseFolder();
        this.commonConfigFolder = new File(this.configBaseFolder, "common");
        this.versionConfigFolder = this.inflectVersionedConfigPath(LiteLoaderVersion.CURRENT);
        if (!this.modsFolder.exists()) {
            this.modsFolder.mkdirs();
        }
        if (!this.configBaseFolder.exists()) {
            this.configBaseFolder.mkdirs();
        }
        if (!this.commonConfigFolder.exists()) {
            this.commonConfigFolder.mkdirs();
        }
        if (!this.versionConfigFolder.exists()) {
            this.versionConfigFolder.mkdirs();
        }
    }

    private File inflectVersionedConfigPath(LiteLoaderVersion version) {
        if (version.equals((Object)LiteLoaderVersion.LEGACY)) {
            return this.modsFolder;
        }
        return new File(this.configBaseFolder, String.format("config.%s", version.getMinecraftVersion()));
    }

    void init() {
        try {
            this.input.init();
            this.inhibitSoundManagerReload = this.bootstrap.getAndStoreBooleanProperty(OPTION_SOUND_MANAGER_FIX, true);
            this.displayModInfoScreenTab = this.bootstrap.getAndStoreBooleanProperty(OPTION_MOD_INFO_SCREEN, true);
            this.enumerator.discoverModClasses();
            this.disabledMods.addAll(this.enumerator.getDisabledMods());
        }
        catch (Throwable th) {
            LiteLoaderLogger.severe("Error initialising LiteLoader", th);
        }
    }

    void postInit() {
        this.minecraft = azd.A();
        this.registerModResourcePack(new InternalResourcePack("LiteLoader", LiteLoader.class, MOD_SYSTEM));
        this.events = new Events(this, this.minecraft, this.clientPluginChannels, this.serverPluginChannels, this.bootstrap.getBooleanProperty(OPTION_GENERATE_MAPPINGS));
        this.loadMods();
        this.initMods();
        this.updateSharedModList();
        this.events.initHooks();
        this.startupComplete = true;
        this.enabledModsList.save();
        this.bootstrap.writeProperties();
    }

    public boolean registerModResourcePack(bqr resourcePack) {
        if (!this.registeredResourcePacks.containsKey(resourcePack.b())) {
            this.pendingResourceReload = true;
            List<bqr> defaultResourcePacks = ((IMinecraft)this.minecraft).getDefaultResourcePacks();
            if (!defaultResourcePacks.contains(resourcePack)) {
                defaultResourcePacks.add(resourcePack);
                this.registeredResourcePacks.put(resourcePack.b(), resourcePack);
                return true;
            }
        }
        return false;
    }

    public boolean unRegisterModResourcePack(bqr resourcePack) {
        if (this.registeredResourcePacks.containsValue(resourcePack)) {
            this.pendingResourceReload = true;
            List<bqr> defaultResourcePacks = ((IMinecraft)this.minecraft).getDefaultResourcePacks();
            this.registeredResourcePacks.remove(resourcePack.b());
            defaultResourcePacks.remove(resourcePack);
            return true;
        }
        return false;
    }

    public static final LiteLoader getInstance() {
        return instance;
    }

    @Deprecated
    public static final Logger getLogger() {
        return logger;
    }

    public static LaunchClassLoader getClassLoader() {
        return classLoader;
    }

    @Deprecated
    public static final PrintStream getConsoleStream() {
        return System.err;
    }

    public static final String getVersion() {
        return LiteLoaderVersion.CURRENT.getLoaderVersion();
    }

    public static final String getVersionDisplayString() {
        return String.format("LiteLoader %s", LiteLoaderVersion.CURRENT.getLoaderVersion());
    }

    public static final int getRevision() {
        return LiteLoaderVersion.CURRENT.getLoaderRevision();
    }

    public static PermissionsManagerClient getPermissionsManager() {
        return LiteLoader.getInstance().permissionsManager;
    }

    public static Events getEvents() {
        return LiteLoader.getInstance().events;
    }

    @Deprecated
    public static ClientPluginChannels getPluginChannels() {
        return LiteLoader.getInstance().clientPluginChannels;
    }

    public static ClientPluginChannels getClientPluginChannels() {
        return LiteLoader.getInstance().clientPluginChannels;
    }

    public static ServerPluginChannels getServerPluginChannels() {
        return LiteLoader.getInstance().serverPluginChannels;
    }

    public static Input getInput() {
        return LiteLoader.getInstance().input;
    }

    public static File getModsFolder() {
        return LiteLoader.getInstance().modsFolder;
    }

    public static File getCommonConfigFolder() {
        return LiteLoader.getInstance().commonConfigFolder;
    }

    public static File getConfigFolder() {
        return LiteLoader.getInstance().versionConfigFolder;
    }

    public static File getGameDirectory() {
        return LiteLoader.getInstance().bootstrap.getGameDirectory();
    }

    public static File getAssetsDirectory() {
        return LiteLoader.getInstance().bootstrap.getAssetsDirectory();
    }

    public static String getProfile() {
        return LiteLoader.getInstance().bootstrap.getProfile();
    }

    public static String getBranding() {
        return LiteLoader.getInstance().bootstrap.getBranding();
    }

    public static boolean isDevelopmentEnvironment() {
        return "true".equals(System.getProperty("mcpenv"));
    }

    public String getLoadedModsList() {
        return this.loadedModsList;
    }

    public List<LiteMod> getLoadedMods() {
        return Collections.unmodifiableList(this.loadedMods);
    }

    public List<Loadable<?>> getDisabledMods() {
        return Collections.unmodifiableList(this.disabledMods);
    }

    public Collection<Loadable<File>> getInjectedTweaks() {
        return Collections.unmodifiableCollection(this.enumerator.getInjectedTweaks());
    }

    public <T extends LiteMod> T getMod(String modName) throws InvalidActivityException, IllegalArgumentException {
        if (!this.startupComplete) {
            throw new InvalidActivityException("Attempted to get a reference to a mod before loader startup is complete");
        }
        if (modName == null) {
            throw new IllegalArgumentException("Attempted to get a reference to a mod without specifying a mod name");
        }
        for (LiteMod mod : this.mods) {
            Class<?> modClass = mod.getClass();
            String modId = this.getModIdentifier(modClass);
            if (!modName.equalsIgnoreCase(mod.getName()) && !modName.equalsIgnoreCase(modId) && !modName.equalsIgnoreCase(modClass.getSimpleName())) continue;
            return (T)mod;
        }
        return null;
    }

    public <T extends LiteMod> T getMod(Class<T> modClass) {
        if (!this.startupComplete) {
            throw new RuntimeException("Attempted to get a reference to a mod before loader startup is complete");
        }
        for (LiteMod mod : this.mods) {
            if (!mod.getClass().equals(modClass)) continue;
            return (T)mod;
        }
        return null;
    }

    public boolean isModInstalled(String modName) {
        if (!this.startupComplete || modName == null) {
            return false;
        }
        for (LiteMod mod : this.mods) {
            if (!modName.equalsIgnoreCase(mod.getName()) && !modName.equalsIgnoreCase(mod.getClass().getSimpleName())) continue;
            return true;
        }
        return true;
    }

    public String getModMetaData(String modNameOrId, String metaDataKey, String defaultValue) throws InvalidActivityException, IllegalArgumentException {
        return this.getModMetaData((LiteMod)this.getMod(modNameOrId), metaDataKey, defaultValue);
    }

    public String getModMetaData(LiteMod mod, String metaDataKey, String defaultValue) {
        if (mod == null || metaDataKey == null) {
            return defaultValue;
        }
        return this.enumerator.getModMetaData(mod.getClass(), metaDataKey, defaultValue);
    }

    public String getModMetaData(Class<? extends LiteMod> modClass, String metaDataKey, String defaultValue) {
        if (modClass == null || metaDataKey == null) {
            return defaultValue;
        }
        return this.enumerator.getModMetaData(modClass, metaDataKey, defaultValue);
    }

    public String getModIdentifier(Class<? extends LiteMod> modClass) {
        return this.enumerator.getModIdentifier(modClass);
    }

    public String getModIdentifier(LiteMod mod) {
        return mod == null ? null : this.enumerator.getModIdentifier(mod.getClass());
    }

    public LoadableMod<?> getModContainer(Class<? extends LiteMod> modClass) {
        return this.enumerator.getModContainer(modClass);
    }

    public LoadableMod<?> getModContainer(LiteMod mod) {
        return mod == null ? null : this.enumerator.getModContainer(mod.getClass());
    }

    public Class<? extends LiteMod> getModFromIdentifier(String identifier) {
        if (identifier == null) {
            return null;
        }
        for (LiteMod mod : this.mods) {
            if (!identifier.equalsIgnoreCase(this.enumerator.getModIdentifier(mod.getClass()))) continue;
            return mod.getClass();
        }
        return null;
    }

    public void enableMod(String identifier) {
        this.setModEnabled(identifier, true);
    }

    public void disableMod(String identifier) {
        this.setModEnabled(identifier, false);
    }

    public void setModEnabled(String identifier, boolean enabled) {
        this.enabledModsList.setEnabled(this.bootstrap.getProfile(), identifier, enabled);
        this.enabledModsList.save();
    }

    public boolean isModEnabled(String modName) {
        return this.enabledModsList.isEnabled(LiteLoader.getProfile(), modName);
    }

    public boolean isModActive(String modName) {
        if (modName == null) {
            return false;
        }
        for (LiteMod mod : this.loadedMods) {
            if (!modName.equalsIgnoreCase(this.enumerator.getModIdentifier(mod.getClass()))) continue;
            return true;
        }
        return false;
    }

    public void writeConfig(Exposable exposable) {
        this.configManager.invalidateConfig(exposable);
    }

    public void registerExposable(Exposable exposable, String fileName) {
        this.configManager.registerExposable(exposable, fileName, true);
        this.configManager.initConfig(exposable);
    }

    private void loadMods() {
        if (!this.enumerator.hasModsToLoad()) {
            LiteLoaderLogger.info("Mod class discovery failed or no mod classes were found. Not loading any mods.", new Object[0]);
            return;
        }
        LiteLoaderLogger.info("Discovered %d total mod(s)", this.enumerator.modsToLoadCount());
        this.pendingResourceReload = false;
        this.soundHandlerReloadInhibitor = new SoundHandlerReloadInhibitor((bqx)this.minecraft.O(), this.minecraft.V());
        if (this.inhibitSoundManagerReload) {
            this.soundHandlerReloadInhibitor.inhibit();
        }
        for (Class<? extends LiteMod> mod : this.enumerator.getModsToLoad()) {
            LoadableMod<?> container = this.enumerator.getModContainer(mod);
            try {
                String identifier = this.getModIdentifier(mod);
                if (identifier == null || this.enabledModsList.isEnabled(this.bootstrap.getProfile(), identifier)) {
                    if (this.enumerator.checkDependencies(container)) {
                        this.loadMod(identifier, mod, container);
                        continue;
                    }
                    LiteLoaderLogger.info("Not loading mod %s, the mod was missing a required dependency", identifier);
                    if (container == LoadableMod.NONE || this.disabledMods.contains(container)) continue;
                    this.disabledMods.add(container);
                    continue;
                }
                LiteLoaderLogger.info("Not loading mod %s, excluded by filter", identifier);
                if (container == LoadableMod.NONE || this.disabledMods.contains(container)) continue;
                this.disabledMods.add(container);
            }
            catch (Throwable th) {
                th.printStackTrace();
                LiteLoaderLogger.warning(th, "Error loading mod from %s", mod.getName());
                if (container == LoadableMod.NONE || this.disabledMods.contains(container)) continue;
                this.disabledMods.add(container);
            }
        }
    }

    protected void loadMod(String identifier, Class<? extends LiteMod> mod, LoadableMod<?> container) throws InstantiationException, IllegalAccessException {
        LiteLoaderLogger.info("Loading mod from %s", mod.getName());
        LiteMod newMod = mod.newInstance();
        this.mods.add(newMod);
        String modName = newMod.getName();
        if (modName == null && identifier != null) {
            modName = identifier;
        }
        LiteLoaderLogger.info("Successfully added mod %s version %s", modName, newMod.getVersion());
        if (container != null) {
            LiteLoaderLogger.info("Adding \"%s\" to active resource pack set", container.getLocation());
            if (modName != null) {
                container.initResourcePack(modName);
                if (container.hasResourcePack() && this.registerModResourcePack((bqr)container.getResourcePack())) {
                    LiteLoaderLogger.info("Successfully added \"%s\" to active resource pack set", container.getLocation());
                }
            }
        }
    }

    private void initMods() {
        this.loadedModsList = "";
        int loadedModsCount = 0;
        Iterator iter = this.mods.iterator();
        while (iter.hasNext()) {
            LiteMod mod = (LiteMod)iter.next();
            try {
                this.initMod(mod);
                ++loadedModsCount;
            }
            catch (Throwable th) {
                LiteLoaderLogger.warning(th, "Error initialising mod '%s'", mod.getName());
                iter.remove();
            }
        }
        this.loadedModsList = String.format("%s loaded mod(s)%s", loadedModsCount, this.loadedModsList);
    }

    protected void initMod(LiteMod mod) {
        LiteLoaderLogger.info("Initialising mod %s version %s", mod.getName(), mod.getVersion());
        this.configManager.registerMod(mod);
        try {
            this.handleModVersionUpgrade(mod);
        }
        catch (Throwable th) {
            LiteLoaderLogger.warning("Error performing settings upgrade for %s. Settings may not be properly migrated", mod.getName());
        }
        this.configManager.initConfig(mod);
        mod.init(this.commonConfigFolder);
        this.events.addListener(mod);
        this.permissionsManager.registerMod(mod);
        this.loadedMods.add(mod);
        this.loadedModsList = this.loadedModsList + String.format("\n          - %s version %s", mod.getName(), mod.getVersion());
    }

    protected void handleModVersionUpgrade(LiteMod mod) {
        String modKey = this.getModNameForConfig(mod.getClass(), mod.getName());
        LiteLoaderVersion lastModVersion = LiteLoaderVersion.getVersionFromRevision(this.bootstrap.getLastKnownModRevision(modKey));
        if (LiteLoaderVersion.CURRENT.getLoaderRevision() > lastModVersion.getLoaderRevision()) {
            LiteLoaderLogger.info("Performing config upgrade for mod %s. Upgrading %s to %s...", new Object[]{mod.getName(), lastModVersion, LiteLoaderVersion.CURRENT});
            this.configManager.migrateModConfig(mod, this.versionConfigFolder, this.inflectVersionedConfigPath(lastModVersion));
            mod.upgradeSettings(LiteLoaderVersion.CURRENT.getMinecraftVersion(), this.versionConfigFolder, this.inflectVersionedConfigPath(lastModVersion));
            this.bootstrap.storeLastKnownModRevision(modKey);
            LiteLoaderLogger.info("Config upgrade succeeded for mod %s", mod.getName());
        }
    }

    private String getModNameForConfig(Class<? extends LiteMod> modClass, String modName) {
        if (modName == null || modName.isEmpty()) {
            modName = modClass.getSimpleName().toLowerCase();
        }
        return String.format("version.%s", modName.toLowerCase().replaceAll("[^a-z0-9_\\-\\.]", ""));
    }

    void preInitMods() {
        if (this.pendingResourceReload) {
            this.pendingResourceReload = false;
            this.minecraft.b();
        }
    }

    void preBeginGame() {
        LiteLoaderBootstrap.setBranding("LiteLoader");
        if (this.soundHandlerReloadInhibitor != null && this.soundHandlerReloadInhibitor.isInhibited()) {
            this.soundHandlerReloadInhibitor.unInhibit(true);
        }
    }

    void onJoinGame(es netHandler, gu loginPacket) {
        this.permissionsManager.onJoinGame(netHandler, loginPacket);
    }

    void onWorldChanged(afn world) {
        if (world != null) {
            this.permissionsManager.scheduleRefresh();
        }
    }

    void postRender(int mouseX, int mouseY, float partialTicks) {
        boolean tabHidden;
        boolean bl = tabHidden = this.hideModInfoScreenTab && this.minecraft.n instanceof btj;
        if (GuiScreenModInfo.isSupportedOnScreen(this.minecraft.n) && (this.displayModInfoScreenTab && !tabHidden || this.modInfoScreen != null && this.modInfoScreen.isTweeningOrOpen())) {
            if (this.modInfoScreen == null || this.modInfoScreen.getScreen() != this.minecraft.n) {
                this.modInfoScreen = new GuiScreenModInfo(this.minecraft, this.minecraft.n, this, this.enabledModsList, this.configManager, tabHidden);
            }
            this.minecraft.p.g();
            this.modInfoScreen.a(mouseX, mouseY, partialTicks);
        } else if (this.minecraft.n != this.modInfoScreen && this.modInfoScreen != null) {
            this.modInfoScreen.release();
            this.modInfoScreen = null;
        } else if (GuiScreenModInfo.isSupportedOnScreen(this.minecraft.n) && Keyboard.isKeyDown((int)29) && Keyboard.isKeyDown((int)42) && Keyboard.isKeyDown((int)15)) {
            this.displayModInfoScreen(this.minecraft.n);
        }
    }

    void onTick(boolean clock, float partialTicks, boolean inGame) {
        if (clock) {
            this.minecraft.A.a("permissionsmanager");
            this.permissionsManager.onTick(this.minecraft, partialTicks, inGame);
            this.minecraft.A.c("configmanager");
            this.configManager.onTick();
            if (this.modInfoScreen != null && this.minecraft.n != this.modInfoScreen) {
                this.modInfoScreen.c();
            }
            if (!((IMinecraft)this.minecraft).isRunning()) {
                this.onShutDown();
            }
            this.minecraft.A.b();
        }
        this.minecraft.A.a("keybindings");
        this.input.onTick(clock);
        this.minecraft.A.b();
    }

    private void onShutDown() {
        LiteLoaderLogger.info("LiteLoader is shutting down, syncing configuration", new Object[0]);
        this.input.storeBindings();
        this.configManager.syncConfig();
    }

    @Deprecated
    public void registerModKey(aza binding) {
        this.input.registerKeyBinding(binding);
    }

    public void hideModInfoScreenTab() {
        this.hideModInfoScreenTab = true;
    }

    public void setDisplayModInfoScreenTab(boolean show) {
        this.displayModInfoScreenTab = show;
        this.bootstrap.setBooleanProperty(OPTION_MOD_INFO_SCREEN, show);
        this.bootstrap.writeProperties();
    }

    public boolean getDisplayModInfoScreenTab() {
        return this.displayModInfoScreenTab;
    }

    public void displayModInfoScreen(bcd parentScreen) {
        if (GuiScreenModInfo.isSupportedOnScreen(parentScreen)) {
            this.modInfoScreen = new GuiScreenModInfo(this.minecraft, parentScreen, this, this.enabledModsList, this.configManager, this.hideModInfoScreenTab);
            this.minecraft.a((bcd)this.modInfoScreen);
        }
    }

    public static void populateCrashReport(Object objCrashReport) {
        if (objCrashReport instanceof b) {
            b crashReport = (b)objCrashReport;
            crashReport.g().a("Mod Pack", (Callable)new CallableLiteLoaderBrand(crashReport));
            crashReport.g().a("LiteLoader Mods", (Callable)new CallableLiteLoaderMods(crashReport));
            crashReport.g().a("LaunchWrapper", (Callable)new CallableLaunchWrapper(crashReport));
        }
    }

    static final void init(LiteLoaderBootstrap bootstrap, LiteLoaderEnumerator enumerator, EnabledModsList enabledModsList, LaunchClassLoader classLoader) {
        if (instance == null) {
            LiteLoader.classLoader = classLoader;
            instance = new LiteLoader(bootstrap, enumerator, enabledModsList);
            instance.init();
        }
    }

    private void updateSharedModList() {
        Map<String, Map<String, String>> modList = this.enumerator.getSharedModList();
        if (modList == null) {
            return;
        }
        for (LiteMod mod : this.mods) {
            String modKey = String.format("%s:%s", MOD_SYSTEM, this.getModIdentifier(mod));
            modList.put(modKey, this.packModInfoToMap(mod));
        }
    }

    private Map<String, String> packModInfoToMap(LiteMod mod) {
        HashMap<String, String> modInfo = new HashMap<String, String>();
        LoadableMod<?> container = this.getModContainer(mod);
        modInfo.put("modsystem", MOD_SYSTEM);
        modInfo.put("id", this.getModIdentifier(mod));
        modInfo.put("version", mod.getVersion());
        modInfo.put("name", mod.getName());
        modInfo.put("url", container.getMetaValue("url", ""));
        modInfo.put("authors", container.getAuthor());
        modInfo.put("description", container.getDescription(LiteLoaderEnumerator.getModClassName(mod)));
        return modInfo;
    }

    static {
        logger = LiteLoaderLogger.getLogger();
    }
}

