/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.core;

import com.mojang.authlib.GameProfile;
import com.mumfrey.liteloader.ChatFilter;
import com.mumfrey.liteloader.ChatListener;
import com.mumfrey.liteloader.ChatRenderListener;
import com.mumfrey.liteloader.GameLoopListener;
import com.mumfrey.liteloader.HUDRenderListener;
import com.mumfrey.liteloader.InitCompleteListener;
import com.mumfrey.liteloader.JoinGameListener;
import com.mumfrey.liteloader.LiteMod;
import com.mumfrey.liteloader.OutboundChatListener;
import com.mumfrey.liteloader.PluginChannelListener;
import com.mumfrey.liteloader.PostLoginListener;
import com.mumfrey.liteloader.PostRenderListener;
import com.mumfrey.liteloader.PreJoinGameListener;
import com.mumfrey.liteloader.RenderListener;
import com.mumfrey.liteloader.ServerChatFilter;
import com.mumfrey.liteloader.ServerCommandProvider;
import com.mumfrey.liteloader.ServerPlayerListener;
import com.mumfrey.liteloader.ServerPluginChannelListener;
import com.mumfrey.liteloader.Tickable;
import com.mumfrey.liteloader.core.ClientPluginChannels;
import com.mumfrey.liteloader.core.CommonPluginChannelListener;
import com.mumfrey.liteloader.core.LiteLoader;
import com.mumfrey.liteloader.core.ServerPluginChannels;
import com.mumfrey.liteloader.core.gen.GenProfiler;
import com.mumfrey.liteloader.core.overlays.IMinecraft;
import com.mumfrey.liteloader.util.PrivateFields;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import java.util.LinkedList;
import org.lwjgl.input.Mouse;

public class Events {
    private final LiteLoader loader;
    private final azd minecraft;
    private final ClientPluginChannels clientPluginChannels;
    private final ServerPluginChannels serverPluginChannels;
    private bae minecraftTimer;
    private boolean hookInitDone;
    private boolean lateInitDone;
    private boolean profilerHooked;
    private ov genProfiler = null;
    private bam currentResolution;
    private int screenWidth = 854;
    private int screenHeight = 480;
    private LinkedList<Tickable> tickListeners = new LinkedList();
    private LinkedList<GameLoopListener> loopListeners = new LinkedList();
    private LinkedList<InitCompleteListener> initListeners = new LinkedList();
    private LinkedList<RenderListener> renderListeners = new LinkedList();
    private LinkedList<PostRenderListener> postRenderListeners = new LinkedList();
    private LinkedList<HUDRenderListener> hudRenderListeners = new LinkedList();
    private LinkedList<ChatRenderListener> chatRenderListeners = new LinkedList();
    private LinkedList<ChatListener> chatListeners = new LinkedList();
    private LinkedList<ChatFilter> chatFilters = new LinkedList();
    private LinkedList<PostLoginListener> postLoginListeners = new LinkedList();
    private LinkedList<JoinGameListener> joinGameListeners = new LinkedList();
    private LinkedList<PreJoinGameListener> preJoinGameListeners = new LinkedList();
    private LinkedList<ServerChatFilter> serverChatFilters = new LinkedList();
    private LinkedList<ServerCommandProvider> serverCommandProviders = new LinkedList();
    private LinkedList<ServerPlayerListener> serverPlayerListeners = new LinkedList();
    private LinkedList<OutboundChatListener> outboundChatListeners = new LinkedList();
    private int worldHashCode = 0;

    Events(LiteLoader loader, azd minecraft, ClientPluginChannels pluginChannels, ServerPluginChannels serverPluginChannels, boolean genMappings) {
        this.loader = loader;
        this.minecraft = minecraft;
        this.clientPluginChannels = pluginChannels;
        this.serverPluginChannels = serverPluginChannels;
        try {
            if (genMappings) {
                this.genProfiler = (ov)GenProfiler.class.newInstance();
            }
        }
        catch (Throwable th) {
            // empty catch block
        }
    }

    public void addListener(LiteMod listener) {
        if (listener instanceof Tickable) {
            this.addTickListener((Tickable)listener);
        }
        if (listener instanceof GameLoopListener) {
            this.addLoopListener((GameLoopListener)((Object)listener));
        }
        if (listener instanceof InitCompleteListener) {
            this.addInitListener((InitCompleteListener)listener);
        }
        if (listener instanceof RenderListener) {
            this.addRenderListener((RenderListener)listener);
        }
        if (listener instanceof PostRenderListener) {
            this.addPostRenderListener((PostRenderListener)listener);
        }
        if (listener instanceof ChatFilter) {
            this.addChatFilter((ChatFilter)listener);
        }
        if (listener instanceof ChatListener) {
            if (listener instanceof ChatFilter) {
                LiteLoaderLogger.warning("Interface error initialising mod '%1s'. A mod implementing ChatFilter and ChatListener is not supported! Remove one of these interfaces", listener.getName());
            } else {
                this.addChatListener((ChatListener)listener);
            }
        }
        if (listener instanceof ChatRenderListener) {
            this.addChatRenderListener((ChatRenderListener)listener);
        }
        if (listener instanceof HUDRenderListener) {
            this.addHUDRenderListener((HUDRenderListener)((Object)listener));
        }
        if (listener instanceof PreJoinGameListener) {
            this.addPreJoinGameListener((PreJoinGameListener)listener);
        }
        if (listener instanceof JoinGameListener) {
            this.addJoinGameListener((JoinGameListener)listener);
        }
        if (listener instanceof ServerChatFilter) {
            this.addServerChatFilter((ServerChatFilter)listener);
        }
        if (listener instanceof ServerCommandProvider) {
            this.addServerCommandProvider((ServerCommandProvider)listener);
        }
        if (listener instanceof ServerPlayerListener) {
            this.addServerPlayerListener((ServerPlayerListener)listener);
        }
        if (listener instanceof OutboundChatListener) {
            this.addOutboundChatListener((OutboundChatListener)listener);
        }
        this.clientPluginChannels.addListener(listener);
        this.serverPluginChannels.addListener(listener);
        if (listener instanceof CommonPluginChannelListener && !(listener instanceof PluginChannelListener) && !(listener instanceof ServerPluginChannelListener)) {
            LiteLoaderLogger.warning("Interface error for mod '%1s'. Implementing CommonPluginChannelListener has no effect! Use PluginChannelListener or ServerPluginChannelListener instead", listener.getName());
        }
    }

    public void initHooks() {
        if (this.genProfiler != null) {
            try {
                LiteLoaderLogger.info("Event manager is registering the mapping generator hook", new Object[0]);
                if (!this.profilerHooked) {
                    this.profilerHooked = true;
                    PrivateFields.minecraftProfiler.setFinal(this.minecraft, this.genProfiler);
                }
            }
            catch (Exception ex) {
                LiteLoaderLogger.warning(ex, "Error creating hook", new Object[0]);
                ex.printStackTrace();
            }
        }
        this.hookInitDone = true;
    }

    public void addTickListener(Tickable tickable) {
        if (!this.tickListeners.contains(tickable)) {
            this.tickListeners.add(tickable);
            if (this.hookInitDone) {
                this.initHooks();
            }
        }
    }

    public void addLoopListener(GameLoopListener loopListener) {
        if (!this.loopListeners.contains(loopListener)) {
            this.loopListeners.add(loopListener);
            if (this.hookInitDone) {
                this.initHooks();
            }
        }
    }

    public void addInitListener(InitCompleteListener initCompleteListener) {
        if (!this.initListeners.contains(initCompleteListener)) {
            this.initListeners.add(initCompleteListener);
            if (this.hookInitDone) {
                this.initHooks();
            }
        }
    }

    public void addRenderListener(RenderListener renderListener) {
        if (!this.renderListeners.contains(renderListener)) {
            this.renderListeners.add(renderListener);
            if (this.hookInitDone) {
                this.initHooks();
            }
        }
    }

    public void addPostRenderListener(PostRenderListener postRenderListener) {
        if (!this.postRenderListeners.contains(postRenderListener)) {
            this.postRenderListeners.add(postRenderListener);
            if (this.hookInitDone) {
                this.initHooks();
            }
        }
    }

    public void addChatFilter(ChatFilter chatFilter) {
        if (!this.chatFilters.contains(chatFilter)) {
            this.chatFilters.add(chatFilter);
        }
    }

    public void addChatListener(ChatListener chatListener) {
        if (!this.chatListeners.contains(chatListener)) {
            this.chatListeners.add(chatListener);
        }
    }

    public void addChatRenderListener(ChatRenderListener chatRenderListener) {
        if (!this.chatRenderListeners.contains(chatRenderListener)) {
            this.chatRenderListeners.add(chatRenderListener);
            if (this.hookInitDone) {
                this.initHooks();
            }
        }
    }

    public void addHUDRenderListener(HUDRenderListener hudRenderListener) {
        if (!this.hudRenderListeners.contains(hudRenderListener)) {
            this.hudRenderListeners.add(hudRenderListener);
            if (this.hookInitDone) {
                this.initHooks();
            }
        }
    }

    public void addPreJoinGameListener(PostLoginListener postLoginListener) {
        if (!this.postLoginListeners.contains(postLoginListener)) {
            this.postLoginListeners.add(postLoginListener);
        }
    }

    public void addPreJoinGameListener(PreJoinGameListener joinGameListener) {
        if (!this.preJoinGameListeners.contains(joinGameListener)) {
            this.preJoinGameListeners.add(joinGameListener);
        }
    }

    public void addJoinGameListener(JoinGameListener joinGameListener) {
        if (!this.joinGameListeners.contains(joinGameListener)) {
            this.joinGameListeners.add(joinGameListener);
        }
    }

    public void addServerChatFilter(ServerChatFilter serverChatFilter) {
        if (!this.serverChatFilters.contains(serverChatFilter)) {
            this.serverChatFilters.add(serverChatFilter);
        }
    }

    public void addServerCommandProvider(ServerCommandProvider serverCommandProvider) {
        if (!this.serverCommandProviders.contains(serverCommandProvider)) {
            this.serverCommandProviders.add(serverCommandProvider);
        }
    }

    public void addServerPlayerListener(ServerPlayerListener serverPlayerListener) {
        if (!this.serverPlayerListeners.contains(serverPlayerListener)) {
            this.serverPlayerListeners.add(serverPlayerListener);
        }
    }

    private void addOutboundChatListener(OutboundChatListener outboundChatListener) {
        if (!this.outboundChatListeners.contains(outboundChatListener)) {
            this.outboundChatListeners.add(outboundChatListener);
        }
    }

    public void preBeginGame() {
        this.loader.preInitMods();
        if (!this.lateInitDone) {
            this.lateInitDone = true;
            for (InitCompleteListener initMod : this.initListeners) {
                try {
                    LiteLoaderLogger.info("Calling late init for mod " + initMod.getName(), new Object[0]);
                    initMod.onInitCompleted(this.minecraft, this.loader);
                }
                catch (Throwable th) {
                    LiteLoaderLogger.warning(th, "Error initialising mod %s", initMod.getName());
                }
            }
        }
        this.loader.preBeginGame();
    }

    public void onRender() {
        this.currentResolution = new bam(this.minecraft.u, this.minecraft.d, this.minecraft.e);
        this.screenWidth = this.currentResolution.a();
        this.screenHeight = this.currentResolution.b();
        for (RenderListener renderListener : this.renderListeners) {
            renderListener.onRender();
        }
    }

    public void postRenderEntities() {
        float partialTicks = this.minecraftTimer != null ? this.minecraftTimer.e : 0.0f;
        for (PostRenderListener renderListener : this.postRenderListeners) {
            renderListener.onPostRenderEntities(partialTicks);
        }
    }

    public void postRender() {
        float partialTicks = this.minecraftTimer != null ? this.minecraftTimer.e : 0.0f;
        for (PostRenderListener renderListener : this.postRenderListeners) {
            renderListener.onPostRender(partialTicks);
        }
    }

    public void preRenderGUI(int ref) {
        if (!this.minecraft.s && ref == (this.minecraft.f == null ? 1 : 2)) {
            for (RenderListener renderListener : this.renderListeners) {
                renderListener.onRenderGui(this.minecraft.n);
            }
        }
    }

    public void onSetupCameraTransform() {
        for (RenderListener renderListener : this.renderListeners) {
            renderListener.onSetupCameraTransform();
        }
    }

    public void onRenderChat() {
        bao chat = this.minecraft.r.b();
        for (ChatRenderListener chatRenderListener : this.chatRenderListeners) {
            chatRenderListener.onPreRenderChat(this.screenWidth, this.screenHeight, chat);
        }
    }

    public void postRenderChat() {
        bao chat = this.minecraft.r.b();
        for (ChatRenderListener chatRenderListener : this.chatRenderListeners) {
            chatRenderListener.onPostRenderChat(this.screenWidth, this.screenHeight, chat);
        }
    }

    public void onRenderHUD() {
        if (!this.minecraft.u.ag || this.minecraft.n != null) {
            for (HUDRenderListener hudRenderListener : this.hudRenderListeners) {
                hudRenderListener.onPreRenderHUD(this.screenWidth, this.screenHeight);
            }
        }
    }

    public void postRenderHUD() {
        if (!this.minecraft.u.ag || this.minecraft.n != null) {
            for (HUDRenderListener hudRenderListener : this.hudRenderListeners) {
                hudRenderListener.onPostRenderHUD(this.screenWidth, this.screenHeight);
            }
        }
    }

    public void onTimerUpdate() {
        for (GameLoopListener loopListener : this.loopListeners) {
            loopListener.onRunGameLoop(this.minecraft);
        }
    }

    public void onTick(boolean clock) {
        this.minecraft.A.a("litemods");
        float partialTicks = 0.0f;
        if (clock || this.minecraftTimer == null) {
            this.minecraftTimer = ((IMinecraft)this.minecraft).getTimer();
        }
        if (this.minecraftTimer != null) {
            partialTicks = this.minecraftTimer.c;
            clock = this.minecraftTimer.b > 0;
        }
        boolean inGame = this.minecraft.i != null && this.minecraft.i.p != null;
        this.minecraft.A.a("loader");
        this.loader.onTick(clock, partialTicks, inGame);
        int mouseX = Mouse.getX() * this.screenWidth / this.minecraft.d;
        int mouseY = this.screenHeight - Mouse.getY() * this.screenHeight / this.minecraft.e - 1;
        this.minecraft.A.c("postrender");
        this.loader.postRender(mouseX, mouseY, partialTicks);
        this.minecraft.A.b();
        for (Tickable tickable : this.tickListeners) {
            this.minecraft.A.a(tickable.getClass().getSimpleName().toLowerCase());
            tickable.onTick(this.minecraft, partialTicks, inGame, clock);
            this.minecraft.A.b();
        }
        if (this.minecraft.f != null) {
            if (this.minecraft.f.hashCode() != this.worldHashCode) {
                this.worldHashCode = this.minecraft.f.hashCode();
                this.loader.onWorldChanged((afn)this.minecraft.f);
            }
        } else {
            this.worldHashCode = 0;
            this.loader.onWorldChanged(null);
        }
        this.minecraft.A.b();
    }

    public boolean onChat(ga chatPacket) {
        if (chatPacket.c() == null) {
            return true;
        }
        fa chat = chatPacket.c();
        String message = chat.d();
        for (ChatFilter chatFilter : this.chatFilters) {
            if (chatFilter.onChat(chatPacket, chat, message)) {
                chat = chatPacket.c();
                message = chat.d();
                continue;
            }
            return false;
        }
        for (ChatListener chatListener : this.chatListeners) {
            chatListener.onChat(chat, message);
        }
        return true;
    }

    public void onSendChatMessage(ie packet, String message) {
        for (OutboundChatListener outboundChatListener : this.outboundChatListeners) {
            outboundChatListener.onSendChatMessage(packet, message);
        }
    }

    public void onPostLogin(jf netHandler, jg loginPacket) {
        this.clientPluginChannels.onPostLogin(netHandler, loginPacket);
        for (PostLoginListener loginListener : this.postLoginListeners) {
            loginListener.onPostLogin(netHandler, loginPacket);
        }
    }

    public boolean onPreJoinGame(es netHandler, gu loginPacket) {
        boolean cancelled = false;
        for (PreJoinGameListener joinGameListener : this.preJoinGameListeners) {
            cancelled |= !joinGameListener.onPreJoinGame(netHandler, loginPacket);
        }
        return !cancelled;
    }

    public void onJoinGame(es netHandler, gu loginPacket) {
        this.loader.onJoinGame(netHandler, loginPacket);
        this.clientPluginChannels.onJoinGame(netHandler, loginPacket);
        for (JoinGameListener joinGameListener : this.joinGameListeners) {
            joinGameListener.onJoinGame(netHandler, loginPacket);
        }
    }

    public boolean onServerChat(ib netHandler, ie chatPacket) {
        mm player = netHandler instanceof mx ? ((mx)netHandler).b : null;
        for (ServerChatFilter chatFilter : this.serverChatFilters) {
            if (chatFilter.onChat(player, chatPacket, chatPacket.c())) continue;
            return false;
        }
        return true;
    }

    public void onStartIntegratedServer(bsk instance, String folderName, String worldName, afv worldSettings) {
        ab commandManager = instance.H();
        if (commandManager instanceof bk) {
            bk serverCommandManager = (bk)commandManager;
            for (ServerCommandProvider commandProvider : this.serverCommandProviders) {
                commandProvider.provideCommands(serverCommandManager);
            }
        }
    }

    public void onSpawnPlayer(ld scm, mm player, GameProfile profile) {
        for (ServerPlayerListener serverPlayerListener : this.serverPlayerListeners) {
            serverPlayerListener.onPlayerConnect(player, profile);
        }
    }

    public void onPlayerLogin(ld scm, mm player) {
        this.serverPluginChannels.onPlayerJoined(player);
    }

    public void onInitializePlayerConnection(ld scm, ef netManager, mm player) {
        for (ServerPlayerListener serverPlayerListener : this.serverPlayerListeners) {
            serverPlayerListener.onPlayerLoggedIn(player);
        }
    }

    public void onRespawnPlayer(ld scm, mm player, mm oldPlayer, int dimension, boolean won) {
        for (ServerPlayerListener serverPlayerListener : this.serverPlayerListeners) {
            serverPlayerListener.onPlayerRespawn(player, oldPlayer, dimension, won);
        }
    }

    public void onPlayerLogout(ld scm, mm player) {
        for (ServerPlayerListener serverPlayerListener : this.serverPlayerListeners) {
            serverPlayerListener.onPlayerLogout(player);
        }
    }
}

