/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.core;

import com.mumfrey.liteloader.core.EnabledModsList;
import com.mumfrey.liteloader.core.EnumeratorModule;
import com.mumfrey.liteloader.core.LoadableMod;
import com.mumfrey.liteloader.core.LoadableModClassPath;
import com.mumfrey.liteloader.core.PluggableEnumerator;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import net.minecraft.launchwrapper.LaunchClassLoader;

public class EnumeratorModuleProtectionDomain
implements EnumeratorModule<File> {
    private LoadableMod<File> codeSource;

    public EnumeratorModuleProtectionDomain(boolean loadTweaks) {
        this.initPackagePath();
    }

    public String toString() {
        return this.codeSource != null ? this.codeSource.getName() : "<None>";
    }

    private void initPackagePath() {
        try {
            URL protectionDomainLocation = EnumeratorModuleProtectionDomain.class.getProtectionDomain().getCodeSource().getLocation();
            if (protectionDomainLocation != null) {
                File packagePath;
                LiteLoaderLogger.info("Determining code source using protection domain", new Object[0]);
                if (protectionDomainLocation.toString().indexOf(33) > -1 && protectionDomainLocation.toString().startsWith("jar:")) {
                    LiteLoaderLogger.info("Protection domain references a jar file", new Object[0]);
                    protectionDomainLocation = new URL(protectionDomainLocation.toString().substring(4, protectionDomainLocation.toString().indexOf(33)));
                }
                if ((packagePath = new File(protectionDomainLocation.toURI())).isFile() && packagePath.getName().endsWith(".class")) {
                    packagePath = packagePath.getParentFile();
                }
                this.codeSource = new LoadableModClassPath(packagePath);
            } else {
                LiteLoaderLogger.info("Determining code source using resource", new Object[0]);
                String reflectionClassPath = EnumeratorModuleProtectionDomain.class.getResource("/net/minecraft/client/main/Main.class").getPath();
                if (reflectionClassPath.indexOf(33) > -1) {
                    reflectionClassPath = URLDecoder.decode(reflectionClassPath, "UTF-8");
                    this.codeSource = new LoadableModClassPath(new File(reflectionClassPath.substring(5, reflectionClassPath.indexOf(33))));
                }
            }
        }
        catch (Throwable th) {
            LiteLoaderLogger.warning("Error determining local protection domain: %s", th.getMessage());
        }
    }

    @Override
    public void init(PluggableEnumerator enumerator) {
    }

    @Override
    public void writeSettings(PluggableEnumerator enumerator) {
    }

    @Override
    public void enumerate(PluggableEnumerator enumerator, EnabledModsList enabledModsList, String profile) {
    }

    @Override
    public void injectIntoClassLoader(PluggableEnumerator enumerator, LaunchClassLoader classLoader, EnabledModsList enabledModsList, String profile) {
    }

    @Override
    public void registerMods(PluggableEnumerator enumerator, LaunchClassLoader classLoader) {
        LiteLoaderLogger.info("Discovering mods in protection domain...", new Object[0]);
        try {
            if (this.codeSource != null) {
                enumerator.registerModsFrom(this.codeSource, false);
            }
        }
        catch (Throwable th) {
            LiteLoaderLogger.warning("Error loading from local class path: %s", th.getMessage());
        }
    }
}

