/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.core;

import com.mumfrey.liteloader.core.EnabledModsList;
import com.mumfrey.liteloader.core.EnumeratorModule;
import com.mumfrey.liteloader.core.LiteLoaderVersion;
import com.mumfrey.liteloader.core.LoadableFile;
import com.mumfrey.liteloader.core.LoadableMod;
import com.mumfrey.liteloader.core.LoadableModFile;
import com.mumfrey.liteloader.core.PluggableEnumerator;
import com.mumfrey.liteloader.core.TweakContainer;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.launchwrapper.LaunchClassLoader;

public class EnumeratorModuleFolder
implements FilenameFilter,
EnumeratorModule<File> {
    private static final String OPTION_SEARCH_ZIPFILES = "search.zipfiles";
    private static final String OPTION_SEARCH_JARFILES = "search.jarfiles";
    private final Map<String, TreeSet<LoadableMod<File>>> versionOrderingSets = new HashMap<String, TreeSet<LoadableMod<File>>>();
    private final List<LoadableMod<File>> loadableMods = new ArrayList<LoadableMod<File>>();
    private File directory;
    private boolean readZipFiles;
    private boolean readJarFiles;
    private boolean loadTweaks;
    private final boolean requireMetaData;

    public EnumeratorModuleFolder(File directory, boolean loadTweaks, boolean requireMetaData) {
        this.directory = directory;
        this.loadTweaks = loadTweaks;
        this.requireMetaData = requireMetaData;
    }

    @Override
    public void init(PluggableEnumerator enumerator) {
        this.readZipFiles = enumerator.getAndStoreBooleanProperty(OPTION_SEARCH_ZIPFILES, false);
        this.readJarFiles = enumerator.getAndStoreBooleanProperty(OPTION_SEARCH_JARFILES, true);
    }

    @Override
    public void writeSettings(PluggableEnumerator enumerator) {
        enumerator.setBooleanProperty(OPTION_SEARCH_ZIPFILES, this.readZipFiles);
        enumerator.setBooleanProperty(OPTION_SEARCH_JARFILES, this.readJarFiles);
    }

    public String toString() {
        return this.directory.getAbsolutePath();
    }

    public File getDirectory() {
        return this.directory;
    }

    public List<LoadableMod<File>> getLoadableMods() {
        return this.loadableMods;
    }

    @Override
    public boolean accept(File dir, String fileName) {
        return (fileName = fileName.toLowerCase()).endsWith(".litemod") || this.readZipFiles && fileName.endsWith(".zip") || this.readJarFiles && fileName.endsWith(".jar");
    }

    @Override
    public void enumerate(PluggableEnumerator enumerator, EnabledModsList enabledModsList, String profile) {
        if (this.directory.exists() && this.directory.isDirectory()) {
            LiteLoaderLogger.info("Discovering valid mod files in folder %s", this.directory.getPath());
            this.findValidFiles(enumerator, enabledModsList, profile);
            this.sortAndAllocateFiles(enumerator, enabledModsList, profile);
            this.versionOrderingSets.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findValidFiles(PluggableEnumerator enumerator, EnabledModsList enabledModsList, String profile) {
        for (File candidateFile : this.directory.listFiles(this)) {
            ZipFile candidateZip = null;
            try {
                candidateZip = new ZipFile(candidateFile);
                ZipEntry versionEntry = candidateZip.getEntry("litemod.json");
                ZipEntry legacyVersionEntry = candidateZip.getEntry("version.txt");
                if (versionEntry != null) {
                    String strVersion = null;
                    try {
                        strVersion = LoadableModFile.zipEntryToString(candidateZip, versionEntry);
                    }
                    catch (IOException ex) {
                        LiteLoaderLogger.warning("Error reading version data from %s", candidateZip.getName());
                    }
                    if (strVersion == null) continue;
                    this.addModFile(candidateFile, strVersion);
                    continue;
                }
                if (legacyVersionEntry != null) {
                    LiteLoaderLogger.warning("%s is no longer supported, ignoring outdated mod file: %s", "version.txt", candidateFile.getAbsolutePath());
                    continue;
                }
                if (this.requireMetaData || !this.loadTweaks || !this.readJarFiles || !candidateFile.getName().toLowerCase().endsWith(".jar")) continue;
                LoadableFile container = new LoadableFile(candidateFile);
                enumerator.registerTweakContainer(container);
            }
            catch (Exception ex) {
                LiteLoaderLogger.info("Error enumerating '%s': Invalid zip file or error reading file", candidateFile.getAbsolutePath());
            }
            finally {
                if (candidateZip != null) {
                    try {
                        candidateZip.close();
                    }
                    catch (IOException ex) {}
                }
            }
        }
    }

    private void addModFile(File candidateFile, String strVersion) {
        LoadableModFile modFile = new LoadableModFile(candidateFile, strVersion);
        if (modFile.hasValidMetaData()) {
            if (LiteLoaderVersion.CURRENT.isVersionSupported(modFile.getTargetVersion())) {
                if (!this.versionOrderingSets.containsKey(modFile.getName())) {
                    this.versionOrderingSets.put(modFile.getModName(), new TreeSet());
                }
                LiteLoaderLogger.info("Considering valid mod file: %s", modFile.getAbsolutePath());
                this.versionOrderingSets.get(modFile.getModName()).add(modFile);
            } else {
                LiteLoaderLogger.info("Not adding invalid or outdated mod file: %s", candidateFile.getAbsolutePath());
            }
        }
    }

    private void sortAndAllocateFiles(PluggableEnumerator enumerator, EnabledModsList enabledModsList, String profile) {
        for (Map.Entry<String, TreeSet<LoadableMod<File>>> modFileEntry : this.versionOrderingSets.entrySet()) {
            LoadableMod<File> newestVersion = modFileEntry.getValue().iterator().next();
            if (enumerator.isContainerEnabled(newestVersion)) {
                LiteLoaderLogger.info("Adding newest valid mod file '%s' at revision %.4f", newestVersion.getLocation(), Float.valueOf(newestVersion.getRevision()));
                this.loadableMods.add(newestVersion);
            } else {
                LiteLoaderLogger.info("Not adding valid mod file '%s', the specified mod is disabled or missing a required dependency", newestVersion.getLocation());
            }
            if (!this.loadTweaks) continue;
            try {
                if (!(newestVersion instanceof TweakContainer)) continue;
                enumerator.registerTweakContainer((TweakContainer)((Object)newestVersion));
            }
            catch (Throwable th) {
                LiteLoaderLogger.warning("Error adding tweaks from '%s'", newestVersion.getLocation());
            }
        }
    }

    @Override
    public void injectIntoClassLoader(PluggableEnumerator enumerator, LaunchClassLoader classLoader, EnabledModsList enabledModsList, String profile) {
        LiteLoaderLogger.info("Injecting external mods into class path...", new Object[0]);
        for (LoadableMod<File> loadableMod : this.loadableMods) {
            try {
                if (!loadableMod.injectIntoClassPath(classLoader, false)) continue;
                LiteLoaderLogger.info("Successfully injected mod file '%s' into classpath", loadableMod.getLocation());
            }
            catch (MalformedURLException ex) {
                LiteLoaderLogger.warning("Error injecting '%s' into classPath. The mod will not be loaded", loadableMod.getLocation());
            }
        }
    }

    @Override
    public void registerMods(PluggableEnumerator enumerator, LaunchClassLoader classLoader) {
        LiteLoaderLogger.info("Discovering mods in valid mod files...", new Object[0]);
        for (LoadableMod<File> modFile : this.loadableMods) {
            LiteLoaderLogger.info("Searching %s...", modFile.getLocation());
            enumerator.registerModsFrom(modFile, true);
        }
    }
}

