/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.core;

import com.mumfrey.liteloader.core.EnabledModsList;
import com.mumfrey.liteloader.core.EnumeratorModule;
import com.mumfrey.liteloader.core.LoadableMod;
import com.mumfrey.liteloader.core.LoadableModClassPath;
import com.mumfrey.liteloader.core.PluggableEnumerator;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.launchwrapper.LaunchClassLoader;

public class EnumeratorModuleClassPath
implements EnumeratorModule<File> {
    private final String[] classPathEntries;
    private final List<LoadableMod<File>> loadableMods = new ArrayList<LoadableMod<File>>();
    private boolean loadTweaks;

    public EnumeratorModuleClassPath(boolean loadTweaks) {
        this.classPathEntries = this.readClassPath();
        this.loadTweaks = loadTweaks;
    }

    public String toString() {
        return "<Java Class Path>";
    }

    @Override
    public void init(PluggableEnumerator enumerator) {
    }

    @Override
    public void writeSettings(PluggableEnumerator enumerator) {
    }

    private String[] readClassPath() {
        LiteLoaderLogger.info("Enumerating class path...", new Object[0]);
        String classPath = System.getProperty("java.class.path");
        String classPathSeparator = System.getProperty("path.separator");
        String[] classPathEntries = classPath.split(classPathSeparator);
        LiteLoaderLogger.info("Class path separator=\"%s\"", classPathSeparator);
        LiteLoaderLogger.info("Class path entries=(\n   classpathEntry=%s\n)", classPath.replace(classPathSeparator, "\n   classpathEntry="));
        return classPathEntries;
    }

    @Override
    public void enumerate(PluggableEnumerator enumerator, EnabledModsList enabledModsList, String profile) {
        if (this.loadTweaks) {
            LiteLoaderLogger.info("Discovering tweaks on class path...", new Object[0]);
            for (String classPathPart : this.classPathEntries) {
                File packagePath = new File(classPathPart);
                if (!packagePath.exists()) continue;
                LoadableModClassPath classPathMod = new LoadableModClassPath(packagePath);
                if (enumerator.isContainerEnabled(classPathMod)) {
                    this.loadableMods.add(classPathMod);
                    if (!classPathMod.hasTweakClass() && !classPathMod.hasClassTransformers()) continue;
                    enumerator.registerTweakContainer(classPathMod);
                    continue;
                }
                LiteLoaderLogger.info("Mod %s is disabled or missing a required dependency, not injecting tranformers", classPathMod.getIdentifier());
            }
        }
    }

    @Override
    public void injectIntoClassLoader(PluggableEnumerator enumerator, LaunchClassLoader classLoader, EnabledModsList enabledModsList, String profile) {
    }

    @Override
    public void registerMods(PluggableEnumerator enumerator, LaunchClassLoader classLoader) {
        LiteLoaderLogger.info("Discovering mods on class path...", new Object[0]);
        for (LoadableMod<File> classPathMod : this.loadableMods) {
            LiteLoaderLogger.info("Searching %s...", classPathMod);
            enumerator.registerModsFrom(classPathMod, true);
        }
    }
}

