/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.core;

import com.mumfrey.liteloader.LiteMod;
import com.mumfrey.liteloader.PluginChannelListener;
import com.mumfrey.liteloader.core.LiteLoader;
import com.mumfrey.liteloader.core.PluginChannels;
import com.mumfrey.liteloader.core.exceptions.UnregisteredChannelException;
import com.mumfrey.liteloader.permissions.PermissionsManagerClient;
import com.mumfrey.liteloader.util.PrivateFields;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.LinkedList;

public class ClientPluginChannels
extends PluginChannels<PluginChannelListener> {
    private static ClientPluginChannels instance;

    ClientPluginChannels() {
        instance = this;
    }

    static ClientPluginChannels getInstance() {
        return instance;
    }

    void addListener(LiteMod listener) {
        if (listener instanceof PluginChannelListener) {
            this.addPluginChannelListener((PluginChannelListener)listener);
        }
    }

    void onPostLogin(jf netHandler, jg loginPacket) {
        this.clearPluginChannels((es)netHandler);
    }

    void onJoinGame(es netHandler, gu loginPacket) {
        this.sendRegisteredPluginChannels(netHandler);
    }

    public void onPluginChannelMessage(gi customPayload) {
        if (customPayload != null && customPayload.c() != null) {
            String channel = customPayload.c();
            byte[] data = customPayload.d();
            if ("REGISTER".equals(channel)) {
                this.onRegisterPacketReceived(data);
            } else if (this.pluginChannels.containsKey(channel)) {
                try {
                    PermissionsManagerClient permissionsManager = LiteLoader.getPermissionsManager();
                    if (permissionsManager != null) {
                        permissionsManager.onCustomPayload(channel, data.length, data);
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                this.onModPacketReceived(channel, data, data.length);
            }
        }
    }

    protected void onModPacketReceived(String channel, byte[] data, int length) {
        for (PluginChannelListener pluginChannelListener : (LinkedList)this.pluginChannels.get(channel)) {
            try {
                pluginChannelListener.onCustomPayload(channel, length, data);
                throw new RuntimeException();
            }
            catch (Exception ex) {
                int failCount = 1;
                if (this.faultingPluginChannelListeners.containsKey(pluginChannelListener)) {
                    failCount = (Integer)this.faultingPluginChannelListeners.get(pluginChannelListener) + 1;
                }
                if (failCount >= 1000) {
                    LiteLoaderLogger.warning("Plugin channel listener %s exceeded fault threshold on channel %s with %s", pluginChannelListener.getName(), channel, ex.getClass().getSimpleName());
                    this.faultingPluginChannelListeners.remove(pluginChannelListener);
                    continue;
                }
                this.faultingPluginChannelListeners.put(pluginChannelListener, failCount);
            }
        }
    }

    protected void sendRegisteredPluginChannels(es netHandler) {
        this.addPluginChannelsFor(LiteLoader.getPermissionsManager());
        try {
            byte[] registrationData = this.getRegistrationData();
            if (registrationData != null) {
                this.sendRegistrationData(netHandler, registrationData);
            }
        }
        catch (Exception ex) {
            LiteLoaderLogger.warning(ex, "Error dispatching REGISTER packet to server %s", ex.getClass().getSimpleName());
        }
    }

    protected void sendRegistrationData(es netHandler, byte[] registrationData) {
        if (netHandler instanceof jf) {
            ef networkManager = PrivateFields.netManager.get((bit)netHandler);
            networkManager.a((fk)new in("REGISTER", registrationData), new GenericFutureListener[0]);
        } else if (netHandler instanceof fm) {
            ClientPluginChannels.dispatch(new in("REGISTER", registrationData));
        }
    }

    static boolean dispatch(in payload) {
        try {
            azd minecraft = azd.A();
            if (minecraft.h != null && minecraft.h.a != null) {
                minecraft.h.a.a((fk)payload);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean sendMessage(String channel, byte[] data, PluginChannels.ChannelPolicy policy) {
        if (!policy.allows(ClientPluginChannels.getInstance(), channel)) {
            if (policy.isSilent()) {
                return false;
            }
            throw new UnregisteredChannelException(channel);
        }
        if (channel == null || channel.length() > 16 || "REGISTER".equals(channel) || "UNREGISTER".equals(channel)) {
            throw new RuntimeException("Invalid channel name specified");
        }
        in payload = new in(channel, data);
        return ClientPluginChannels.dispatch(payload);
    }
}

