/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LabelNode;

public class LookupSwitchInsnNode
extends AbstractInsnNode {
    public LabelNode dflt;
    public List<Integer> keys;
    public List<LabelNode> labels;

    public LookupSwitchInsnNode(LabelNode labelNode, int[] nArray, LabelNode[] labelNodeArray) {
        super(171);
        this.dflt = labelNode;
        this.keys = new ArrayList<Integer>(nArray == null ? 0 : nArray.length);
        this.labels = new ArrayList<LabelNode>(labelNodeArray == null ? 0 : labelNodeArray.length);
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                this.keys.add(new Integer(nArray[i]));
            }
        }
        if (labelNodeArray != null) {
            this.labels.addAll(Arrays.asList(labelNodeArray));
        }
    }

    @Override
    public int getType() {
        return 12;
    }

    @Override
    public void accept(MethodVisitor methodVisitor) {
        int[] nArray = new int[this.keys.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.keys.get(i);
        }
        Label[] labelArray = new Label[this.labels.size()];
        for (int i = 0; i < labelArray.length; ++i) {
            labelArray[i] = this.labels.get(i).getLabel();
        }
        methodVisitor.visitLookupSwitchInsn(this.dflt.getLabel(), nArray, labelArray);
    }

    @Override
    public AbstractInsnNode clone(Map<LabelNode, LabelNode> map) {
        LookupSwitchInsnNode lookupSwitchInsnNode = new LookupSwitchInsnNode(LookupSwitchInsnNode.clone(this.dflt, map), null, LookupSwitchInsnNode.clone(this.labels, map));
        lookupSwitchInsnNode.keys.addAll(this.keys);
        return lookupSwitchInsnNode;
    }
}

