/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.asm.transformers;

import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.io.LineProcessor;
import com.google.common.io.Resources;
import cpw.mods.fml.relauncher.IClassTransformer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;

public class AccessTransformer
implements IClassTransformer {
    private static final boolean DEBUG = false;
    private Multimap<String, Modifier> modifiers = ArrayListMultimap.create();

    public AccessTransformer() throws IOException {
        this("fml_at.cfg");
    }

    protected AccessTransformer(String rulesFile) throws IOException {
        this.readMapFile(rulesFile);
    }

    private void readMapFile(String rulesFile) throws IOException {
        File file = new File(rulesFile);
        URL rulesResource = file.exists() ? file.toURI().toURL() : Resources.getResource((String)rulesFile);
        Resources.readLines((URL)rulesResource, (Charset)Charsets.UTF_8, (LineProcessor)new LineProcessor<Void>(){

            public Void getResult() {
                return null;
            }

            public boolean processLine(String input) throws IOException {
                String line = ((String)Iterables.getFirst((Iterable)Splitter.on((char)'#').limit(2).split((CharSequence)input), (Object)"")).trim();
                if (line.length() == 0) {
                    return true;
                }
                ArrayList parts = Lists.newArrayList((Iterable)Splitter.on((String)" ").trimResults().split((CharSequence)line));
                if (parts.size() > 2) {
                    throw new RuntimeException("Invalid config file line " + input);
                }
                Modifier m2 = new Modifier();
                m2.setTargetAccess((String)parts.get(0));
                ArrayList descriptor = Lists.newArrayList((Iterable)Splitter.on((String)".").trimResults().split((CharSequence)parts.get(1)));
                if (descriptor.size() == 1) {
                    m2.modifyClassVisibility = true;
                } else {
                    String nameReference = (String)descriptor.get(1);
                    int parenIdx = nameReference.indexOf(40);
                    if (parenIdx > 0) {
                        m2.desc = nameReference.substring(parenIdx);
                        m2.name = nameReference.substring(0, parenIdx);
                    } else {
                        m2.name = nameReference;
                    }
                }
                AccessTransformer.this.modifiers.put((Object)((String)descriptor.get(0)).replace('/', '.'), (Object)m2);
                return true;
            }
        });
    }

    @Override
    public byte[] transform(String name, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        if (!this.modifiers.containsKey((Object)name)) {
            return bytes;
        }
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        Collection mods = this.modifiers.get((Object)name);
        block0: for (Modifier m2 : mods) {
            if (m2.modifyClassVisibility) {
                classNode.access = this.getFixedAccess(classNode.access, m2);
                continue;
            }
            if (m2.desc.isEmpty()) {
                for (FieldNode n2 : classNode.fields) {
                    if (!n2.name.equals(m2.name) && !m2.name.equals("*")) continue;
                    n2.access = this.getFixedAccess(n2.access, m2);
                    if (m2.name.equals("*")) continue;
                    continue block0;
                }
                continue;
            }
            for (FieldNode n2 : classNode.methods) {
                if ((!n2.name.equals(m2.name) || !n2.desc.equals(m2.desc)) && !m2.name.equals("*")) continue;
                n2.access = this.getFixedAccess(n2.access, m2);
                if (m2.name.equals("*")) continue;
                continue block0;
            }
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private String toBinary(int num) {
        return String.format("%16s", Integer.toBinaryString(num)).replace(' ', '0');
    }

    private int getFixedAccess(int access, Modifier target) {
        target.oldAccess = access;
        int t2 = target.targetAccess;
        int ret = access & 0xFFFFFFF8;
        switch (access & 7) {
            case 2: {
                ret |= t2;
                break;
            }
            case 0: {
                ret |= t2 != 2 ? t2 : 0;
                break;
            }
            case 4: {
                ret |= t2 != 2 && t2 != 0 ? t2 : 4;
                break;
            }
            case 1: {
                ret |= t2 != 2 && t2 != 0 && t2 != 4 ? t2 : 1;
                break;
            }
            default: {
                throw new RuntimeException("The fuck?");
            }
        }
        if (target.changeFinal && target.desc == "") {
            ret = target.markFinal ? (ret |= 0x10) : (ret &= 0xFFFFFFEF);
        }
        target.newAccess = ret;
        return ret;
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Usage: AccessTransformer <JarPath> <MapFile> [MapFile2]... ");
            System.exit(1);
        }
        boolean hasTransformer = false;
        AccessTransformer[] trans = new AccessTransformer[args.length - 1];
        for (int x2 = 1; x2 < args.length; ++x2) {
            try {
                trans[x2 - 1] = new AccessTransformer(args[x2]);
                hasTransformer = true;
                continue;
            }
            catch (IOException e2) {
                System.out.println("Could not read Transformer Map: " + args[x2]);
                e2.printStackTrace();
            }
        }
        if (!hasTransformer) {
            System.out.println("Culd not find a valid transformer to perform");
            System.exit(1);
        }
        File orig = new File(args[0]);
        File temp = new File(args[0] + ".ATBack");
        if (!orig.exists() && !temp.exists()) {
            System.out.println("Could not find target jar: " + orig);
            System.exit(1);
        }
        if (!orig.renameTo(temp)) {
            System.out.println("Could not rename file: " + orig + " -> " + temp);
            System.exit(1);
        }
        try {
            AccessTransformer.processJar(temp, orig, trans);
        }
        catch (IOException e3) {
            e3.printStackTrace();
            System.exit(1);
        }
        if (!temp.delete()) {
            System.out.println("Could not delete temp file: " + temp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processJar(File inFile, File outFile, AccessTransformer[] transformers) throws IOException {
        ZipInputStream inJar = null;
        ZipOutputStream outJar = null;
        try {
            ZipEntry entry;
            try {
                inJar = new ZipInputStream(new BufferedInputStream(new FileInputStream(inFile)));
            }
            catch (FileNotFoundException e2) {
                throw new FileNotFoundException("Could not open input file: " + e2.getMessage());
            }
            try {
                outJar = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(outFile)));
            }
            catch (FileNotFoundException e3) {
                throw new FileNotFoundException("Could not open output file: " + e3.getMessage());
            }
            while ((entry = inJar.getNextEntry()) != null) {
                int len;
                if (entry.isDirectory()) {
                    outJar.putNextEntry(entry);
                    continue;
                }
                byte[] data = new byte[4096];
                ByteArrayOutputStream entryBuffer = new ByteArrayOutputStream();
                do {
                    if ((len = inJar.read(data)) <= 0) continue;
                    entryBuffer.write(data, 0, len);
                } while (len != -1);
                byte[] entryData = entryBuffer.toByteArray();
                String entryName = entry.getName();
                if (entryName.endsWith(".class") && !entryName.startsWith(".")) {
                    ClassNode cls = new ClassNode();
                    ClassReader rdr = new ClassReader(entryData);
                    rdr.accept((ClassVisitor)cls, 0);
                    String name = cls.name.replace('/', '.').replace('\\', '.');
                    for (AccessTransformer trans : transformers) {
                        entryData = trans.transform(name, entryData);
                    }
                }
                ZipEntry newEntry = new ZipEntry(entryName);
                outJar.putNextEntry(newEntry);
                outJar.write(entryData);
            }
        }
        finally {
            if (outJar != null) {
                try {
                    outJar.close();
                }
                catch (IOException e4) {}
            }
            if (inJar != null) {
                try {
                    inJar.close();
                }
                catch (IOException e5) {}
            }
        }
    }

    public void ensurePublicAccessFor(String modClazzName) {
        Modifier m2 = new Modifier();
        m2.setTargetAccess("public");
        m2.modifyClassVisibility = true;
        this.modifiers.put((Object)modClazzName, (Object)m2);
    }

    private class Modifier {
        public String name = "";
        public String desc = "";
        public int oldAccess = 0;
        public int newAccess = 0;
        public int targetAccess = 0;
        public boolean changeFinal = false;
        public boolean markFinal = false;
        protected boolean modifyClassVisibility;

        private Modifier() {
        }

        private void setTargetAccess(String name) {
            if (name.startsWith("public")) {
                this.targetAccess = 1;
            } else if (name.startsWith("private")) {
                this.targetAccess = 2;
            } else if (name.startsWith("protected")) {
                this.targetAccess = 4;
            }
            if (name.endsWith("-f")) {
                this.changeFinal = true;
                this.markFinal = false;
            } else if (name.endsWith("+f")) {
                this.changeFinal = true;
                this.markFinal = true;
            }
        }
    }
}

