/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.client.registry;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.ObjectArrays;
import cpw.mods.fml.client.SpriteHelper;
import cpw.mods.fml.client.TextureFXManager;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import java.util.List;
import java.util.Map;

public class RenderingRegistry {
    private static final RenderingRegistry INSTANCE = new RenderingRegistry();
    private int nextRenderId = 36;
    private Map<Integer, ISimpleBlockRenderingHandler> blockRenderers = Maps.newHashMap();
    private List<EntityRendererInfo> entityRenderers = Lists.newArrayList();

    public static int addNewArmourRendererPrefix(String armor) {
        bco.h = (String[])ObjectArrays.concat((Object[])bco.h, (Object)armor);
        bcc.k = bco.h;
        return bco.h.length - 1;
    }

    public static void registerEntityRenderingHandler(Class<? extends lq> entityClass, bbv renderer) {
        RenderingRegistry.instance().entityRenderers.add(new EntityRendererInfo(entityClass, renderer));
    }

    public static void registerBlockHandler(ISimpleBlockRenderingHandler handler) {
        RenderingRegistry.instance().blockRenderers.put(handler.getRenderId(), handler);
    }

    public static void registerBlockHandler(int renderId, ISimpleBlockRenderingHandler handler) {
        RenderingRegistry.instance().blockRenderers.put(renderId, handler);
    }

    public static int getNextAvailableRenderId() {
        return RenderingRegistry.instance().nextRenderId++;
    }

    public static int addTextureOverride(String fileToOverride, String fileToAdd) {
        int idx = SpriteHelper.getUniqueSpriteIndex(fileToOverride);
        RenderingRegistry.addTextureOverride(fileToOverride, fileToAdd, idx);
        return idx;
    }

    public static void addTextureOverride(String path, String overlayPath, int index) {
        TextureFXManager.instance().addNewTextureOverride(path, overlayPath, index);
    }

    public static int getUniqueTextureIndex(String path) {
        return SpriteHelper.getUniqueSpriteIndex(path);
    }

    @Deprecated
    public static RenderingRegistry instance() {
        return INSTANCE;
    }

    public boolean renderWorldBlock(bbb renderer, ym world, int x2, int y2, int z2, amq block, int modelId) {
        if (!this.blockRenderers.containsKey(modelId)) {
            return false;
        }
        ISimpleBlockRenderingHandler bri = this.blockRenderers.get(modelId);
        return bri.renderWorldBlock(world, x2, y2, z2, block, modelId, renderer);
    }

    public void renderInventoryBlock(bbb renderer, amq block, int metadata, int modelID) {
        if (!this.blockRenderers.containsKey(modelID)) {
            return;
        }
        ISimpleBlockRenderingHandler bri = this.blockRenderers.get(modelID);
        bri.renderInventoryBlock(block, metadata, modelID, renderer);
    }

    public boolean renderItemAsFull3DBlock(int modelId) {
        ISimpleBlockRenderingHandler bri = this.blockRenderers.get(modelId);
        return bri != null && bri.shouldRender3DInInventory();
    }

    public void loadEntityRenderers(Map<Class<? extends lq>, bbv> rendererMap) {
        for (EntityRendererInfo info : this.entityRenderers) {
            rendererMap.put(info.target, info.renderer);
            info.renderer.a(bbu.a);
        }
    }

    private static class EntityRendererInfo {
        private Class<? extends lq> target;
        private bbv renderer;

        public EntityRendererInfo(Class<? extends lq> target, bbv renderer) {
            this.target = target;
            this.renderer = renderer;
        }
    }
}

