/*
 * Decompiled with CFR 0.152.
 */
import java.util.Properties;
import org.lwjgl.opengl.GL11;

public class CustomSkyLayer {
    public String source = null;
    private int startFadeIn = -1;
    private int endFadeIn = -1;
    private int startFadeOut = -1;
    private int endFadeOut = -1;
    private int blend = 0;
    private boolean rotate = false;
    private float speed = 1.0f;
    private float[] axis = DEFAULT_AXIS;
    public int textureId = -1;
    public static final int BLEND_ADD = 0;
    public static final int BLEND_SUBSTRACT = 1;
    public static final int BLEND_MULTIPLY = 2;
    public static final int BLEND_DODGE = 3;
    public static final int BLEND_BURN = 4;
    public static final int BLEND_SCREEN = 5;
    public static final int BLEND_REPLACE = 6;
    public static final float[] DEFAULT_AXIS = new float[]{1.0f, 0.0f, 0.0f};

    public CustomSkyLayer(Properties props, String defSource) {
        this.source = props.getProperty("source", defSource);
        this.startFadeIn = this.parseTime(props.getProperty("startFadeIn"));
        this.endFadeIn = this.parseTime(props.getProperty("endFadeIn"));
        this.startFadeOut = this.parseTime(props.getProperty("startFadeOut"));
        this.endFadeOut = this.parseTime(props.getProperty("endFadeOut"));
        this.blend = this.parseBlend(props.getProperty("blend"));
        this.rotate = this.parseBoolean(props.getProperty("rotate"), true);
        this.speed = this.parseFloat(props.getProperty("speed"), 1.0f);
        this.axis = this.parseAxis(props.getProperty("axis"), DEFAULT_AXIS);
    }

    private int parseTime(String str) {
        if (str == null) {
            return -1;
        }
        String[] strs = Config.tokenize(str, ":");
        if (strs.length != 2) {
            Config.dbg("Invalid time: " + str);
            return -1;
        }
        String hourStr = strs[0];
        String minStr = strs[1];
        int hour = Config.parseInt(hourStr, -1);
        int min = Config.parseInt(minStr, -1);
        if (hour < 0 || hour > 23 || min < 0 || min > 59) {
            Config.dbg("Invalid time: " + str);
            return -1;
        }
        if ((hour -= 6) < 0) {
            hour += 24;
        }
        int time = hour * 1000 + (int)((double)min / 60.0 * 1000.0);
        return time;
    }

    private int parseBlend(String str) {
        if (str == null) {
            return 0;
        }
        if (str.equals("add")) {
            return 0;
        }
        if (str.equals("subtract")) {
            return 1;
        }
        if (str.equals("multiply")) {
            return 2;
        }
        if (str.equals("dodge")) {
            return 3;
        }
        if (str.equals("burn")) {
            return 4;
        }
        if (str.equals("screen")) {
            return 5;
        }
        if (str.equals("replace")) {
            return 6;
        }
        Config.dbg("Unknown blend: " + str);
        return 0;
    }

    private boolean parseBoolean(String str, boolean defVal) {
        if (str == null) {
            return defVal;
        }
        if (str.toLowerCase().equals("true")) {
            return true;
        }
        if (str.toLowerCase().equals("false")) {
            return false;
        }
        Config.dbg("Unknown boolean: " + str);
        return defVal;
    }

    private float parseFloat(String str, float defVal) {
        if (str == null) {
            return defVal;
        }
        float val = Config.parseFloat(str, Float.MIN_VALUE);
        if (val == Float.MIN_VALUE) {
            Config.dbg("Invalid value: " + str);
            return defVal;
        }
        return val;
    }

    private float[] parseAxis(String str, float[] defVal) {
        if (str == null) {
            return defVal;
        }
        String[] strs = Config.tokenize(str, " ");
        if (strs.length != 3) {
            Config.dbg("Invalid axis: " + str);
            return defVal;
        }
        float[] fs2 = new float[3];
        for (int i2 = 0; i2 < strs.length; ++i2) {
            fs2[i2] = Config.parseFloat(strs[i2], Float.MIN_VALUE);
            if (fs2[i2] == Float.MIN_VALUE) {
                Config.dbg("Invalid axis: " + str);
                return defVal;
            }
            if (!(fs2[i2] < -1.0f) && !(fs2[i2] > 1.0f)) continue;
            Config.dbg("Invalid axis values: " + str);
            return defVal;
        }
        float ax2 = fs2[0];
        float ay2 = fs2[1];
        float az2 = fs2[2];
        if (ax2 * ax2 + ay2 * ay2 + az2 * az2 < 1.0E-5f) {
            Config.dbg("Invalid axis values: " + str);
            return defVal;
        }
        float[] as2 = new float[]{az2, ay2, -ax2};
        return as2;
    }

    public boolean isValid(String path) {
        int timeOff;
        int timeFadeOut;
        int timeOn;
        int timeSum;
        if (this.source == null) {
            Config.dbg("No source texture: " + path);
            return false;
        }
        if (this.startFadeIn < 0 || this.endFadeIn < 0 || this.endFadeOut < 0) {
            Config.dbg("Invalid times, required are: startFadeIn, endFadeIn and endFadeOut.");
            return false;
        }
        int timeFadeIn = this.normalizeTime(this.endFadeIn - this.startFadeIn);
        if (this.startFadeOut < 0) {
            this.startFadeOut = this.normalizeTime(this.endFadeOut - timeFadeIn);
        }
        if ((timeSum = timeFadeIn + (timeOn = this.normalizeTime(this.startFadeOut - this.endFadeIn)) + (timeFadeOut = this.normalizeTime(this.endFadeOut - this.startFadeOut)) + (timeOff = this.normalizeTime(this.startFadeIn - this.endFadeOut))) != 24000) {
            Config.dbg("Invalid fadeIn/fadeOut times, sum is more than 24h");
            return false;
        }
        if (this.speed < 0.0f) {
            Config.dbg("Invalid speed: " + this.speed);
            return false;
        }
        return true;
    }

    private int normalizeTime(int timeMc) {
        while (timeMc >= 24000) {
            timeMc -= 24000;
        }
        while (timeMc < 0) {
            timeMc += 24000;
        }
        return timeMc;
    }

    public void render(int timeOfDay, bba re2, float celestialAngle, float rainBrightness) {
        float brightness = rainBrightness * this.getFadeBrightness(timeOfDay);
        if ((brightness = Config.limit(brightness, 0.0f, 1.0f)) < 1.0E-4f) {
            return;
        }
        re2.b(this.textureId);
        this.setupBlend(brightness);
        GL11.glPushMatrix();
        if (this.rotate) {
            GL11.glRotatef((float)(celestialAngle * 360.0f * this.speed), (float)this.axis[0], (float)this.axis[1], (float)this.axis[2]);
        }
        baz tess = baz.a;
        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.renderSide(tess, 4);
        GL11.glPushMatrix();
        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        this.renderSide(tess, 1);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        this.renderSide(tess, 0);
        GL11.glPopMatrix();
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.renderSide(tess, 5);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.renderSide(tess, 2);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.renderSide(tess, 3);
        GL11.glPopMatrix();
    }

    private float getFadeBrightness(int timeOfDay) {
        if (this.timeBetween(timeOfDay, this.startFadeIn, this.endFadeIn)) {
            int timeFadeIn = this.normalizeTime(this.endFadeIn - this.startFadeIn);
            int timeDiff = this.normalizeTime(timeOfDay - this.startFadeIn);
            return (float)timeDiff / (float)timeFadeIn;
        }
        if (this.timeBetween(timeOfDay, this.endFadeIn, this.startFadeOut)) {
            return 1.0f;
        }
        if (this.timeBetween(timeOfDay, this.startFadeOut, this.endFadeOut)) {
            int timeFadeOut = this.normalizeTime(this.endFadeOut - this.startFadeOut);
            int timeDiff = this.normalizeTime(timeOfDay - this.startFadeOut);
            return 1.0f - (float)timeDiff / (float)timeFadeOut;
        }
        return 0.0f;
    }

    private void renderSide(baz tess, int side) {
        double tx2 = (double)(side % 3) / 3.0;
        double ty2 = (double)(side / 3) / 2.0;
        tess.b();
        tess.a(-100.0, -100.0, -100.0, tx2, ty2);
        tess.a(-100.0, -100.0, 100.0, tx2, ty2 + 0.5);
        tess.a(100.0, -100.0, 100.0, tx2 + 0.3333333333333333, ty2 + 0.5);
        tess.a(100.0, -100.0, -100.0, tx2 + 0.3333333333333333, ty2);
        tess.a();
    }

    void setupBlend(float brightness) {
        switch (this.blend) {
            case 0: {
                GL11.glDisable((int)3008);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)1);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)brightness);
                break;
            }
            case 1: {
                GL11.glDisable((int)3008);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)775, (int)0);
                GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
                break;
            }
            case 2: {
                GL11.glDisable((int)3008);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)774, (int)771);
                GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)brightness);
                break;
            }
            case 3: {
                GL11.glDisable((int)3008);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)1, (int)1);
                GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
                break;
            }
            case 4: {
                GL11.glDisable((int)3008);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)0, (int)769);
                GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
                break;
            }
            case 5: {
                GL11.glDisable((int)3008);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)1, (int)769);
                GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
                break;
            }
            case 6: {
                GL11.glEnable((int)3008);
                GL11.glDisable((int)3042);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)brightness);
            }
        }
        GL11.glEnable((int)3553);
    }

    public boolean isActive(int timeOfDay) {
        return !this.timeBetween(timeOfDay, this.endFadeOut, this.startFadeIn);
    }

    private boolean timeBetween(int timeOfDay, int timeStart, int timeEnd) {
        if (timeStart <= timeEnd) {
            return timeOfDay >= timeStart && timeOfDay <= timeEnd;
        }
        return timeOfDay >= timeStart || timeOfDay <= timeEnd;
    }
}

