/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launchwrapper;

import java.io.File;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.launchwrapper.ITweaker;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;

public class VanillaTweaker
implements ITweaker {
    private static final int MCDIR_REQUIRED_BITMASK = 10;
    private List<String> args;

    @Override
    public void acceptOptions(List<String> args, File gameDir, File assetsDir, String profile) {
        this.args = args;
    }

    @Override
    public void injectIntoClassLoader(LaunchClassLoader classLoader) {
        classLoader.registerTransformer("net.minecraft.launchwrapper.injector.VanillaTweakInjector");
    }

    @Override
    public String getLaunchTarget() {
        try {
            Class<?> mcClass = Class.forName("net.minecraft.client.Minecraft");
            for (Field field : mcClass.getDeclaredFields()) {
                int modifiers = field.getModifiers();
                if ((modifiers & 0xA) != 10 || !field.getType().equals(File.class)) continue;
                field.setAccessible(true);
                field.set(null, Launch.minecraftHome);
                return "net.minecraft.client.Minecraft";
            }
            throw new RuntimeException("Can't find minecraft home dir field");
        }
        catch (ClassNotFoundException | IllegalAccessException e) {
            throw new RuntimeException("Something gone wrong", e);
        }
    }

    @Override
    public String[] getLaunchArguments() {
        return this.args.toArray(new String[this.args.size()]);
    }
}

